/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

@ThriftStruct
public class HashCollisionsInfo
implements Mergeable<HashCollisionsInfo>,
OperatorInfo {
    public static final String WEIGHTED_HASH_COLLISIONS_PROPERTY = "weightedHashCollisions";
    public static final String WEIGHTED_SUM_SQUARED_HASH_COLLISIONS = "weightedSumSquaredHashCollisions";
    public static final String WEIGHTED_EXPECTED_HASH_COLLISIONS = "weightedExpectedHashCollisions";
    private final double weightedHashCollisions;
    private final double weightedSumSquaredHashCollisions;
    private final double weightedExpectedHashCollisions;

    public static HashCollisionsInfo createHashCollisionsInfo(long inputPositionsCount, double hashCollisionsCount, double expectedHashCollisions) {
        return new HashCollisionsInfo(hashCollisionsCount * (double)inputPositionsCount, hashCollisionsCount * hashCollisionsCount * (double)inputPositionsCount, expectedHashCollisions * (double)inputPositionsCount);
    }

    @JsonCreator
    @ThriftConstructor
    public HashCollisionsInfo(@JsonProperty(value="weightedHashCollisions") double weightedHashCollisions, @JsonProperty(value="weightedSumSquaredHashCollisions") double weightedSumSquaredHashCollisions, @JsonProperty(value="weightedExpectedHashCollisions") double weightedExpectedHashCollisions) {
        this.weightedHashCollisions = weightedHashCollisions;
        this.weightedSumSquaredHashCollisions = weightedSumSquaredHashCollisions;
        this.weightedExpectedHashCollisions = weightedExpectedHashCollisions;
    }

    @JsonProperty
    @ThriftField(value=1)
    public double getWeightedSumSquaredHashCollisions() {
        return this.weightedSumSquaredHashCollisions;
    }

    @JsonProperty
    @ThriftField(value=2)
    public double getWeightedHashCollisions() {
        return this.weightedHashCollisions;
    }

    @JsonProperty
    @ThriftField(value=3)
    public double getWeightedExpectedHashCollisions() {
        return this.weightedExpectedHashCollisions;
    }

    @Override
    public HashCollisionsInfo mergeWith(HashCollisionsInfo other) {
        return new HashCollisionsInfo(this.weightedHashCollisions + other.getWeightedHashCollisions(), this.weightedSumSquaredHashCollisions + other.getWeightedSumSquaredHashCollisions(), this.weightedExpectedHashCollisions + other.getWeightedExpectedHashCollisions());
    }
}

