/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.operator.aggregation.Adder;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public abstract class MapUnionSumResult {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapUnionSumResult.class).instanceSize();
    private static final int EXPECTED_ENTRIES = 10;
    private static final int EXPECTED_ENTRY_SIZE = 16;
    protected final Type keyType;
    protected final Type valueType;
    protected final Adder adder;

    public MapUnionSumResult(Type keyType, Type valueType, Adder adder) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        this.adder = adder;
    }

    abstract int size();

    abstract void addKey(int var1, BlockBuilder var2);

    abstract void appendValue(int var1, BlockBuilder var2);

    abstract boolean isValueNull(int var1);

    public abstract long getRetainedSizeInBytes();

    abstract void addKeyToSet(TypedSet var1, int var2);

    abstract int getPosition(TypedSet var1, int var2);

    abstract TypedSet getKeySet();

    abstract Block getValueBlock();

    abstract int getValueBlockIndex(int var1);

    public static MapUnionSumResult create(Type keyType, Type valueType, Adder adder, Block mapBlock) {
        return new SingleMapBlock(keyType, valueType, adder, mapBlock);
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder mapBlockBuilder = out.beginBlockEntry();
        for (int i = 0; i < this.size(); ++i) {
            this.addKey(i, mapBlockBuilder);
            this.appendValue(i, mapBlockBuilder);
        }
        out.closeEntry();
    }

    static void appendValue(Type valueType, Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            if (TypeUtils.isExactNumericType((Type)valueType) || valueType instanceof RealType) {
                valueType.writeLong(blockBuilder, 0L);
            } else {
                valueType.writeDouble(blockBuilder, 0.0);
            }
        } else {
            valueType.appendTo(block, position, blockBuilder);
        }
    }

    public MapUnionSumResult unionSum(MapUnionSumResult other) {
        int i;
        if (other instanceof KeySetAndValues && (this instanceof SingleMapBlock || this.size() < other.size())) {
            return other.unionSum(this);
        }
        TypedSet resultKeySet = this.getKeySet();
        int size = this.size();
        int otherSize = other.size();
        int[] otherKeyIndex = new int[size];
        boolean[] toAppend = new boolean[otherSize];
        boolean[] common = new boolean[size];
        boolean remaining = false;
        BlockBuilder resultValueBlockBuilder = this.valueType.createBlockBuilder(null, Math.max(this.size(), other.size()), com.facebook.presto.type.TypeUtils.expectedValueSize(this.valueType, 16));
        for (i = 0; i < otherSize; ++i) {
            int position = other.getPosition(resultKeySet, i);
            if (position >= 0) {
                otherKeyIndex[position] = i;
                common[position] = true;
                continue;
            }
            toAppend[i] = true;
            if (remaining) continue;
            remaining = true;
        }
        for (i = 0; i < size; ++i) {
            if (common[i]) {
                if (!this.isValueNull(i) && !other.isValueNull(otherKeyIndex[i])) {
                    this.adder.writeSum(this.valueType, this.getValueBlock(), this.getValueBlockIndex(i), other.getValueBlock(), other.getValueBlockIndex(otherKeyIndex[i]), resultValueBlockBuilder);
                    continue;
                }
                if (!this.isValueNull(i)) {
                    this.appendValue(i, resultValueBlockBuilder);
                    continue;
                }
                other.appendValue(otherKeyIndex[i], resultValueBlockBuilder);
                continue;
            }
            this.appendValue(i, resultValueBlockBuilder);
        }
        if (remaining) {
            for (i = 0; i < otherSize; ++i) {
                if (!toAppend[i]) continue;
                other.addKeyToSet(resultKeySet, i);
                other.appendValue(i, resultValueBlockBuilder);
            }
        }
        Preconditions.checkState((resultKeySet.size() == resultValueBlockBuilder.getPositionCount() ? 1 : 0) != 0);
        return new KeySetAndValues(this.keyType, this.valueType, this.adder, resultKeySet, resultValueBlockBuilder.build());
    }

    public MapUnionSumResult unionSum(Block mapBlock) {
        SingleMapBlock mapUnionSumResult = new SingleMapBlock(this.keyType, this.valueType, this.adder, mapBlock);
        return this.unionSum(mapUnionSumResult);
    }

    private static class KeySetAndValues
    extends MapUnionSumResult {
        private final TypedSet keySet;
        private final Block valueBlock;

        KeySetAndValues(Type keyType, Type valueType, Adder adder, TypedSet keySet, Block valueBlock) {
            super(keyType, valueType, adder);
            this.keySet = keySet;
            this.valueBlock = valueBlock;
        }

        @Override
        int size() {
            return this.keySet.size();
        }

        @Override
        void addKeyToSet(TypedSet otherKeyset, int i) {
            otherKeyset.add((Block)this.keySet.getBlockBuilder(), i);
        }

        @Override
        void addKey(int i, BlockBuilder out) {
            this.keyType.appendTo((Block)this.keySet.getBlockBuilder(), i, out);
        }

        @Override
        void appendValue(int i, BlockBuilder blockBuilder) {
            KeySetAndValues.appendValue(this.valueType, this.valueBlock, i, blockBuilder);
        }

        @Override
        boolean isValueNull(int i) {
            return this.valueBlock.isNull(i);
        }

        @Override
        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.keySet.getRetainedSizeInBytes() + this.valueBlock.getRetainedSizeInBytes();
        }

        @Override
        int getPosition(TypedSet otherKeySet, int keyPosition) {
            return otherKeySet.positionOf((Block)this.keySet.getBlockBuilder(), keyPosition);
        }

        @Override
        TypedSet getKeySet() {
            return this.keySet;
        }

        @Override
        Block getValueBlock() {
            return this.valueBlock;
        }

        @Override
        int getValueBlockIndex(int i) {
            return i;
        }
    }

    private static class SingleMapBlock
    extends MapUnionSumResult {
        private final Block mapBlock;

        public SingleMapBlock(Type keyType, Type valueType, Adder adder, Block mapBlock) {
            super(keyType, valueType, adder);
            this.mapBlock = mapBlock;
        }

        @Override
        int size() {
            return this.mapBlock.getPositionCount() / 2;
        }

        @Override
        void addKeyToSet(TypedSet keySet, int i) {
            keySet.add(this.mapBlock, 2 * i);
        }

        @Override
        void addKey(int i, BlockBuilder out) {
            this.keyType.appendTo(this.mapBlock, 2 * i, out);
        }

        @Override
        void appendValue(int i, BlockBuilder blockBuilder) {
            SingleMapBlock.appendValue(this.valueType, this.mapBlock, 2 * i + 1, blockBuilder);
        }

        @Override
        boolean isValueNull(int i) {
            return this.mapBlock.isNull(2 * i + 1);
        }

        @Override
        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE;
        }

        @Override
        int getPosition(TypedSet otherKeySet, int keyPosition) {
            return otherKeySet.positionOf(this.mapBlock, 2 * keyPosition);
        }

        @Override
        TypedSet getKeySet() {
            TypedSet resultKeySet = new TypedSet(this.keyType, this.mapBlock.getPositionCount() / 2, "MAP_UNION_SUM");
            for (int i = 0; i < this.mapBlock.getPositionCount(); i += 2) {
                resultKeySet.add(this.mapBlock, i);
            }
            return resultKeySet;
        }

        @Override
        Block getValueBlock() {
            return this.mapBlock;
        }

        @Override
        int getValueBlockIndex(int i) {
            return 2 * i + 1;
        }
    }
}

