/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.operator.aggregation.StatisticalDigest;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.tdigest.TDigest;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public class StatisticalDigestFactory {
    private StatisticalDigestFactory() {
    }

    public static StatisticalDigest createStatisticalTDigest(TDigest tDigest) {
        return new StatisticalTDigest(tDigest);
    }

    public static StatisticalDigest createStatisticalQuantileDigest(QuantileDigest quantileDigest) {
        return new StatisticalQuantileDigest(quantileDigest);
    }

    public static class StatisticalQuantileDigest
    implements StatisticalDigest<QuantileDigest> {
        private final QuantileDigest qdigest;

        public StatisticalQuantileDigest(QuantileDigest qdigest) {
            this.qdigest = qdigest;
        }

        @Override
        public void add(long value, long weight) {
            this.qdigest.add(value, weight);
        }

        @Override
        public void merge(StatisticalDigest other) {
            try {
                Preconditions.checkArgument((boolean)(other instanceof StatisticalQuantileDigest));
                StatisticalQuantileDigest toMerge = (StatisticalQuantileDigest)other;
                this.qdigest.merge(toMerge.qdigest);
            }
            catch (IllegalArgumentException ex) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, ex.getMessage(), (Throwable)ex);
            }
        }

        @Override
        public double getSize() {
            return this.qdigest.getCount();
        }

        @Override
        public long estimatedInMemorySizeInBytes() {
            return this.qdigest.estimatedInMemorySizeInBytes();
        }

        @Override
        public Slice serialize() {
            return this.qdigest.serialize();
        }

        @Override
        public StatisticalDigest<QuantileDigest> getDigest() {
            return this;
        }
    }

    public static class StatisticalTDigest
    implements StatisticalDigest<TDigest> {
        private final TDigest tDigest;

        public StatisticalTDigest(TDigest tDigest) {
            this.tDigest = tDigest;
        }

        @Override
        public void add(double value, long weight) {
            this.tDigest.add(value, weight);
        }

        @Override
        public void merge(StatisticalDigest other) {
            try {
                Preconditions.checkArgument((boolean)(other instanceof StatisticalTDigest));
                StatisticalTDigest toMerge = (StatisticalTDigest)other;
                this.tDigest.merge(toMerge.tDigest);
            }
            catch (IllegalArgumentException ex) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, ex.getMessage(), (Throwable)ex);
            }
        }

        @Override
        public double getSize() {
            return this.tDigest.getSize();
        }

        @Override
        public long estimatedInMemorySizeInBytes() {
            return this.tDigest.estimatedInMemorySizeInBytes();
        }

        @Override
        public Slice serialize() {
            return this.tDigest.serialize();
        }

        @Override
        public StatisticalDigest<TDigest> getDigest() {
            return this;
        }
    }
}

