/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.SecureRandomGeneration;
import java.util.Random;

public class NoisyCountAggregationUtils {
    private NoisyCountAggregationUtils() {
    }

    public static void updateState(NoisyCountState state, double noiseScale, Long randomSeed) {
        NoisyCountAggregationUtils.checkNoiseScale(noiseScale);
        state.setCount(state.getCount() + 1L);
        state.setNoiseScale(noiseScale);
        if (randomSeed == null) {
            state.setNullRandomSeed(true);
        } else {
            state.setNullRandomSeed(false);
            state.setRandomSeed(randomSeed);
        }
    }

    public static void combineStates(NoisyCountState state, NoisyCountState otherState) {
        state.setNoiseScale(state.getNoiseScale() > 0.0 ? state.getNoiseScale() : otherState.getNoiseScale());
        NoisyCountAggregationUtils.checkNoiseScale(state.getNoiseScale());
        state.setCount(state.getCount() + otherState.getCount());
        if (state.isNullRandomSeed()) {
            state.setNullRandomSeed(otherState.isNullRandomSeed());
            state.setRandomSeed(otherState.getRandomSeed());
        }
    }

    public static void writeNoisyCountOutput(NoisyCountState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
            return;
        }
        double noise = NoisyCountAggregationUtils.getNoise(state);
        long noisyCount = NoisyCountAggregationUtils.computeNoisyCount(state, noise);
        BigintType.BIGINT.writeLong(out, noisyCount);
    }

    public static double getNoise(NoisyCountState state) {
        Random random = SecureRandomGeneration.getNonBlocking();
        if (!state.isNullRandomSeed()) {
            random = new Random(state.getRandomSeed());
        }
        double noiseSdv = state.getNoiseScale();
        return random.nextGaussian() * noiseSdv;
    }

    public static void checkNoiseScale(double noiseScale) {
        if (noiseScale < 0.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Noise scale must be >= 0");
        }
    }

    public static long computeNoisyCount(NoisyCountState state, double noise) {
        long trueCount = state.getCount();
        double noisyCount = (double)trueCount + noise;
        double noisyCountFixedSign = Math.max(noisyCount, 0.0);
        return Math.round(noisyCountFixedSign);
    }
}

