/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountAggregationUtils;
import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;

@AggregationFunction(value="noisy_count_if_gaussian", isCalledOnNullInput=true)
public final class NoisyCountIfGaussianAggregation {
    private NoisyCountIfGaussianAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState NoisyCountState state, @SqlType(value="boolean") boolean value, @SqlType(value="double") double noiseScale) {
        if (value) {
            NoisyCountAggregationUtils.updateState(state, noiseScale, null);
        }
    }

    @InputFunction
    public static void input(@AggregationState NoisyCountState state, @SqlType(value="boolean") boolean value, @SqlType(value="double") double noiseScale, @SqlType(value="bigint") long randomSeed) {
        if (value) {
            NoisyCountAggregationUtils.updateState(state, noiseScale, randomSeed);
        }
    }

    @CombineFunction
    public static void combine(@AggregationState NoisyCountState state, @AggregationState NoisyCountState otherState) {
        NoisyCountAggregationUtils.combineStates(state, otherState);
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NoisyCountState state, BlockBuilder out) {
        NoisyCountAggregationUtils.writeNoisyCountOutput(state, out);
    }
}

