/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchState;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.GroupedAccumulatorState;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SfmSketchStateFactory
implements AccumulatorStateFactory<SfmSketchState> {
    public SfmSketchState createSingleState() {
        return new SingleSfmSketchState();
    }

    public Class<? extends SfmSketchState> getSingleStateClass() {
        return SingleSfmSketchState.class;
    }

    public SfmSketchState createGroupedState() {
        return new GroupedSfmSketchState();
    }

    public Class<? extends SfmSketchState> getGroupedStateClass() {
        return GroupedSfmSketchState.class;
    }

    public static class SingleSfmSketchState
    implements SfmSketchState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleSfmSketchState.class).instanceSize();
        private SfmSketch sketch;
        private double epsilon;

        @Override
        public SfmSketch getSketch() {
            return this.sketch;
        }

        @Override
        public void mergeSketch(SfmSketch value) {
            Objects.requireNonNull(value, "value is null");
            this.sketch.mergeWith(value);
        }

        @Override
        public void setSketch(SfmSketch value) {
            this.sketch = value;
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.sketch != null) {
                estimatedSize += this.sketch.getRetainedSizeInBytes();
            }
            return estimatedSize;
        }

        @Override
        public void setEpsilon(double value) {
            this.epsilon = value;
        }

        @Override
        public double getEpsilon() {
            return this.epsilon;
        }
    }

    public static class GroupedSfmSketchState
    implements SfmSketchState,
    GroupedAccumulatorState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedSfmSketchState.class).instanceSize();
        private final ObjectBigArray<SfmSketch> sketches = new ObjectBigArray();
        private final ObjectBigArray<Double> epsilons = new ObjectBigArray();
        private long retainedBytes;
        private long groupId;

        public final void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        protected final long getGroupId() {
            return this.groupId;
        }

        public void ensureCapacity(long size) {
            this.epsilons.ensureCapacity(size);
            this.sketches.ensureCapacity(size);
        }

        @Override
        public SfmSketch getSketch() {
            return (SfmSketch)this.sketches.get(this.getGroupId());
        }

        @Override
        public void mergeSketch(SfmSketch value) {
            Objects.requireNonNull(value, "value is null");
            this.retainedBytes -= this.getSketch().getRetainedSizeInBytes();
            this.getSketch().mergeWith(value);
            this.retainedBytes += this.getSketch().getRetainedSizeInBytes();
        }

        @Override
        public void setSketch(SfmSketch value) {
            Objects.requireNonNull(value, "value is null");
            if (this.getSketch() != null) {
                this.retainedBytes -= this.getSketch().getRetainedSizeInBytes();
            }
            this.sketches.set(this.getGroupId(), (Object)value);
            this.retainedBytes += value.getRetainedSizeInBytes();
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.retainedBytes + this.sketches.sizeOf() + this.epsilons.sizeOf();
        }

        @Override
        public void setEpsilon(double value) {
            this.epsilons.set(this.getGroupId(), (Object)value);
        }

        @Override
        public double getEpsilon() {
            return (Double)this.epsilons.get(this.getGroupId());
        }
    }
}

