/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.reservoirsample;

import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.reservoirsample.SingleReservoirSampleState;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class ReservoirSample {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleReservoirSampleState.class).instanceSize();
    private final Type type;
    private final Type arrayType;
    private ArrayList<Block> samples;
    private int maxSampleSize = -1;
    private long processedCount;
    private Block initialSample;
    private long initialProcessedCount = -1L;

    public Type getArrayType() {
        return this.arrayType;
    }

    public Block getInitialSample() {
        return this.initialSample;
    }

    public long getInitialProcessedCount() {
        return this.initialProcessedCount;
    }

    public ReservoirSample(Type type) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.arrayType = new ArrayType(type);
        this.samples = new ArrayList();
    }

    protected ReservoirSample(Type type, long processedCount, int maxSampleSize, Block samples, Block initialSample, long initialSeenCount) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.arrayType = new ArrayType(type);
        this.processedCount = processedCount;
        this.samples = ReservoirSample.blockToList(samples);
        this.maxSampleSize = maxSampleSize;
        this.initializeInitialSample(initialSample, initialSeenCount);
    }

    private static ArrayList<Block> blockToList(Block inputBlock) {
        Function<Integer, Block> extractor = inputBlock instanceof ArrayBlock ? arg_0 -> ((Block)inputBlock).getBlock(arg_0) : arg_0 -> ((Block)inputBlock).getSingleValueBlock(arg_0);
        return IntStream.range(0, inputBlock.getPositionCount()).mapToObj(extractor::apply).collect(Collectors.toCollection(ArrayList::new));
    }

    private static ArrayList<Block> mergeBlockSamples(ArrayList<Block> samples1, ArrayList<Block> samples2, long seenCount1, long seenCount2) {
        int nextIndex = 0;
        int otherNextIndex = 0;
        ArrayList<Block> merged = new ArrayList<Block>(samples1.size());
        for (int i = 0; i < samples1.size(); ++i) {
            if (ThreadLocalRandom.current().nextLong(0L, seenCount1 + seenCount2) < seenCount1) {
                merged.add(samples1.get(nextIndex++));
                continue;
            }
            merged.add(samples2.get(otherNextIndex++));
        }
        return merged;
    }

    public void tryInitialize(int n) {
        if (this.sampleNotInitialized()) {
            this.samples = new ArrayList(Math.max(n, 0));
            this.maxSampleSize = n;
        }
    }

    public void initializeInitialSample(@Nullable Block initialSample, long initialProcessedCount) {
        if (this.initialProcessedCount < 0L) {
            if (initialSample != null && initialSample.getPositionCount() > 0) {
                Preconditions.checkArgument((initialProcessedCount >= (long)initialSample.getPositionCount() ? 1 : 0) != 0, (Object)"initialProcessedCount must be greater than or equal to the number of positions in the initial sample");
            }
            this.initialSample = initialSample;
            this.initialProcessedCount = initialProcessedCount;
        }
    }

    public void mergeWith(@Nullable ReservoirSample other) {
        if (other == null) {
            return;
        }
        this.merge(other);
        this.initializeInitialSample(other.initialSample, other.initialProcessedCount);
    }

    private boolean sampleNotInitialized() {
        return this.maxSampleSize < 0 || this.samples == null;
    }

    public int getSampleSize() {
        if (this.sampleNotInitialized()) {
            return 0;
        }
        return this.samples.size();
    }

    public int getMaxSampleSize() {
        return this.maxSampleSize;
    }

    public void add(Block block, int position) {
        if (this.sampleNotInitialized()) {
            throw new IllegalArgumentException("reservoir sample not properly initialized");
        }
        ++this.processedCount;
        int sampleSize = this.getMaxSampleSize();
        if (this.processedCount <= (long)sampleSize) {
            BlockBuilder sampleBlock = this.type.createBlockBuilder(null, 1);
            this.type.appendTo(block, position, sampleBlock);
            this.samples.add(sampleBlock.build());
        } else {
            long index = ThreadLocalRandom.current().nextLong(0L, this.processedCount);
            if (index < (long)this.samples.size()) {
                BlockBuilder sampleBlock = this.type.createBlockBuilder(null, 1);
                this.type.appendTo(block, position, sampleBlock);
                this.samples.set((int)index, sampleBlock.build());
            }
        }
    }

    private void addSingleBlock(Block block) {
        ++this.processedCount;
        int sampleSize = this.getMaxSampleSize();
        if (this.processedCount <= (long)sampleSize) {
            this.samples.add(block);
        } else {
            long index = ThreadLocalRandom.current().nextLong(0L, this.processedCount);
            if (index < (long)this.samples.size()) {
                this.samples.set((int)index, block);
            }
        }
    }

    public void merge(ReservoirSample other) {
        if (this.sampleNotInitialized()) {
            this.tryInitialize(other.getMaxSampleSize());
        }
        if (other.sampleNotInitialized()) {
            return;
        }
        Preconditions.checkArgument((this.getMaxSampleSize() == other.getMaxSampleSize() ? 1 : 0) != 0, (Object)String.format("maximum number of samples %s must be equal to that of other %s", this.getMaxSampleSize(), other.getMaxSampleSize()));
        if (other.processedCount < (long)this.getMaxSampleSize()) {
            for (int i = 0; i < other.samples.size(); ++i) {
                this.addSingleBlock(other.samples.get(i));
            }
            return;
        }
        if (this.processedCount < (long)this.getMaxSampleSize()) {
            int i = 0;
            while ((long)i < this.processedCount) {
                other.addSingleBlock(this.samples.get(i));
                ++i;
            }
            this.processedCount = other.processedCount;
            this.samples = other.samples;
            return;
        }
        Collections.shuffle(this.samples);
        Collections.shuffle(other.samples);
        this.samples = ReservoirSample.mergeBlockSamples(this.samples, other.samples, this.processedCount, other.processedCount);
        this.processedCount += other.processedCount;
    }

    public Type getType() {
        return this.type;
    }

    public long getProcessedCount() {
        return this.processedCount;
    }

    public long estimatedInMemorySize() {
        return (long)INSTANCE_SIZE + (this.initialSample != null ? this.initialSample.getSizeInBytes() : 0L) + SizeOf.sizeOfObjectArray((int)this.samples.size());
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder sampleBlock = this.getSampleBlockBuilder();
        if (this.initialSample == null) {
            out.appendNull();
        } else {
            out.appendStructure(this.initialSample);
        }
        BigintType.BIGINT.writeLong(out, this.initialProcessedCount);
        BigintType.BIGINT.writeLong(out, this.processedCount);
        IntegerType.INTEGER.writeLong(out, (long)this.maxSampleSize);
        this.arrayType.appendTo(sampleBlock.build(), 0, out);
    }

    BlockBuilder getSampleBlockBuilder() {
        int sampleSize = this.getSampleSize();
        BlockBuilder sampleBlock = this.arrayType.createBlockBuilder(null, sampleSize);
        BlockBuilder sampleEntryBuilder = sampleBlock.beginBlockEntry();
        for (int i = 0; i < sampleSize; ++i) {
            this.type.appendTo(this.samples.get(i), 0, sampleEntryBuilder);
        }
        sampleBlock.closeEntry();
        return sampleBlock;
    }
}

