/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.sketch.kll;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.sketch.kll.KllSketchStateFactory;
import com.facebook.presto.operator.aggregation.sketch.kll.KllSketchStateSerializer;
import com.facebook.presto.operator.aggregation.sketch.theta.ThetaSketchStateFactory;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateMetadata;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.kll.KllItemsSketch;
import org.openjdk.jol.info.ClassLayout;

@AccumulatorStateMetadata(stateFactoryClass=KllSketchStateFactory.class, stateSerializerClass=KllSketchStateSerializer.class)
public interface KllSketchAggregationState
extends AccumulatorState {
    public static final Map<Class<?>, double[]> SIZE_ESTIMATOR_PARAMETERS = ImmutableMap.builder().put(Double.TYPE, (Object)new double[]{929.0746716729514, 3.3328879969131457}).put(Long.TYPE, (Object)new double[]{929.920850240635, 3.3325974295999283}).put(Slice.class, (Object)new double[]{1008.5483794752541, 4.234749475485517}).put(Boolean.TYPE, (Object)new double[]{345.60095530779705, 14.12193288555095}).build();
    public static final long SKETCH_INSTANCE_SIZE = ClassLayout.parseClass(KllItemsSketch.class).instanceSize();

    @Nullable
    public <T> KllItemsSketch<T> getSketch();

    public void addMemoryUsage(Supplier<Long> var1);

    public Type getType();

    public <T> void setSketch(KllItemsSketch<T> var1);

    public static long getEstimatedKllInMemorySize(@Nullable KllItemsSketch<?> sketch, Class<?> type) {
        if (sketch == null) {
            return 0L;
        }
        double[] parameters = SIZE_ESTIMATOR_PARAMETERS.get(type);
        if (parameters == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "unsupported parameter class: " + type.getName());
        }
        double linear = parameters[1];
        double constant = parameters[0];
        return (long)(linear * (double)sketch.getSerializedSizeBytes() + constant);
    }

    public static SketchParameters<?> getSketchParameters(Type type) {
        if (type.getJavaType().equals(Double.TYPE)) {
            return new SketchParameters(Double::compareTo, new ArrayOfDoublesSerDe());
        }
        if (type.getJavaType().equals(Long.TYPE)) {
            return new SketchParameters(Long::compareTo, new ArrayOfLongsSerDe());
        }
        if (type.getJavaType().equals(Slice.class)) {
            return new SketchParameters(String::compareTo, new ArrayOfStringsSerDe());
        }
        if (type.getJavaType().equals(Boolean.TYPE)) {
            return new SketchParameters(Boolean::compareTo, new ArrayOfBooleansSerDe());
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "failed to deserialize KLL Sketch. No suitable type found for " + type);
    }

    public static class Grouped
    extends AbstractGroupedAccumulatorState
    implements KllSketchAggregationState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(ThetaSketchStateFactory.GroupedThetaSketchState.class).instanceSize();
        private final ObjectBigArray<KllItemsSketch> sketches = new ObjectBigArray();
        private long accumulatedSizeInBytes;
        private final Type type;

        public Grouped(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Override
        public <T> KllItemsSketch<T> getSketch() {
            return (KllItemsSketch)this.sketches.get(this.getGroupId());
        }

        @Override
        public void addMemoryUsage(Supplier<Long> usage) {
            this.accumulatedSizeInBytes += usage.get().longValue();
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public <T> void setSketch(KllItemsSketch<T> sketch) {
            this.sketches.set(this.getGroupId(), Objects.requireNonNull(sketch, "kll sketch is null"));
        }

        public long getEstimatedSize() {
            return this.sketches.sizeOf() + (long)INSTANCE_SIZE + this.accumulatedSizeInBytes;
        }

        public void ensureCapacity(long size) {
            this.sketches.ensureCapacity(size);
        }
    }

    public static class Single
    implements KllSketchAggregationState {
        private static final long INSTANCE_SIZE = ClassLayout.parseClass(Single.class).instanceSize();
        @Nullable
        private KllItemsSketch sketch;
        private final Type type;

        public Single(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Override
        public <T> KllItemsSketch<T> getSketch() {
            return this.sketch;
        }

        @Override
        public <T> void setSketch(KllItemsSketch<T> sketch) {
            this.sketch = sketch;
        }

        @Override
        public void addMemoryUsage(Supplier<Long> usage) {
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public long getEstimatedSize() {
            if (this.sketch != null) {
                return SKETCH_INSTANCE_SIZE + INSTANCE_SIZE + KllSketchAggregationState.getEstimatedKllInMemorySize(this.sketch, this.type.getJavaType());
            }
            return INSTANCE_SIZE;
        }
    }

    public static class SketchParameters<T> {
        private final Comparator<T> comparator;
        private final ArrayOfItemsSerDe<T> serde;

        public SketchParameters(Comparator<T> comparator, ArrayOfItemsSerDe<T> serde) {
            this.comparator = comparator;
            this.serde = serde;
        }

        public Comparator<T> getComparator() {
            return this.comparator;
        }

        public ArrayOfItemsSerDe<T> getSerde() {
            return this.serde;
        }
    }
}

