/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.repartition;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.PageSplitterUtil;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.repartition.PartitionedOutputInfo;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class PartitionedOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final Function<Page, Page> pagePreprocessor;
    private final PagePartitioner partitionFunction;
    private ListenableFuture<?> isBlocked = NOT_BLOCKED;
    private boolean finished;

    public PartitionedOutputOperator(OperatorContext operatorContext, List<Type> sourceTypes, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, DataSize maxMemory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.partitionFunction = new PagePartitioner(partitionFunction, partitionChannels, partitionConstants, replicatesAnyRow, nullChannel, outputBuffer, serdeFactory, sourceTypes, maxMemory, operatorContext);
        operatorContext.setInfoSupplier(this.partitionFunction.getPartitionedOutputInfoSupplier());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finished = true;
        this.partitionFunction.flush(true);
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.partitionFunction.isFull();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        page = this.pagePreprocessor.apply(page);
        this.partitionFunction.partitionPage(page);
    }

    @Override
    public Page getOutput() {
        return null;
    }

    @Override
    public void close() {
        this.partitionFunction.zeroMemoryContext();
    }

    private static class PagePartitioner {
        private final OutputBuffer outputBuffer;
        private final Type[] sourceTypes;
        private final PartitionFunction partitionFunction;
        private final int[] partitionChannels;
        @Nullable
        private final Block[] partitionConstantBlocks;
        private final PagesSerde serde;
        private final PageBuilder[] pageBuilders;
        private final boolean replicatesAnyRow;
        private final int nullChannel;
        private final AtomicLong rowsAdded = new AtomicLong();
        private final AtomicLong pagesAdded = new AtomicLong();
        private boolean hasAnyRowBeenReplicated;
        private final OperatorContext operatorContext;
        private final LocalMemoryContext systemMemoryContext;

        public PagePartitioner(PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, List<Type> sourceTypes, DataSize maxMemory, OperatorContext operatorContext) {
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Ints.toArray((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            Block[] partitionConstantBlocks = (Block[])Objects.requireNonNull(partitionConstants, "partitionConstants is null").stream().map(constant -> constant.map(ConstantExpression::getValueBlock).orElse(null)).toArray(Block[]::new);
            this.partitionConstantBlocks = Arrays.stream(partitionConstantBlocks).anyMatch(Objects::nonNull) ? partitionConstantBlocks : null;
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null").orElse(-1);
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null").toArray(new Type[0]);
            this.serde = Objects.requireNonNull(serdeFactory, "serdeFactory is null").createPagesSerde();
            this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
            this.systemMemoryContext = operatorContext.localSystemMemoryContext();
            this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
            for (int i = 0; i < this.partitionChannels.length; ++i) {
                if (this.partitionChannels[i] >= 0) continue;
                Preconditions.checkArgument((this.partitionConstantBlocks != null && this.partitionConstantBlocks[i] != null ? 1 : 0) != 0, (String)"Expected constant for partitioning channel %s, but none was found", (int)i);
            }
            int partitionCount = partitionFunction.getPartitionCount();
            int pageSize = Math.min(0x100000, (int)maxMemory.toBytes() / partitionCount);
            pageSize = Math.max(1, pageSize);
            this.pageBuilders = new PageBuilder[partitionCount];
            for (int i = 0; i < partitionCount; ++i) {
                this.pageBuilders[i] = PageBuilder.withMaxPageSize((int)pageSize, sourceTypes);
            }
        }

        public void zeroMemoryContext() {
            this.systemMemoryContext.setBytes(0L);
        }

        public ListenableFuture<?> isFull() {
            return this.outputBuffer.isFull();
        }

        public long getSizeInBytes() {
            long sizeInBytes = this.serde.getSizeInBytes();
            if (this.pageBuilders != null) {
                for (PageBuilder pageBuilder : this.pageBuilders) {
                    sizeInBytes += pageBuilder.getSizeInBytes();
                }
            }
            return sizeInBytes;
        }

        public long getRetainedSizeInBytes() {
            long sizeInBytes = this.serde.getRetainedSizeInBytes();
            if (this.pageBuilders != null) {
                for (PageBuilder pageBuilder : this.pageBuilders) {
                    sizeInBytes += pageBuilder.getRetainedSizeInBytes();
                }
            }
            return sizeInBytes;
        }

        public Supplier<PartitionedOutputInfo> getPartitionedOutputInfoSupplier() {
            return PartitionedOutputInfo.createPartitionedOutputInfoSupplier(this.rowsAdded, this.pagesAdded, this.outputBuffer);
        }

        public void partitionPage(Page page) {
            int position;
            Objects.requireNonNull(page, "page is null");
            if (page.getPositionCount() == 0) {
                return;
            }
            if (this.replicatesAnyRow && !this.hasAnyRowBeenReplicated) {
                for (PageBuilder pageBuilder : this.pageBuilders) {
                    this.appendRow(pageBuilder, page, 0);
                }
                this.hasAnyRowBeenReplicated = true;
                position = 1;
            } else {
                position = 0;
            }
            Page partitionFunctionArgs = this.getPartitionFunctionArguments(page);
            if (this.nullChannel >= 0 && page.getBlock(this.nullChannel).mayHaveNull()) {
                Block nullsBlock = page.getBlock(this.nullChannel);
                while (position < page.getPositionCount()) {
                    if (nullsBlock.isNull(position)) {
                        for (PageBuilder pageBuilder : this.pageBuilders) {
                            this.appendRow(pageBuilder, page, position);
                        }
                    } else {
                        int partition = this.partitionFunction.getPartition(partitionFunctionArgs, position);
                        this.appendRow(this.pageBuilders[partition], page, position);
                    }
                    ++position;
                }
            } else {
                while (position < page.getPositionCount()) {
                    int partition = this.partitionFunction.getPartition(partitionFunctionArgs, position);
                    this.appendRow(this.pageBuilders[partition], page, position);
                    ++position;
                }
            }
            this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
            this.flush(false);
        }

        private Page getPartitionFunctionArguments(Page page) {
            if (this.partitionConstantBlocks == null) {
                return page.extractChannels(this.partitionChannels);
            }
            Block[] blocks = new Block[this.partitionChannels.length];
            for (int i = 0; i < blocks.length; ++i) {
                int channel = this.partitionChannels[i];
                blocks[i] = channel < 0 ? new RunLengthEncodedBlock(this.partitionConstantBlocks[i], page.getPositionCount()) : page.getBlock(channel);
            }
            return new Page(page.getPositionCount(), blocks);
        }

        private void appendRow(PageBuilder pageBuilder, Page page, int position) {
            pageBuilder.declarePosition();
            for (int channel = 0; channel < this.sourceTypes.length; ++channel) {
                Type type = this.sourceTypes[channel];
                type.appendTo(page.getBlock(channel), position, pageBuilder.getBlockBuilder(channel));
            }
        }

        public void flush(boolean force) {
            for (int partition = 0; partition < this.pageBuilders.length; ++partition) {
                PageBuilder partitionPageBuilder = this.pageBuilders[partition];
                if (partitionPageBuilder.isEmpty() || !force && !partitionPageBuilder.isFull()) continue;
                Page pagePartition = partitionPageBuilder.build();
                partitionPageBuilder.reset();
                this.operatorContext.recordOutput(pagePartition.getSizeInBytes(), pagePartition.getPositionCount());
                this.outputBuffer.enqueue(this.operatorContext.getDriverContext().getLifespan(), partition, this.splitAndSerializePage(pagePartition));
                this.pagesAdded.incrementAndGet();
                this.rowsAdded.addAndGet(pagePartition.getPositionCount());
            }
        }

        private List<SerializedPage> splitAndSerializePage(Page pagePartition) {
            List<Page> pagesFromSplitting = PageSplitterUtil.splitPage(pagePartition, 0x100000L);
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)pagesFromSplitting.size());
            for (Page p : pagesFromSplitting) {
                builder.add((Object)this.serde.serialize(p));
            }
            return builder.build();
        }
    }

    public static class PartitionedOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> sourceTypes;
        private final Function<Page, Page> pagePreprocessor;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<ConstantExpression>> partitionConstants;
        private final boolean replicatesAnyRow;
        private final OptionalInt nullChannel;
        private final OutputBuffer outputBuffer;
        private final PagesSerdeFactory serdeFactory;
        private final DataSize maxMemory;

        public PartitionedOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> sourceTypes, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<ConstantExpression>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, DataSize maxMemory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = Objects.requireNonNull(partitionConstants, "partitionConstants is null");
            this.replicatesAnyRow = replicatesAnyRow;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PartitionedOutputOperator.class.getSimpleName());
            return new PartitionedOutputOperator(operatorContext, this.sourceTypes, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, this.serdeFactory, this.maxMemory);
        }

        @Override
        public void noMoreOperators() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new PartitionedOutputOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicatesAnyRow, this.nullChannel, this.outputBuffer, this.serdeFactory, this.maxMemory);
        }
    }

    public static class PartitionedOutputFactory
    implements OutputFactory {
        private final OutputBuffer outputBuffer;
        private final DataSize maxMemory;

        public PartitionedOutputFactory(OutputBuffer outputBuffer, DataSize maxMemory) {
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.maxMemory = Objects.requireNonNull(maxMemory, "maxMemory is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, Optional<OutputPartitioning> outputPartitioning, PagesSerdeFactory serdeFactory) {
            Preconditions.checkArgument((boolean)outputPartitioning.isPresent(), (Object)"outputPartitioning is not present");
            return new PartitionedOutputOperatorFactory(operatorId, planNodeId, types, pagePreprocessor, outputPartitioning.get().getPartitionFunction(), outputPartitioning.get().getPartitionChannels(), outputPartitioning.get().getPartitionConstants(), outputPartitioning.get().isReplicateNullsAndAny(), outputPartitioning.get().getNullChannel(), this.outputBuffer, serdeFactory, this.maxMemory);
        }
    }
}

