/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import java.util.Arrays;
import java.util.Objects;

class ReplicatedBlockBuilder {
    private Block source;
    private int sourcePosition;

    ReplicatedBlockBuilder() {
    }

    public void resetInputBlock(Block block) {
        this.source = Objects.requireNonNull(block, "block is null");
        this.sourcePosition = 0;
    }

    public Block buildOutputBlock(int[] maxEntries, int offset, int length, int totalEntries) {
        int[] ids = new int[totalEntries];
        int fromPosition = 0;
        for (int i = 0; i < length; ++i) {
            int toPosition = fromPosition + maxEntries[offset + i];
            Arrays.fill(ids, fromPosition, toPosition, this.sourcePosition++);
            fromPosition = toPosition;
        }
        return new DictionaryBlock(totalEntries, this.source, ids);
    }
}

