/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.security.AllowAllSystemAccessControl;
import com.facebook.presto.security.FileBasedSystemAccessControl;
import com.facebook.presto.security.ReadOnlySystemAccessControl;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.AuthorizedIdentity;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.PropertiesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class AccessControlManager
implements AccessControl {
    private static final Logger log = Logger.get(AccessControlManager.class);
    private static final File ACCESS_CONTROL_CONFIGURATION = new File("etc/access-control.properties");
    private static final String ACCESS_CONTROL_PROPERTY_NAME = "access-control.name";
    private final TransactionManager transactionManager;
    private final Map<String, SystemAccessControlFactory> systemAccessControlFactories = new ConcurrentHashMap<String, SystemAccessControlFactory>();
    private final Map<ConnectorId, CatalogAccessControlEntry> connectorAccessControl = new ConcurrentHashMap<ConnectorId, CatalogAccessControlEntry>();
    private final AtomicReference<SystemAccessControl> systemAccessControl = new AtomicReference<InitializingSystemAccessControl>(new InitializingSystemAccessControl());
    private final AtomicBoolean systemAccessControlLoading = new AtomicBoolean();
    private final CounterStat authenticationSuccess = new CounterStat();
    private final CounterStat authenticationFail = new CounterStat();
    private final CounterStat authorizationSuccess = new CounterStat();
    private final CounterStat authorizationFail = new CounterStat();

    @Inject
    public AccessControlManager(TransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.addSystemAccessControlFactory(new AllowAllSystemAccessControl.Factory());
        this.addSystemAccessControlFactory(new ReadOnlySystemAccessControl.Factory());
        this.addSystemAccessControlFactory(new FileBasedSystemAccessControl.Factory());
    }

    public void addSystemAccessControlFactory(SystemAccessControlFactory accessControlFactory) {
        Objects.requireNonNull(accessControlFactory, "accessControlFactory is null");
        if (this.systemAccessControlFactories.putIfAbsent(accessControlFactory.getName(), accessControlFactory) != null) {
            throw new IllegalArgumentException(String.format("Access control '%s' is already registered", accessControlFactory.getName()));
        }
    }

    public void addCatalogAccessControl(ConnectorId connectorId, ConnectorAccessControl accessControl) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        Preconditions.checkState((this.connectorAccessControl.putIfAbsent(connectorId, new CatalogAccessControlEntry(connectorId, accessControl)) == null ? 1 : 0) != 0, (String)"Access control for connector '%s' is already registered", (Object)connectorId);
    }

    public void removeCatalogAccessControl(ConnectorId connectorId) {
        this.connectorAccessControl.remove(connectorId);
    }

    public void loadSystemAccessControl() throws Exception {
        if (ACCESS_CONTROL_CONFIGURATION.exists()) {
            Map<String, String> properties = PropertiesUtil.loadProperties(ACCESS_CONTROL_CONFIGURATION);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)properties.get(ACCESS_CONTROL_PROPERTY_NAME)) ? 1 : 0) != 0, (String)"Access control configuration %s does not contain %s", (Object)ACCESS_CONTROL_CONFIGURATION.getAbsoluteFile(), (Object)ACCESS_CONTROL_PROPERTY_NAME);
            this.loadSystemAccessControl(properties);
        } else {
            this.setSystemAccessControl("allow-all", (Map<String, String>)ImmutableMap.of());
        }
    }

    public void loadSystemAccessControl(Map<String, String> properties) {
        String accessControlName = (properties = new HashMap<String, String>(properties)).remove(ACCESS_CONTROL_PROPERTY_NAME);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessControlName) ? 1 : 0) != 0, (String)"%s property must be present", (Object)ACCESS_CONTROL_PROPERTY_NAME);
        this.setSystemAccessControl(accessControlName, properties);
    }

    @VisibleForTesting
    protected void setSystemAccessControl(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        Preconditions.checkState((boolean)this.systemAccessControlLoading.compareAndSet(false, true), (Object)"System access control already initialized");
        log.info("-- Loading system access control --");
        SystemAccessControlFactory systemAccessControlFactory = this.systemAccessControlFactories.get(name);
        Preconditions.checkState((systemAccessControlFactory != null ? 1 : 0) != 0, (String)"Access control %s is not registered", (Object)name);
        SystemAccessControl systemAccessControl = systemAccessControlFactory.create((Map)ImmutableMap.copyOf(properties));
        this.systemAccessControl.set(systemAccessControl);
        log.info("-- Loaded system access control %s --", new Object[]{name});
    }

    public void checkCanSetUser(Identity identity, AccessControlContext context, Optional<Principal> principal, String userName) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(userName, "userName is null");
        this.authenticationCheck(() -> this.systemAccessControl.get().checkCanSetUser(identity, context, principal, userName));
    }

    public AuthorizedIdentity selectAuthorizedIdentity(Identity identity, AccessControlContext context, String userName, List<X509Certificate> certificates) {
        Objects.requireNonNull(userName, "userName is null");
        Objects.requireNonNull(certificates, "certificates is null");
        return this.systemAccessControl.get().selectAuthorizedIdentity(identity, context, userName, certificates);
    }

    public void checkQueryIntegrity(Identity identity, AccessControlContext context, String query) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(query, "query is null");
        this.authenticationCheck(() -> this.systemAccessControl.get().checkQueryIntegrity(identity, context, query));
    }

    public Set<String> filterCatalogs(Identity identity, AccessControlContext context, Set<String> catalogs) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogs, "catalogs is null");
        return this.systemAccessControl.get().filterCatalogs(identity, context, catalogs);
    }

    public void checkCanAccessCatalog(Identity identity, AccessControlContext context, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalog is null");
        this.authenticationCheck(() -> this.systemAccessControl.get().checkCanAccessCatalog(identity, context, catalogName));
    }

    public void checkCanCreateSchema(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schemaName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, schemaName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateSchema(identity, context, schemaName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schemaName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateSchema(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(schemaName.getCatalogName()), context, schemaName.getSchemaName()));
        }
    }

    public void checkCanDropSchema(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schemaName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, schemaName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropSchema(identity, context, schemaName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schemaName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropSchema(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(schemaName.getCatalogName()), context, schemaName.getSchemaName()));
        }
    }

    public void checkCanRenameSchema(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schemaName, String newSchemaName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, schemaName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRenameSchema(identity, context, schemaName, newSchemaName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schemaName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRenameSchema(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(schemaName.getCatalogName()), context, schemaName.getSchemaName(), newSchemaName));
        }
    }

    public void checkCanShowSchemas(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanShowSchemas(identity, context, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanShowSchemas(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context));
        }
    }

    public Set<String> filterSchemas(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName, Set<String> schemaNames) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(schemaNames, "schemaNames is null");
        if (this.filterCatalogs(identity, context, (Set<String>)ImmutableSet.of((Object)catalogName)).isEmpty()) {
            return ImmutableSet.of();
        }
        schemaNames = this.systemAccessControl.get().filterSchemas(identity, context, catalogName, schemaNames);
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            schemaNames = entry.getAccessControl().filterSchemas(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, schemaNames);
        }
        return schemaNames;
    }

    public void checkCanCreateTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateTable(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    public void checkCanDropTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropTable(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    public void checkCanRenameTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(newTableName, "newTableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRenameTable(identity, context, this.toCatalogSchemaTableName(tableName), this.toCatalogSchemaTableName(newTableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRenameTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName), MetadataUtil.toSchemaTableName(newTableName)));
        }
    }

    public void checkCanShowTablesMetadata(TransactionId transactionId, Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schema, "schema is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, schema.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanShowTablesMetadata(identity, context, schema));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schema.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanShowTablesMetadata(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(), context, schema.getSchemaName()));
        }
    }

    public Set<SchemaTableName> filterTables(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName, Set<SchemaTableName> tableNames) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(tableNames, "tableNames is null");
        if (this.filterCatalogs(identity, context, (Set<String>)ImmutableSet.of((Object)catalogName)).isEmpty()) {
            return ImmutableSet.of();
        }
        tableNames = this.systemAccessControl.get().filterTables(identity, context, catalogName, tableNames);
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            tableNames = entry.getAccessControl().filterTables(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, tableNames);
        }
        return tableNames;
    }

    public void checkCanAddColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanAddColumn(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanAddColumn(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    public void checkCanDropColumn(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropColumn(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropColumn(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    public void checkCanRenameColumn(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRenameColumn(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRenameColumn(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    public void checkCanInsertIntoTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanInsertIntoTable(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanInsertIntoTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    public void checkCanDeleteFromTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDeleteFromTable(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDeleteFromTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    public void checkCanTruncateTable(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanTruncateTable(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanTruncateTable(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    public void checkCanUpdateTableColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<String> updatedColumnNames) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanUpdateTableColumns(identity, context, this.toCatalogSchemaTableName(tableName), updatedColumnNames));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanUpdateTableColumns(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName), updatedColumnNames));
        }
    }

    public void checkCanCreateView(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, viewName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateView(identity, context, this.toCatalogSchemaTableName(viewName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, viewName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateView(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(viewName.getCatalogName()), context, MetadataUtil.toSchemaTableName(viewName)));
        }
    }

    public void checkCanDropView(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, viewName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropView(identity, context, this.toCatalogSchemaTableName(viewName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, viewName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropView(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(viewName.getCatalogName()), context, MetadataUtil.toSchemaTableName(viewName)));
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateViewWithSelectFromColumns(identity, context, this.toCatalogSchemaTableName(tableName), columnNames));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateViewWithSelectFromColumns(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName), columnNames));
        }
    }

    public void checkCanGrantTablePrivilege(TransactionId transactionId, Identity identity, AccessControlContext context, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal grantee, boolean withGrantOption) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanGrantTablePrivilege(identity, context, privilege, this.toCatalogSchemaTableName(tableName), grantee, withGrantOption));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanGrantTablePrivilege(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, privilege, MetadataUtil.toSchemaTableName(tableName), grantee, withGrantOption));
        }
    }

    public void checkCanRevokeTablePrivilege(TransactionId transactionId, Identity identity, AccessControlContext context, Privilege privilege, QualifiedObjectName tableName, PrestoPrincipal revokee, boolean grantOptionFor) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRevokeTablePrivilege(identity, context, privilege, this.toCatalogSchemaTableName(tableName), revokee, grantOptionFor));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRevokeTablePrivilege(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, privilege, MetadataUtil.toSchemaTableName(tableName), revokee, grantOptionFor));
        }
    }

    public void checkCanSetSystemSessionProperty(Identity identity, AccessControlContext context, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSetSystemSessionProperty(identity, context, propertyName));
    }

    public void checkCanSetCatalogSessionProperty(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSetCatalogSessionProperty(identity, context, catalogName, propertyName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSetCatalogSessionProperty(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, propertyName));
        }
    }

    public void checkCanSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<Subfield> columnOrSubfieldNames) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columnOrSubfieldNames, "columnOrSubfieldNames is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSelectFromColumns(identity, context, this.toCatalogSchemaTableName(tableName), (Set)columnOrSubfieldNames.stream().map(subfield -> subfield.getRootName()).collect(ImmutableSet.toImmutableSet())));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSelectFromColumns(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName), columnOrSubfieldNames));
        }
    }

    public void checkCanCreateRole(TransactionId transactionId, Identity identity, AccessControlContext context, String role, Optional<PrestoPrincipal> grantor, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateRole(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, role, grantor));
        }
    }

    public void checkCanDropRole(TransactionId transactionId, Identity identity, AccessControlContext context, String role, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropRole(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, role));
        }
    }

    public void checkCanGrantRoles(TransactionId transactionId, Identity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(roles, "roles is null");
        Objects.requireNonNull(grantees, "grantees is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanGrantRoles(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, roles, grantees, withAdminOption, grantor, catalogName));
        }
    }

    public void checkCanRevokeRoles(TransactionId transactionId, Identity identity, AccessControlContext context, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(roles, "roles is null");
        Objects.requireNonNull(grantees, "grantees is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRevokeRoles(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, roles, grantees, adminOptionFor, grantor, catalogName));
        }
    }

    public void checkCanSetRole(TransactionId transactionId, Identity identity, AccessControlContext context, String role, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(catalogName, "catalog is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSetRole(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, role, catalogName));
        }
    }

    public void checkCanShowRoles(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authenticationCheck(() -> entry.getAccessControl().checkCanShowRoles(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, catalogName));
        }
    }

    public void checkCanShowCurrentRoles(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authenticationCheck(() -> entry.getAccessControl().checkCanShowCurrentRoles(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, catalogName));
        }
    }

    public void checkCanShowRoleGrants(TransactionId transactionId, Identity identity, AccessControlContext context, String catalogName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, catalogName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authenticationCheck(() -> entry.getAccessControl().checkCanShowRoleGrants(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(catalogName), context, catalogName));
        }
    }

    public void checkCanDropConstraint(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropConstraint(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropConstraint(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    public void checkCanAddConstraints(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authenticationCheck(() -> this.checkCanAccessCatalog(identity, context, tableName.getCatalogName()));
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanAddConstraint(identity, context, this.toCatalogSchemaTableName(tableName)));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanAddConstraint(entry.getTransactionHandle(transactionId), identity.toConnectorIdentity(tableName.getCatalogName()), context, MetadataUtil.toSchemaTableName(tableName)));
        }
    }

    private CatalogAccessControlEntry getConnectorAccessControl(TransactionId transactionId, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(transactionId, catalogName).map(metadata -> this.connectorAccessControl.get(metadata.getConnectorId())).orElse(null);
    }

    @Managed
    @Nested
    public CounterStat getAuthenticationSuccess() {
        return this.authenticationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthenticationFail() {
        return this.authenticationFail;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationSuccess() {
        return this.authorizationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationFail() {
        return this.authorizationFail;
    }

    private void authenticationCheck(Runnable runnable) {
        try {
            runnable.run();
            this.authenticationSuccess.update(1L);
        }
        catch (PrestoException e) {
            this.authenticationFail.update(1L);
            throw e;
        }
    }

    private void authorizationCheck(Runnable runnable) {
        try {
            runnable.run();
            this.authorizationSuccess.update(1L);
        }
        catch (PrestoException e) {
            this.authorizationFail.update(1L);
            throw e;
        }
    }

    private CatalogSchemaTableName toCatalogSchemaTableName(QualifiedObjectName qualifiedObjectName) {
        return new CatalogSchemaTableName(qualifiedObjectName.getCatalogName(), qualifiedObjectName.getSchemaName(), qualifiedObjectName.getObjectName());
    }

    private static class InitializingSystemAccessControl
    implements SystemAccessControl {
        private InitializingSystemAccessControl() {
        }

        public void checkQueryIntegrity(Identity identity, AccessControlContext context, String query) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }

        public void checkCanSetUser(Identity identity, AccessControlContext context, Optional<Principal> principal, String userName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }

        public void checkCanSetSystemSessionProperty(Identity identity, AccessControlContext context, String propertyName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }

        public void checkCanAccessCatalog(Identity identity, AccessControlContext context, String catalogName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }
    }

    private class CatalogAccessControlEntry {
        private final ConnectorId connectorId;
        private final ConnectorAccessControl accessControl;

        public CatalogAccessControlEntry(ConnectorId connectorId, ConnectorAccessControl accessControl) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        }

        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        public ConnectorAccessControl getAccessControl() {
            return this.accessControl;
        }

        public ConnectorTransactionHandle getTransactionHandle(TransactionId transactionId) {
            return AccessControlManager.this.transactionManager.getConnectorTransaction(transactionId, this.connectorId);
        }
    }
}

