/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.ThreadPoolExecutorMBean;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.json.Codec;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.airlift.stats.DecayCounter;
import com.facebook.airlift.stats.ExponentialDecay;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorTypeSerdeManager;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.ForScheduler;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.server.remotetask.HttpRemoteTask;
import com.facebook.presto.server.remotetask.RemoteTaskStats;
import com.facebook.presto.server.thrift.ThriftCodecWrapper;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.collect.Multimap;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HttpRemoteTaskFactory
implements RemoteTaskFactory {
    private final HttpClient httpClient;
    private final LocationFactory locationFactory;
    private final Codec<TaskStatus> taskStatusCodec;
    private final Codec<TaskInfo> taskInfoCodec;
    private final Codec<TaskInfo> taskInfoJsonCodec;
    private final Codec<TaskUpdateRequest> taskUpdateRequestCodec;
    private final Codec<PlanFragment> planFragmentCodec;
    private final Codec<MetadataUpdates> metadataUpdatesCodec;
    private final Duration maxErrorDuration;
    private final Duration taskStatusRefreshMaxWait;
    private final Duration taskInfoRefreshMaxWait;
    private final HandleResolver handleResolver;
    private final ConnectorTypeSerdeManager connectorTypeSerdeManager;
    private final Duration taskInfoUpdateInterval;
    private final ExecutorService coreExecutor;
    private final Executor executor;
    private final ThreadPoolExecutorMBean executorMBean;
    private final ScheduledExecutorService updateScheduledExecutor;
    private final ScheduledExecutorService errorScheduledExecutor;
    private final RemoteTaskStats stats;
    private final boolean binaryTransportEnabled;
    private final boolean thriftTransportEnabled;
    private final boolean taskInfoThriftTransportEnabled;
    private final Protocol thriftProtocol;
    private final int maxTaskUpdateSizeInBytes;
    private final MetadataManager metadataManager;
    private final QueryManager queryManager;
    private final DecayCounter taskUpdateRequestSize;

    @Inject
    public HttpRemoteTaskFactory(QueryManagerConfig config, TaskManagerConfig taskConfig, @ForScheduler HttpClient httpClient, LocationFactory locationFactory, JsonCodec<TaskStatus> taskStatusJsonCodec, SmileCodec<TaskStatus> taskStatusSmileCodec, ThriftCodec<TaskStatus> taskStatusThriftCodec, JsonCodec<TaskInfo> taskInfoJsonCodec, SmileCodec<TaskInfo> taskInfoSmileCodec, ThriftCodec<TaskInfo> taskInfoThriftCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestJsonCodec, SmileCodec<TaskUpdateRequest> taskUpdateRequestSmileCodec, JsonCodec<PlanFragment> planFragmentJsonCodec, SmileCodec<PlanFragment> planFragmentSmileCodec, JsonCodec<MetadataUpdates> metadataUpdatesJsonCodec, SmileCodec<MetadataUpdates> metadataUpdatesSmileCodec, RemoteTaskStats stats, InternalCommunicationConfig communicationConfig, MetadataManager metadataManager, QueryManager queryManager, HandleResolver handleResolver, ConnectorTypeSerdeManager connectorTypeSerdeManager) {
        this.httpClient = httpClient;
        this.locationFactory = locationFactory;
        this.maxErrorDuration = config.getRemoteTaskMaxErrorDuration();
        this.taskStatusRefreshMaxWait = taskConfig.getStatusRefreshMaxWait();
        this.taskInfoUpdateInterval = taskConfig.getInfoUpdateInterval();
        this.taskInfoRefreshMaxWait = taskConfig.getInfoRefreshMaxWait();
        this.handleResolver = handleResolver;
        this.connectorTypeSerdeManager = connectorTypeSerdeManager;
        this.coreExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"remote-task-callback-%s"));
        this.executor = new BoundedExecutor((Executor)this.coreExecutor, config.getRemoteTaskMaxCallbackThreads());
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.coreExecutor);
        this.stats = Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(communicationConfig, "communicationConfig is null");
        this.binaryTransportEnabled = communicationConfig.isBinaryTransportEnabled();
        this.thriftTransportEnabled = communicationConfig.isThriftTransportEnabled();
        this.taskInfoThriftTransportEnabled = communicationConfig.isTaskInfoThriftTransportEnabled();
        this.thriftProtocol = communicationConfig.getThriftProtocol();
        this.maxTaskUpdateSizeInBytes = Math.toIntExact(Objects.requireNonNull(communicationConfig, "communicationConfig is null").getMaxTaskUpdateSize().toBytes());
        this.taskStatusCodec = this.thriftTransportEnabled ? ThriftCodecWrapper.wrapThriftCodec(taskStatusThriftCodec) : (this.binaryTransportEnabled ? taskStatusSmileCodec : taskStatusJsonCodec);
        this.taskInfoCodec = this.taskInfoThriftTransportEnabled ? ThriftCodecWrapper.wrapThriftCodec(taskInfoThriftCodec) : (this.binaryTransportEnabled ? taskInfoSmileCodec : taskInfoJsonCodec);
        this.taskInfoJsonCodec = taskInfoJsonCodec;
        if (this.binaryTransportEnabled) {
            this.taskUpdateRequestCodec = taskUpdateRequestSmileCodec;
            this.metadataUpdatesCodec = metadataUpdatesSmileCodec;
        } else {
            this.taskUpdateRequestCodec = taskUpdateRequestJsonCodec;
            this.metadataUpdatesCodec = metadataUpdatesJsonCodec;
        }
        this.planFragmentCodec = planFragmentJsonCodec;
        this.metadataManager = metadataManager;
        this.queryManager = queryManager;
        this.updateScheduledExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"task-info-update-scheduler-%s"));
        this.errorScheduledExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"remote-task-error-delay-%s"));
        this.taskUpdateRequestSize = new DecayCounter(ExponentialDecay.oneMinute());
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @Managed
    public double getTaskUpdateRequestSize() {
        return this.taskUpdateRequestSize.getCount();
    }

    @PreDestroy
    public void stop() {
        this.coreExecutor.shutdownNow();
        this.updateScheduledExecutor.shutdownNow();
        this.errorScheduledExecutor.shutdownNow();
    }

    @Override
    public RemoteTask createRemoteTask(Session session, TaskId taskId, InternalNode node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers, NodeTaskMap.NodeStatsTracker nodeStatsTracker, boolean summarizeTaskInfo, TableWriteInfo tableWriteInfo) {
        return new HttpRemoteTask(session, taskId, node.getNodeIdentifier(), this.locationFactory.createLegacyTaskLocation(node, taskId), this.locationFactory.createTaskLocation(node, taskId), fragment, initialSplits, outputBuffers, this.httpClient, this.executor, this.updateScheduledExecutor, this.errorScheduledExecutor, this.maxErrorDuration, this.taskStatusRefreshMaxWait, this.taskInfoRefreshMaxWait, this.taskInfoUpdateInterval, summarizeTaskInfo, this.taskStatusCodec, this.taskInfoCodec, this.taskInfoJsonCodec, this.taskUpdateRequestCodec, this.planFragmentCodec, this.metadataUpdatesCodec, nodeStatsTracker, this.stats, this.binaryTransportEnabled, this.thriftTransportEnabled, this.taskInfoThriftTransportEnabled, this.thriftProtocol, tableWriteInfo, this.maxTaskUpdateSizeInBytes, this.metadataManager, this.queryManager, this.taskUpdateRequestSize, this.handleResolver, this.connectorTypeSerdeManager);
    }
}

