/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.spiller.SpillCipher;
import com.facebook.presto.spiller.AesSpillCipher;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.spiller.SingleStreamSpiller;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.spiller.TempStorageSingleStreamSpiller;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.storage.TempStorageManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;

public class TempStorageSingleStreamSpillerFactory
implements SingleStreamSpillerFactory {
    private final TempStorageManager tempStorageManager;
    private final ListeningExecutorService executor;
    private final PagesSerdeFactory serdeFactory;
    private final SpillerStats spillerStats;
    private final boolean spillEncryptionEnabled;
    private final String tempStorageName;

    @Inject
    public TempStorageSingleStreamSpillerFactory(TempStorageManager tempStorageManager, BlockEncodingSerde blockEncodingSerde, SpillerStats spillerStats, FeaturesConfig featuresConfig, NodeSpillConfig nodeSpillConfig) {
        this(tempStorageManager, MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(Objects.requireNonNull(featuresConfig, "featuresConfig is null").getSpillerThreads(), Threads.daemonThreadsNamed((String)"binary-spiller-%s"))), blockEncodingSerde, spillerStats, Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null").isSpillCompressionEnabled(), Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null").isSpillEncryptionEnabled(), Objects.requireNonNull(featuresConfig, "featuresConfig is null").getSpillerTempStorage());
    }

    @VisibleForTesting
    TempStorageSingleStreamSpillerFactory(TempStorageManager tempStorageManager, ListeningExecutorService executor, BlockEncodingSerde blockEncodingSerde, SpillerStats spillerStats, boolean spillCompressionEnabled, boolean spillEncryptionEnabled, String tempStorageName) {
        this.tempStorageManager = Objects.requireNonNull(tempStorageManager, "tempStorageManager is null");
        this.serdeFactory = new PagesSerdeFactory(Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null"), spillCompressionEnabled);
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.spillerStats = Objects.requireNonNull(spillerStats, "spillerStats can not be null");
        this.spillEncryptionEnabled = spillEncryptionEnabled;
        this.tempStorageName = Objects.requireNonNull(tempStorageName, "tempStorageName is null");
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
    }

    @Override
    public SingleStreamSpiller create(List<Type> types, SpillContext spillContext, LocalMemoryContext memoryContext) {
        Optional<SpillCipher> spillCipher = Optional.empty();
        if (this.spillEncryptionEnabled) {
            spillCipher = Optional.of(new AesSpillCipher());
        }
        PagesSerde serde = this.serdeFactory.createPagesSerdeForSpill(spillCipher);
        return new TempStorageSingleStreamSpiller(this.tempStorageManager.getTempStorage(this.tempStorageName), serde, this.executor, this.spillerStats, spillContext, memoryContext, spillCipher);
    }
}

