/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.MaterializedViewUtils;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QuerySpecification;
import java.util.Optional;

public final class MaterializedViewRewriteQueryShapeValidator {
    private MaterializedViewRewriteQueryShapeValidator() {
    }

    static Optional<String> validate(QuerySpecification querySpecification) {
        return new Visitor().validateMaterializedViewOptimizationQueryShape(querySpecification);
    }

    static class Visitor
    extends DefaultTraversalVisitor<Void, Void> {
        private Optional<String> errorMessage = Optional.empty();
        boolean hasGroupBy;

        Visitor() {
        }

        public Optional<String> validateMaterializedViewOptimizationQueryShape(QuerySpecification querySpecification) {
            if (querySpecification.getHaving().isPresent()) {
                this.errorMessage = Optional.of("Query shape invalid: HAVING is not supported for materialized view optimizations");
            } else if (!querySpecification.getFrom().isPresent()) {
                this.errorMessage = Optional.of("Query shape invalid: QuerySpecification without from clause is not supported for materialized view optimization");
            } else {
                this.process((Node)querySpecification);
            }
            return this.errorMessage;
        }

        protected Void visitGroupBy(GroupBy node, Void context) {
            this.hasGroupBy = true;
            return (Void)super.visitGroupBy(node, (Object)context);
        }

        protected Void visitFunctionCall(FunctionCall node, Void context) {
            QualifiedName name = node.getName();
            if (!MaterializedViewUtils.SUPPORTED_FUNCTION_CALLS.contains(name)) {
                this.errorMessage = Optional.of(String.format("Query shape invalid: %s function is not supported for materialized view optimizations", name));
            }
            return (Void)super.visitFunctionCall(node, (Object)context);
        }
    }
}

