/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MergeJoinNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

class GroupedExecutionTagger
extends InternalPlanVisitor<GroupedExecutionProperties, Void> {
    private final Session session;
    private final Metadata metadata;
    private final NodePartitioningManager nodePartitioningManager;
    private final boolean groupedExecutionEnabled;

    public GroupedExecutionTagger(Session session, Metadata metadata, NodePartitioningManager nodePartitioningManager) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.groupedExecutionEnabled = SystemSessionProperties.isGroupedExecutionEnabled(session);
    }

    public GroupedExecutionProperties visitPlan(PlanNode node, Void context) {
        if (node.getSources().isEmpty()) {
            return GroupedExecutionProperties.notCapable();
        }
        return this.processChildren(node);
    }

    @Override
    public GroupedExecutionProperties visitJoin(JoinNode node, Void context) {
        GroupedExecutionProperties left = (GroupedExecutionProperties)node.getLeft().accept((PlanVisitor)this, null);
        GroupedExecutionProperties right = (GroupedExecutionProperties)node.getRight().accept((PlanVisitor)this, null);
        if (!node.getDistributionType().isPresent() || !this.groupedExecutionEnabled) {
            return GroupedExecutionProperties.notCapable();
        }
        if (!(node.getType() != JoinType.RIGHT && node.getType() != JoinType.FULL || right.currentNodeCapable)) {
            return GroupedExecutionProperties.notCapable();
        }
        switch (node.getDistributionType().get()) {
            case REPLICATED: {
                Preconditions.checkState((!right.currentNodeCapable ? 1 : 0) != 0);
                return left;
            }
            case PARTITIONED: {
                if (left.currentNodeCapable && right.currentNodeCapable) {
                    Preconditions.checkState((left.totalLifespans == right.totalLifespans ? 1 : 0) != 0, (Object)String.format("Mismatched number of lifespans on left(%s) and right(%s) side of join", left.totalLifespans, right.totalLifespans));
                    return new GroupedExecutionProperties(true, true, (List<PlanNodeId>)ImmutableList.builder().addAll((Iterable)left.capableTableScanNodes).addAll((Iterable)right.capableTableScanNodes).build(), left.totalLifespans, left.recoveryEligible && right.recoveryEligible);
                }
                return left;
            }
        }
        throw new UnsupportedOperationException("Unknown distribution type: " + node.getDistributionType());
    }

    @Override
    public GroupedExecutionProperties visitMergeJoin(MergeJoinNode node, Void context) {
        GroupedExecutionProperties left = (GroupedExecutionProperties)node.getLeft().accept((PlanVisitor)this, null);
        GroupedExecutionProperties right = (GroupedExecutionProperties)node.getRight().accept((PlanVisitor)this, null);
        if (this.groupedExecutionEnabled && left.currentNodeCapable && right.currentNodeCapable) {
            Preconditions.checkState((left.totalLifespans == right.totalLifespans ? 1 : 0) != 0, (Object)String.format("Mismatched number of lifespans on left(%s) and right(%s) side of join", left.totalLifespans, right.totalLifespans));
            return new GroupedExecutionProperties(true, true, (List<PlanNodeId>)ImmutableList.builder().addAll((Iterable)left.capableTableScanNodes).addAll((Iterable)right.capableTableScanNodes).build(), left.totalLifespans, left.recoveryEligible && right.recoveryEligible);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PLAN_ERROR, String.format("When grouped execution can't be enabled, merge join plan is not valid.%s is currently set to %s; left node grouped execution capable is %s and right node grouped execution capable is %s.", "grouped_execution", this.groupedExecutionEnabled, left.currentNodeCapable, right.currentNodeCapable));
    }

    public GroupedExecutionProperties visitAggregation(AggregationNode node, Void context) {
        GroupedExecutionProperties properties = (GroupedExecutionProperties)node.getSource().accept((PlanVisitor)this, null);
        if (this.groupedExecutionEnabled && properties.isCurrentNodeCapable()) {
            switch (node.getStep()) {
                case SINGLE: 
                case FINAL: {
                    return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes, properties.totalLifespans, properties.recoveryEligible);
                }
                case PARTIAL: 
                case INTERMEDIATE: {
                    return properties;
                }
            }
        }
        return GroupedExecutionProperties.notCapable();
    }

    @Override
    public GroupedExecutionProperties visitWindow(WindowNode node, Void context) {
        return this.processWindowFunction(node);
    }

    @Override
    public GroupedExecutionProperties visitRowNumber(RowNumberNode node, Void context) {
        return this.processWindowFunction(node);
    }

    @Override
    public GroupedExecutionProperties visitTopNRowNumber(TopNRowNumberNode node, Void context) {
        return this.processWindowFunction(node);
    }

    private GroupedExecutionProperties processWindowFunction(PlanNode node) {
        GroupedExecutionProperties properties = (GroupedExecutionProperties)((PlanNode)Iterables.getOnlyElement((Iterable)node.getSources())).accept((PlanVisitor)this, null);
        if (this.groupedExecutionEnabled && properties.isCurrentNodeCapable()) {
            return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes, properties.totalLifespans, properties.recoveryEligible);
        }
        return GroupedExecutionProperties.notCapable();
    }

    public GroupedExecutionProperties visitMarkDistinct(MarkDistinctNode node, Void context) {
        GroupedExecutionProperties properties = (GroupedExecutionProperties)((PlanNode)Iterables.getOnlyElement((Iterable)node.getSources())).accept((PlanVisitor)this, null);
        if (this.groupedExecutionEnabled && properties.isCurrentNodeCapable()) {
            return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes, properties.totalLifespans, properties.recoveryEligible);
        }
        return GroupedExecutionProperties.notCapable();
    }

    @Override
    public GroupedExecutionProperties visitTableWriter(TableWriterNode node, Void context) {
        GroupedExecutionProperties properties = (GroupedExecutionProperties)node.getSource().accept((PlanVisitor)this, null);
        boolean recoveryEligible = properties.isRecoveryEligible();
        TableWriterNode.WriterTarget target = node.getTarget().orElseThrow(() -> new VerifyException("target is absent"));
        recoveryEligible = target instanceof TableWriterNode.CreateName || target instanceof TableWriterNode.InsertReference || target instanceof TableWriterNode.RefreshMaterializedViewReference ? (recoveryEligible &= this.metadata.getConnectorCapabilities(this.session, target.getConnectorId()).contains(ConnectorCapabilities.SUPPORTS_PAGE_SINK_COMMIT)) : false;
        return new GroupedExecutionProperties(properties.isCurrentNodeCapable(), properties.isSubTreeUseful(), properties.getCapableTableScanNodes(), properties.getTotalLifespans(), recoveryEligible);
    }

    public GroupedExecutionProperties visitTableScan(TableScanNode node, Void context) {
        Optional<TableLayout.TablePartitioning> tablePartitioning = this.metadata.getLayout(this.session, node.getTable()).getTablePartitioning();
        if (!tablePartitioning.isPresent()) {
            return GroupedExecutionProperties.notCapable();
        }
        List<ConnectorPartitionHandle> partitionHandles = this.nodePartitioningManager.listPartitionHandles(this.session, tablePartitioning.get().getPartitioningHandle());
        if (ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED).equals(partitionHandles)) {
            return GroupedExecutionProperties.notCapable();
        }
        return new GroupedExecutionProperties(true, false, (List<PlanNodeId>)ImmutableList.of((Object)node.getId()), partitionHandles.size(), this.metadata.getConnectorCapabilities(this.session, node.getTable().getConnectorId()).contains(ConnectorCapabilities.SUPPORTS_REWINDABLE_SPLIT_SOURCE));
    }

    private GroupedExecutionProperties processChildren(PlanNode node) {
        boolean anyUseful = false;
        OptionalInt totalLifespans = OptionalInt.empty();
        boolean allRecoveryEligible = true;
        ImmutableList.Builder capableTableScanNodes = ImmutableList.builder();
        for (PlanNode source : node.getSources()) {
            GroupedExecutionProperties properties = (GroupedExecutionProperties)source.accept((PlanVisitor)this, null);
            if (!properties.isCurrentNodeCapable()) {
                return GroupedExecutionProperties.notCapable();
            }
            anyUseful |= properties.isSubTreeUseful();
            allRecoveryEligible &= properties.isRecoveryEligible();
            if (!totalLifespans.isPresent()) {
                totalLifespans = OptionalInt.of(properties.totalLifespans);
            } else {
                Preconditions.checkState((totalLifespans.getAsInt() == properties.totalLifespans ? 1 : 0) != 0, (Object)String.format("Mismatched number of lifespans among children nodes. Expected: %s, actual: %s", totalLifespans.getAsInt(), properties.totalLifespans));
            }
            capableTableScanNodes.addAll((Iterable)properties.capableTableScanNodes);
        }
        return new GroupedExecutionProperties(true, anyUseful, (List<PlanNodeId>)capableTableScanNodes.build(), totalLifespans.getAsInt(), allRecoveryEligible);
    }

    static class GroupedExecutionProperties {
        private final boolean currentNodeCapable;
        private final boolean subTreeUseful;
        private final List<PlanNodeId> capableTableScanNodes;
        private final int totalLifespans;
        private final boolean recoveryEligible;

        public GroupedExecutionProperties(boolean currentNodeCapable, boolean subTreeUseful, List<PlanNodeId> capableTableScanNodes, int totalLifespans, boolean recoveryEligible) {
            this.currentNodeCapable = currentNodeCapable;
            this.subTreeUseful = subTreeUseful;
            this.capableTableScanNodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(capableTableScanNodes, "capableTableScanNodes is null"));
            this.totalLifespans = totalLifespans;
            this.recoveryEligible = recoveryEligible;
            Preconditions.checkArgument((!subTreeUseful || currentNodeCapable ? 1 : 0) != 0);
            Preconditions.checkArgument((!recoveryEligible || currentNodeCapable ? 1 : 0) != 0);
            Preconditions.checkArgument((currentNodeCapable == !capableTableScanNodes.isEmpty() ? 1 : 0) != 0);
        }

        public static GroupedExecutionProperties notCapable() {
            return new GroupedExecutionProperties(false, false, (List<PlanNodeId>)ImmutableList.of(), 1, false);
        }

        public boolean isCurrentNodeCapable() {
            return this.currentNodeCapable;
        }

        public boolean isSubTreeUseful() {
            return this.subTreeUseful;
        }

        public List<PlanNodeId> getCapableTableScanNodes() {
            return this.capableTableScanNodes;
        }

        public int getTotalLifespans() {
            return this.totalLifespans;
        }

        public boolean isRecoveryEligible() {
            return this.recoveryEligible;
        }
    }
}

