/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.ColumnStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatisticsAggregationPlanner {
    private final VariableAllocator variableAllocator;
    private final FunctionAndTypeResolver functionAndTypeResolver;

    public StatisticsAggregationPlanner(VariableAllocator variableAllocator, FunctionAndTypeResolver functionAndTypeResolver) {
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.functionAndTypeResolver = Objects.requireNonNull(functionAndTypeResolver, "functionAndTypeResolver is null");
    }

    public TableStatisticAggregation createStatisticsAggregation(TableStatisticsMetadata statisticsMetadata, Map<String, VariableReferenceExpression> columnToVariableMap) {
        StatisticAggregationsDescriptor.Builder descriptor = StatisticAggregationsDescriptor.builder();
        List groupingColumns = statisticsMetadata.getGroupingColumns();
        List groupingVariables = (List)groupingColumns.stream().map(columnToVariableMap::get).collect(ImmutableList.toImmutableList());
        for (int i = 0; i < groupingVariables.size(); ++i) {
            descriptor.addGrouping((String)groupingColumns.get(i), groupingVariables.get(i));
        }
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        FunctionResolution functionResolution = new FunctionResolution(this.functionAndTypeResolver);
        for (TableStatisticType type : statisticsMetadata.getTableStatistics()) {
            if (type != TableStatisticType.ROW_COUNT) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table-wide statistic type not supported: " + type);
            }
            AggregationNode.Aggregation aggregation = new AggregationNode.Aggregation(new CallExpression("count", functionResolution.countFunction(), (Type)BigintType.BIGINT, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), false, Optional.empty());
            VariableReferenceExpression variable = this.variableAllocator.newVariable("rowCount", (Type)BigintType.BIGINT);
            aggregations.put((Object)variable, (Object)aggregation);
            descriptor.addTableStatistic(TableStatisticType.ROW_COUNT, variable);
        }
        for (ColumnStatisticMetadata columnStatisticMetadata : statisticsMetadata.getColumnStatistics()) {
            String columnName = columnStatisticMetadata.getColumnName();
            ColumnStatisticType statisticType = columnStatisticMetadata.getStatisticType();
            VariableReferenceExpression inputVariable = columnToVariableMap.get(columnName);
            Verify.verify((inputVariable != null ? 1 : 0) != 0, (String)"inputVariable is null", (Object[])new Object[0]);
            ColumnStatisticsAggregation aggregation = this.createColumnAggregation(columnStatisticMetadata, inputVariable);
            VariableReferenceExpression variable = this.variableAllocator.newVariable(statisticType + ":" + columnName, aggregation.getOutputType());
            aggregations.put((Object)variable, (Object)aggregation.getAggregation());
            descriptor.addColumnStatistic(columnStatisticMetadata, variable);
        }
        StatisticAggregations aggregation = new StatisticAggregations((Map<VariableReferenceExpression, AggregationNode.Aggregation>)aggregations.build(), groupingVariables);
        return new TableStatisticAggregation(aggregation, descriptor.build());
    }

    private ColumnStatisticsAggregation createColumnAggregation(ColumnStatisticMetadata columnStatisticMetadata, VariableReferenceExpression input) {
        FunctionHandle functionHandle = this.functionAndTypeResolver.lookupFunction(columnStatisticMetadata.getFunctionName(), TypeSignatureProvider.fromTypes((List)ImmutableList.of((Object)input.getType())));
        FunctionMetadata functionMeta = this.functionAndTypeResolver.getFunctionMetadata(functionHandle);
        Type inputType = this.functionAndTypeResolver.getType((TypeSignature)Iterables.getOnlyElement((Iterable)functionMeta.getArgumentTypes()));
        Type outputType = this.functionAndTypeResolver.getType(functionMeta.getReturnType());
        Verify.verify((inputType.equals(input.getType()) || input.getType().equals(UnknownType.UNKNOWN) ? 1 : 0) != 0, (String)"resolved function input type does not match the input type: %s != %s", (Object)inputType, (Object)input.getType());
        return new ColumnStatisticsAggregation(new AggregationNode.Aggregation(new CallExpression(input.getSourceLocation(), columnStatisticMetadata.getFunctionName(), functionHandle, outputType, (List)ImmutableList.of((Object)input)), Optional.empty(), Optional.empty(), false, Optional.empty()), outputType);
    }

    public static class ColumnStatisticsAggregation {
        private final AggregationNode.Aggregation aggregation;
        private final Type outputType;

        private ColumnStatisticsAggregation(AggregationNode.Aggregation aggregation, Type outputType) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation is null");
            this.outputType = Objects.requireNonNull(outputType, "outputType is null");
        }

        public AggregationNode.Aggregation getAggregation() {
            return this.aggregation;
        }

        public Type getOutputType() {
            return this.outputType;
        }
    }

    public static class TableStatisticAggregation {
        private final StatisticAggregations aggregations;
        private final StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor;

        private TableStatisticAggregation(StatisticAggregations aggregations, StatisticAggregationsDescriptor<VariableReferenceExpression> descriptor) {
            this.aggregations = Objects.requireNonNull(aggregations, "statisticAggregations is null");
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
        }

        public StatisticAggregations getAggregations() {
            return this.aggregations;
        }

        public StatisticAggregationsDescriptor<VariableReferenceExpression> getDescriptor() {
            return this.descriptor;
        }
    }
}

