/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.ExistsExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.SemanticExceptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionExtractor;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.SqlPlannerContext;
import com.facebook.presto.sql.planner.TranslateExpressionsUtil;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.optimizations.ApplyNodeUtil;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.util.AstUtils;
import com.facebook.presto.util.MorePredicates;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class SubqueryPlanner {
    private final Analysis analysis;
    private final VariableAllocator variableAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap;
    private final Metadata metadata;
    private final Session session;
    private final SqlParser sqlParser;

    SubqueryPlanner(Analysis analysis, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> lambdaDeclarationToVariableMap, Metadata metadata, Session session, SqlParser sqlParser) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToVariableMap, "lambdaDeclarationToVariableMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.analysis = analysis;
        this.variableAllocator = variableAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToVariableMap = lambdaDeclarationToVariableMap;
        this.metadata = metadata;
        this.session = session;
        this.sqlParser = sqlParser;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Collection<Expression> expressions, Node node, SqlPlannerContext context) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, node, true, context);
        }
        return builder;
    }

    public PlanBuilder handleUncorrelatedSubqueries(PlanBuilder builder, Collection<Expression> expressions, Node node, SqlPlannerContext context) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, node, false, context);
        }
        return builder;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Node node, SqlPlannerContext context) {
        return this.handleSubqueries(builder, expression, node, true, context);
    }

    private PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Node node, boolean correlationAllowed, SqlPlannerContext context) {
        boolean mayParticipateInAntiJoin = this.detectAntiJoinInExpression(expression);
        builder = this.appendInPredicateApplyNodes(builder, this.collectInPredicateSubqueries(expression, node), correlationAllowed, mayParticipateInAntiJoin, node, context);
        builder = this.appendScalarSubqueryApplyNodes(builder, this.collectScalarSubqueries(expression, node), correlationAllowed, context);
        builder = this.appendExistsSubqueryApplyNodes(builder, this.collectExistsSubqueries(expression, node), correlationAllowed, mayParticipateInAntiJoin, context);
        builder = this.appendQuantifiedComparisonApplyNodes(builder, this.collectQuantifiedComparisonSubqueries(expression, node), correlationAllowed, mayParticipateInAntiJoin, node, context);
        return builder;
    }

    public Set<InPredicate> collectInPredicateSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getInPredicateSubqueries(node).stream().filter(inPredicate -> AstUtils.nodeContains((Node)expression, (Node)inPredicate.getValueList())).collect(ImmutableSet.toImmutableSet());
    }

    public Set<SubqueryExpression> collectScalarSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getScalarSubqueries(node).stream().filter(subquery -> AstUtils.nodeContains((Node)expression, (Node)subquery)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<ExistsPredicate> collectExistsSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getExistsSubqueries(node).stream().filter(subquery -> AstUtils.nodeContains((Node)expression, (Node)subquery)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<QuantifiedComparisonExpression> collectQuantifiedComparisonSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getQuantifiedComparisonSubqueries(node).stream().filter(quantifiedComparison -> AstUtils.nodeContains((Node)expression, (Node)quantifiedComparison.getSubquery())).collect(ImmutableSet.toImmutableSet());
    }

    private PlanBuilder appendInPredicateApplyNodes(PlanBuilder subPlan, Set<InPredicate> inPredicates, boolean correlationAllowed, boolean mayParticipateInAntiJoin, Node node, SqlPlannerContext context) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendInPredicateApplyNode(subPlan, inPredicate, correlationAllowed, mayParticipateInAntiJoin, node, context);
        }
        return subPlan;
    }

    private PlanBuilder appendInPredicateApplyNode(PlanBuilder subPlan, InPredicate inPredicate, boolean correlationAllowed, boolean mayParticipateInAntiJoin, Node node, SqlPlannerContext context) {
        if (subPlan.canTranslate((Expression)inPredicate)) {
            return subPlan;
        }
        subPlan = this.handleSubqueries(subPlan, inPredicate.getValue(), node, context);
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()), this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, context);
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        SubqueryExpression valueListSubquery = (SubqueryExpression)inPredicate.getValueList();
        SubqueryExpression uncoercedValueListSubquery = this.uncoercedSubquery(valueListSubquery);
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)uncoercedValueListSubquery, context);
        subqueryPlan = subqueryPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)valueListSubquery), this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, context);
        SymbolReference valueList = ExpressionTreeUtils.createSymbolReference(subqueryPlan.translate((Expression)valueListSubquery));
        VariableReferenceExpression rewrittenValue = subPlan.translate(inPredicate.getValue());
        InPredicate inPredicateSubqueryExpression = new InPredicate((Expression)new SymbolReference(inPredicate.getLocation(), rewrittenValue.getName()), (Expression)valueList);
        VariableReferenceExpression inPredicateSubqueryVariable = PlannerUtils.newVariable(this.variableAllocator, (Expression)inPredicateSubqueryExpression, (Type)BooleanType.BOOLEAN);
        subPlan.getTranslations().put((Expression)inPredicate, inPredicateSubqueryVariable);
        return this.appendApplyNode(subPlan, (Node)inPredicate, subqueryPlan.getRoot(), Assignments.of((VariableReferenceExpression)inPredicateSubqueryVariable, (RowExpression)this.rowExpression((Expression)inPredicateSubqueryExpression, context)), correlationAllowed, mayParticipateInAntiJoin, context);
    }

    private PlanBuilder appendScalarSubqueryApplyNodes(PlanBuilder builder, Set<SubqueryExpression> scalarSubqueries, boolean correlationAllowed, SqlPlannerContext context) {
        for (SubqueryExpression scalarSubquery : scalarSubqueries) {
            builder = this.appendScalarSubqueryApplyNode(builder, scalarSubquery, correlationAllowed, context);
        }
        return builder;
    }

    private PlanBuilder appendScalarSubqueryApplyNode(PlanBuilder subPlan, SubqueryExpression scalarSubquery, boolean correlationAllowed, SqlPlannerContext context) {
        if (subPlan.canTranslate((Expression)scalarSubquery)) {
            return subPlan;
        }
        List<Expression> coercions = this.coercionsFor((Expression)scalarSubquery);
        SubqueryExpression uncoercedScalarSubquery = this.uncoercedSubquery(scalarSubquery);
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)uncoercedScalarSubquery, context);
        subqueryPlan = subqueryPlan.withNewRoot(new EnforceSingleRowNode((Optional<SourceLocation>)subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subqueryPlan.getRoot()));
        subqueryPlan = subqueryPlan.appendProjections(coercions, this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, context);
        VariableReferenceExpression uncoercedScalarSubqueryVariable = subqueryPlan.translate((Expression)uncoercedScalarSubquery);
        subPlan.getTranslations().put((Expression)uncoercedScalarSubquery, uncoercedScalarSubqueryVariable);
        for (Expression coercion : coercions) {
            VariableReferenceExpression coercionVariable = subqueryPlan.translate(coercion);
            subPlan.getTranslations().put(coercion, coercionVariable);
        }
        return this.appendLateralJoin(subPlan, subqueryPlan, scalarSubquery.getQuery(), correlationAllowed, LateralJoinNode.Type.LEFT, context);
    }

    public PlanBuilder appendLateralJoin(PlanBuilder subPlan, PlanBuilder subqueryPlan, Query query, boolean correlationAllowed, LateralJoinNode.Type type, SqlPlannerContext context) {
        PlanNode subqueryNode = subqueryPlan.getRoot();
        Map<Expression, Expression> correlation = this.extractCorrelation(subPlan, subqueryNode, context);
        if (!correlationAllowed && !correlation.isEmpty()) {
            throw SemanticExceptions.notSupportedException((Node)query, (String)"Correlated subquery in given context");
        }
        subqueryNode = this.replaceExpressionsWithSymbols(subqueryNode, correlation, context);
        return new PlanBuilder(subPlan.copyTranslations(), new LateralJoinNode(subPlan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), subPlan.getRoot(), subqueryNode, (List<VariableReferenceExpression>)ImmutableList.copyOf(VariablesExtractor.extractUnique(correlation.values(), TypeProvider.viewOf(this.variableAllocator.getVariables()))), type, SemanticExceptions.subQueryNotSupportedError((Node)query, (String)"Given correlated subquery")));
    }

    private PlanBuilder appendExistsSubqueryApplyNodes(PlanBuilder builder, Set<ExistsPredicate> existsPredicates, boolean correlationAllowed, boolean mayParticipateInAntiJoin, SqlPlannerContext context) {
        for (ExistsPredicate existsPredicate : existsPredicates) {
            builder = this.appendExistSubqueryApplyNode(builder, existsPredicate, correlationAllowed, mayParticipateInAntiJoin, context);
        }
        return builder;
    }

    private PlanBuilder appendExistSubqueryApplyNode(PlanBuilder subPlan, ExistsPredicate existsPredicate, boolean correlationAllowed, boolean mayParticipateInAntiJoin, SqlPlannerContext context) {
        if (subPlan.canTranslate((Expression)existsPredicate)) {
            return subPlan;
        }
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)existsPredicate.getSubquery(), context);
        PlanNode subqueryPlanRoot = subqueryPlan.getRoot();
        if (SubqueryPlanner.isAggregationWithEmptyGroupBy(subqueryPlanRoot)) {
            subPlan.getTranslations().put((Expression)existsPredicate, (Expression)BooleanLiteral.TRUE_LITERAL);
            return subPlan;
        }
        ProjectNode subqueryNode = new ProjectNode(this.idAllocator.getNextId(), subqueryPlan.getRoot(), Assignments.of());
        VariableReferenceExpression exists = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)existsPredicate), "exists", (Type)BooleanType.BOOLEAN);
        subPlan.getTranslations().put((Expression)existsPredicate, exists);
        return this.appendApplyNode(subPlan, (Node)existsPredicate.getSubquery(), (PlanNode)subqueryNode, Assignments.of((VariableReferenceExpression)exists, (RowExpression)new ExistsExpression(Optional.empty(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT)), correlationAllowed, mayParticipateInAntiJoin, context);
    }

    private PlanBuilder appendQuantifiedComparisonApplyNodes(PlanBuilder subPlan, Set<QuantifiedComparisonExpression> quantifiedComparisons, boolean correlationAllowed, boolean mayParticipateInAntiJoin, Node node, SqlPlannerContext context) {
        for (QuantifiedComparisonExpression quantifiedComparison : quantifiedComparisons) {
            subPlan = this.appendQuantifiedComparisonApplyNode(subPlan, quantifiedComparison, correlationAllowed, mayParticipateInAntiJoin, node, context);
        }
        return subPlan;
    }

    private PlanBuilder appendQuantifiedComparisonApplyNode(PlanBuilder subPlan, QuantifiedComparisonExpression quantifiedComparison, boolean correlationAllowed, boolean mayParticipateInAntiJoin, Node node, SqlPlannerContext context) {
        if (subPlan.canTranslate((Expression)quantifiedComparison)) {
            return subPlan;
        }
        switch (quantifiedComparison.getOperator()) {
            case EQUAL: {
                switch (quantifiedComparison.getQuantifier()) {
                    case ALL: {
                        return this.planQuantifiedApplyNode(subPlan, quantifiedComparison, correlationAllowed, mayParticipateInAntiJoin, context);
                    }
                    case ANY: 
                    case SOME: {
                        InPredicate inPredicate = new InPredicate(quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        subPlan = this.appendInPredicateApplyNode(subPlan, inPredicate, correlationAllowed, mayParticipateInAntiJoin, node, context);
                        subPlan.getTranslations().put((Expression)quantifiedComparison, subPlan.translate((Expression)inPredicate));
                        return subPlan;
                    }
                }
                break;
            }
            case NOT_EQUAL: {
                switch (quantifiedComparison.getQuantifier()) {
                    case ALL: {
                        QuantifiedComparisonExpression rewrittenAny = new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ANY, quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        NotExpression notAny = new NotExpression((Expression)rewrittenAny);
                        subPlan.getTranslations().put((Expression)quantifiedComparison, subPlan.getTranslations().rewrite((Expression)notAny));
                        return this.appendQuantifiedComparisonApplyNode(subPlan, rewrittenAny, correlationAllowed, true, node, context);
                    }
                    case ANY: 
                    case SOME: {
                        QuantifiedComparisonExpression rewrittenAll = new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        NotExpression notAll = new NotExpression((Expression)rewrittenAll);
                        subPlan.getTranslations().put((Expression)quantifiedComparison, subPlan.getTranslations().rewrite((Expression)notAll));
                        return this.appendQuantifiedComparisonApplyNode(subPlan, rewrittenAll, correlationAllowed, true, node, context);
                    }
                }
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return this.planQuantifiedApplyNode(subPlan, quantifiedComparison, correlationAllowed, mayParticipateInAntiJoin, context);
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected quantified comparison: '%s %s'", quantifiedComparison.getOperator().getValue(), quantifiedComparison.getQuantifier()));
    }

    private PlanBuilder planQuantifiedApplyNode(PlanBuilder subPlan, QuantifiedComparisonExpression quantifiedComparison, boolean correlationAllowed, boolean mayParticipateInAntiJoin, SqlPlannerContext context) {
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)quantifiedComparison.getValue()), this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, context);
        Preconditions.checkState((boolean)(quantifiedComparison.getSubquery() instanceof SubqueryExpression));
        SubqueryExpression quantifiedSubquery = (SubqueryExpression)quantifiedComparison.getSubquery();
        SubqueryExpression uncoercedQuantifiedSubquery = this.uncoercedSubquery(quantifiedSubquery);
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)uncoercedQuantifiedSubquery, context);
        subqueryPlan = subqueryPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)quantifiedSubquery), this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, context);
        QuantifiedComparisonExpression coercedQuantifiedComparison = new QuantifiedComparisonExpression(quantifiedComparison.getOperator(), quantifiedComparison.getQuantifier(), (Expression)ExpressionTreeUtils.createSymbolReference(subPlan.translate(quantifiedComparison.getValue())), (Expression)ExpressionTreeUtils.createSymbolReference(subqueryPlan.translate((Expression)quantifiedSubquery)));
        VariableReferenceExpression coercedQuantifiedComparisonVariable = PlannerUtils.newVariable(this.variableAllocator, (Expression)coercedQuantifiedComparison, (Type)BooleanType.BOOLEAN);
        subPlan.getTranslations().put((Expression)quantifiedComparison, coercedQuantifiedComparisonVariable);
        return this.appendApplyNode(subPlan, (Node)quantifiedComparison.getSubquery(), subqueryPlan.getRoot(), Assignments.of((VariableReferenceExpression)coercedQuantifiedComparisonVariable, (RowExpression)this.rowExpression((Expression)coercedQuantifiedComparison, context)), correlationAllowed, mayParticipateInAntiJoin, context);
    }

    private static boolean isAggregationWithEmptyGroupBy(PlanNode planNode) {
        return PlanNodeSearcher.searchFrom(planNode).recurseOnlyWhen(MorePredicates.isInstanceOfAny(ProjectNode.class)).where(AggregationNode.class::isInstance).findFirst().map(AggregationNode.class::cast).map(aggregation -> aggregation.getGroupingKeys().isEmpty()).orElse(false);
    }

    private SubqueryExpression uncoercedSubquery(SubqueryExpression subquery) {
        return new SubqueryExpression(subquery.getQuery());
    }

    private List<Expression> coercionsFor(Expression expression) {
        return (List)this.analysis.getCoercions().keySet().stream().map(NodeRef::getNode).filter(coercionExpression -> coercionExpression.equals((Object)expression)).collect(ImmutableList.toImmutableList());
    }

    private PlanBuilder appendApplyNode(PlanBuilder subPlan, Node subquery, PlanNode subqueryNode, Assignments subqueryAssignments, boolean correlationAllowed, boolean mayParticipateInAntiJoin, SqlPlannerContext context) {
        Map<Expression, Expression> correlation = this.extractCorrelation(subPlan, subqueryNode, context);
        if (!correlationAllowed && !correlation.isEmpty()) {
            throw SemanticExceptions.notSupportedException((Node)subquery, (String)"Correlated subquery in given context");
        }
        subPlan = subPlan.appendProjections(correlation.keySet(), this.variableAllocator, this.idAllocator, this.session, this.metadata, this.sqlParser, this.analysis, context);
        subqueryNode = this.replaceExpressionsWithSymbols(subqueryNode, correlation, context);
        TranslationMap translations = subPlan.copyTranslations();
        PlanNode root = subPlan.getRoot();
        ApplyNodeUtil.verifySubquerySupported(subqueryAssignments);
        return new PlanBuilder(translations, new ApplyNode(subqueryNode.getSourceLocation(), this.idAllocator.getNextId(), root, subqueryNode, subqueryAssignments, (List<VariableReferenceExpression>)ImmutableList.copyOf(VariablesExtractor.extractUnique(correlation.values(), TypeProvider.viewOf(this.variableAllocator.getVariables()))), SemanticExceptions.subQueryNotSupportedError((Node)subquery, (String)"Given correlated subquery"), mayParticipateInAntiJoin));
    }

    private Map<Expression, Expression> extractCorrelation(PlanBuilder subPlan, PlanNode subquery, SqlPlannerContext context) {
        Set<Expression> missingReferences = this.extractOuterColumnReferences(subquery, context);
        ImmutableMap.Builder correlation = ImmutableMap.builder();
        for (Expression missingReference : missingReferences) {
            SubqueryPlanner.tryResolveMissingExpression(subPlan, missingReference).ifPresent(symbolReference -> correlation.put((Object)missingReference, symbolReference));
        }
        return correlation.build();
    }

    private static Optional<Expression> tryResolveMissingExpression(PlanBuilder subPlan, Expression expression) {
        Expression rewritten = subPlan.rewrite(expression);
        if (rewritten != expression) {
            return Optional.of(rewritten);
        }
        return Optional.empty();
    }

    private PlanBuilder createPlanBuilder(Node node, SqlPlannerContext context) {
        RelationPlan relationPlan = new RelationPlanner(this.analysis, this.variableAllocator, this.idAllocator, this.lambdaDeclarationToVariableMap, this.metadata, this.session, this.sqlParser).process(node, context);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToVariableMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        if (node instanceof Expression && relationPlan.getFieldMappings().size() == 1) {
            translations.put((Expression)node, (VariableReferenceExpression)Iterables.getOnlyElement(relationPlan.getFieldMappings()));
        }
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private Set<Expression> extractOuterColumnReferences(PlanNode planNode, SqlPlannerContext context) {
        return (Set)ExpressionExtractor.extractExpressions(planNode).stream().filter(rowExpression -> context.getTranslatorContext().getExpressionMap().containsKey(rowExpression)).map(rowExpression -> context.getTranslatorContext().getExpressionMap().get(rowExpression)).flatMap(expression -> SubqueryPlanner.extractColumnReferences(expression, this.analysis.getColumnReferences()).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private RowExpression rowExpression(Expression expression, SqlPlannerContext context) {
        return TranslateExpressionsUtil.toRowExpression(expression, this.metadata, this.session, this.sqlParser, this.variableAllocator, this.analysis, context.getTranslatorContext());
    }

    private static Set<Expression> extractColumnReferences(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ImmutableSet.Builder expressionColumnReferences = ImmutableSet.builder();
        new ColumnReferencesExtractor(columnReferences).process((Node)expression, expressionColumnReferences);
        return expressionColumnReferences.build();
    }

    private PlanNode replaceExpressionsWithSymbols(PlanNode planNode, Map<Expression, Expression> mapping, SqlPlannerContext context) {
        if (mapping.isEmpty()) {
            return planNode;
        }
        HashMap rowExpressionMapping = new HashMap();
        mapping.forEach((key, value) -> rowExpressionMapping.put(context.getTranslatorContext().getRowExpressionMap().get(key), this.rowExpression((Expression)value, context)));
        return SimplePlanRewriter.rewriteWith(new ExpressionReplacer(this.idAllocator, (Map<RowExpression, RowExpression>)ImmutableMap.copyOf(rowExpressionMapping)), planNode, null);
    }

    private boolean detectAntiJoinInExpression(Expression expression) {
        AntiJoinDetector antiJoinDetector = new AntiJoinDetector();
        antiJoinDetector.process((Node)expression);
        return antiJoinDetector.getMayContainAntiJoin();
    }

    private static class AntiJoinDetector
    extends DefaultExpressionTraversalVisitor<Void, Void> {
        private boolean mayContainAntiJoin;

        private AntiJoinDetector() {
        }

        protected Void visitNotExpression(NotExpression node, Void context) {
            this.mayContainAntiJoin = true;
            return null;
        }

        protected Void visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            if (node.getOperator() == LogicalBinaryExpression.Operator.OR) {
                this.mayContainAntiJoin = true;
                return null;
            }
            this.process((Node)node.getRight(), context);
            this.process((Node)node.getLeft(), context);
            return null;
        }

        protected Void visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            this.mayContainAntiJoin = true;
            return null;
        }

        protected Void visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            this.mayContainAntiJoin = true;
            return null;
        }

        public boolean getMayContainAntiJoin() {
            return this.mayContainAntiJoin;
        }
    }

    private static class ExpressionReplacer
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Map<RowExpression, RowExpression> mapping;

        public ExpressionReplacer(PlanNodeIdAllocator idAllocator, Map<RowExpression, RowExpression> mapping) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.mapping = Objects.requireNonNull(mapping, "mapping is null");
        }

        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ProjectNode rewrittenNode = (ProjectNode)context.defaultRewrite((PlanNode)node);
            Assignments assignments = AssignmentUtils.rewrite(rewrittenNode.getAssignments(), expression -> RowExpressionNodeInliner.replaceExpression((RowExpression)expression, this.mapping));
            return new ProjectNode(this.idAllocator.getNextId(), rewrittenNode.getSource(), assignments);
        }

        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            FilterNode rewrittenNode = (FilterNode)context.defaultRewrite((PlanNode)node);
            return new FilterNode(node.getSourceLocation(), this.idAllocator.getNextId(), rewrittenNode.getSource(), RowExpressionNodeInliner.replaceExpression((RowExpression)rewrittenNode.getPredicate(), this.mapping));
        }

        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ValuesNode rewrittenNode = (ValuesNode)context.defaultRewrite((PlanNode)node);
            List rewrittenRows = (List)rewrittenNode.getRows().stream().map(row -> (ImmutableList)row.stream().map(column -> RowExpressionNodeInliner.replaceExpression((RowExpression)column, this.mapping)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
            return new ValuesNode(node.getSourceLocation(), this.idAllocator.getNextId(), rewrittenNode.getOutputVariables(), rewrittenRows, node.getValuesNodeLabel());
        }
    }

    private static class ColumnReferencesExtractor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableSet.Builder<Expression>> {
        private final Set<NodeRef<Expression>> columnReferences;

        private ColumnReferencesExtractor(Set<NodeRef<Expression>> columnReferences) {
            this.columnReferences = Objects.requireNonNull(columnReferences, "columnReferences is null");
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableSet.Builder<Expression> builder) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                builder.add((Object)node);
            } else {
                this.process((Node)node.getBase(), builder);
            }
            return null;
        }

        protected Void visitIdentifier(Identifier node, ImmutableSet.Builder<Expression> builder) {
            builder.add((Object)node);
            return null;
        }
    }
}

