/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.properties.EquivalenceClassProperty;
import com.facebook.presto.sql.planner.iterative.properties.Key;
import com.facebook.presto.sql.planner.iterative.properties.KeyProperty;
import com.facebook.presto.sql.planner.iterative.properties.MaxCardProperty;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LogicalPropertiesImpl
implements LogicalProperties {
    public static final LogicalPropertiesImpl DEFAULT_LOGICAL_PROPERTIES = new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), new KeyProperty());
    private final MaxCardProperty maxCardProperty;
    private final KeyProperty keyProperty;
    private final EquivalenceClassProperty equivalenceClassProperty;

    public LogicalPropertiesImpl(EquivalenceClassProperty equivalenceClassProperty, MaxCardProperty maxCardProperty, KeyProperty keyProperty) {
        this.equivalenceClassProperty = Objects.requireNonNull(equivalenceClassProperty, "equivalenceClassProperty is null");
        this.maxCardProperty = Objects.requireNonNull(maxCardProperty, "maxCardProperty is null");
        this.keyProperty = Objects.requireNonNull(keyProperty, "keyProperty is null");
    }

    private boolean isMoreGeneralThan(LogicalPropertiesImpl otherLogicalProperties) {
        return this.maxCardProperty.moreGeneral(otherLogicalProperties.maxCardProperty) && this.keyProperty.moreGeneral(otherLogicalProperties.keyProperty) && this.equivalenceClassProperty.isMoreGeneralThan(otherLogicalProperties.equivalenceClassProperty);
    }

    public boolean equals(LogicalPropertiesImpl otherLogicalProperties) {
        return this.isMoreGeneralThan(otherLogicalProperties) && otherLogicalProperties.isMoreGeneralThan(this);
    }

    private static Map<VariableReferenceExpression, VariableReferenceExpression> inverseVariableAssignments(Assignments assignments) {
        HashMap<VariableReferenceExpression, VariableReferenceExpression> inverseVariableAssignments = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        for (Map.Entry e : assignments.entrySet()) {
            if (!(e.getValue() instanceof VariableReferenceExpression)) continue;
            inverseVariableAssignments.put((VariableReferenceExpression)e.getValue(), (VariableReferenceExpression)e.getKey());
        }
        return inverseVariableAssignments;
    }

    private static LogicalPropertiesImpl normalizeKeyPropertyAndSetMaxCard(KeyProperty keyProperty, MaxCardProperty maxCardProperty, EquivalenceClassProperty equivalenceClassProperty) {
        if (maxCardProperty.isAtMostOne()) {
            return new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, new KeyProperty());
        }
        Optional<KeyProperty> normalizedKeyProperty = KeyProperty.getNormalizedKeyProperty(keyProperty, equivalenceClassProperty);
        if (normalizedKeyProperty.isPresent()) {
            KeyProperty newKeyProperty = new KeyProperty(normalizedKeyProperty.get().getKeys());
            MaxCardProperty newMaxCardProperty = maxCardProperty;
            return new LogicalPropertiesImpl(equivalenceClassProperty, newMaxCardProperty, newKeyProperty);
        }
        MaxCardProperty newMaxCardProperty = new MaxCardProperty(1L);
        KeyProperty newKeyProperty = new KeyProperty();
        return new LogicalPropertiesImpl(equivalenceClassProperty, newMaxCardProperty, newKeyProperty);
    }

    public boolean isDistinct(Set<VariableReferenceExpression> keyVars) {
        Preconditions.checkArgument((!keyVars.isEmpty() ? 1 : 0) != 0, (Object)"keyVars is empty");
        return this.keyRequirementSatisfied(new Key(keyVars));
    }

    public boolean isAtMostSingleRow() {
        return this.isAtMost(1L);
    }

    public boolean isAtMost(long n) {
        return this.maxCardProperty.isAtMost(n);
    }

    public boolean canBeHomogenized(Set<VariableReferenceExpression> expressions, Set<VariableReferenceExpression> targetVariables) {
        Set expressionsInTermsOfEquivalenceClassHeads = expressions.stream().map(this.equivalenceClassProperty::getEquivalenceClassHead).collect(Collectors.toSet());
        Set targetVariablesInTermsOfEquivalenceClassHeads = targetVariables.stream().map(this.equivalenceClassProperty::getEquivalenceClassHead).collect(Collectors.toSet());
        return targetVariablesInTermsOfEquivalenceClassHeads.containsAll(expressionsInTermsOfEquivalenceClassHeads);
    }

    private boolean keyRequirementSatisfied(Key keyRequirement) {
        if (this.maxCardProperty.isAtMostOne()) {
            return true;
        }
        Optional<Key> normalizedKeyRequirement = Key.getNormalizedKey(keyRequirement, this.equivalenceClassProperty);
        if (normalizedKeyRequirement.isPresent()) {
            return this.keyProperty.satisfiesKeyRequirement(keyRequirement);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("KeyProperty", (Object)this.keyProperty).add("EquivalenceClassProperty", (Object)this.equivalenceClassProperty).add("MaxCardProperty", (Object)this.maxCardProperty).toString();
    }

    public static LogicalPropertiesImpl propagateProperties(LogicalPropertiesImpl sourceProperties) {
        KeyProperty keyProperty = new KeyProperty(sourceProperties.keyProperty);
        MaxCardProperty maxCardProperty = new MaxCardProperty(sourceProperties.maxCardProperty);
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(sourceProperties.equivalenceClassProperty);
        return new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty);
    }

    public static LogicalPropertiesImpl tableScanProperties(List<Set<VariableReferenceExpression>> keys) {
        KeyProperty keyProperty = new KeyProperty(keys.stream().map(Key::new).collect(Collectors.toSet()));
        return new LogicalPropertiesImpl(new EquivalenceClassProperty(), new MaxCardProperty(), keyProperty);
    }

    public static LogicalPropertiesImpl filterProperties(LogicalPropertiesImpl sourceProperties, RowExpression predicate, FunctionResolution functionResolution) {
        MaxCardProperty maxCardProperty = new MaxCardProperty(sourceProperties.maxCardProperty);
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(sourceProperties.equivalenceClassProperty);
        KeyProperty keyProperty = new KeyProperty(sourceProperties.keyProperty);
        EquivalenceClassProperty newEquivalenceClassProperty = equivalenceClassProperty.addPredicate(predicate, functionResolution);
        if (newEquivalenceClassProperty != equivalenceClassProperty) {
            return LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(keyProperty, maxCardProperty, newEquivalenceClassProperty);
        }
        return new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty);
    }

    public static LogicalPropertiesImpl projectProperties(LogicalPropertiesImpl sourceProperties, Assignments assignments) {
        MaxCardProperty maxCardProperty = new MaxCardProperty(sourceProperties.maxCardProperty);
        KeyProperty keyProperty = new KeyProperty(sourceProperties.keyProperty);
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(sourceProperties.equivalenceClassProperty);
        Map<VariableReferenceExpression, VariableReferenceExpression> inverseVariableAssignments = LogicalPropertiesImpl.inverseVariableAssignments(assignments);
        keyProperty = keyProperty.project(new InverseVariableMappingsWithEquivalence(equivalenceClassProperty, inverseVariableAssignments));
        equivalenceClassProperty = equivalenceClassProperty.project(inverseVariableAssignments);
        return LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(keyProperty, maxCardProperty, equivalenceClassProperty);
    }

    public static LogicalPropertiesImpl propagateAndLimitProperties(LogicalPropertiesImpl sourceProperties, long limit) {
        MaxCardProperty maxCardProperty = sourceProperties.maxCardProperty.getMinMaxCardProperty(limit);
        KeyProperty keyProperty = maxCardProperty.isAtMostOne() ? new KeyProperty() : new KeyProperty(sourceProperties.keyProperty);
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(sourceProperties.equivalenceClassProperty);
        return new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty);
    }

    public static LogicalPropertiesImpl aggregationProperties(LogicalPropertiesImpl sourceProperties, Set<VariableReferenceExpression> keyVariables) {
        LogicalPropertiesImpl resultProperties;
        Preconditions.checkArgument((!keyVariables.isEmpty() ? 1 : 0) != 0, (Object)"keyVariables is empty");
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty(sourceProperties.equivalenceClassProperty);
        MaxCardProperty maxCardProperty = new MaxCardProperty(sourceProperties.maxCardProperty);
        if (!maxCardProperty.isAtMostOne()) {
            KeyProperty keyProperty = new KeyProperty(KeyProperty.combineKey(sourceProperties.keyProperty.getKeys(), new Key(keyVariables)));
            resultProperties = LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(keyProperty, maxCardProperty, equivalenceClassProperty);
        } else {
            KeyProperty keyProperty = new KeyProperty(sourceProperties.keyProperty);
            resultProperties = new LogicalPropertiesImpl(equivalenceClassProperty, maxCardProperty, keyProperty);
        }
        return resultProperties;
    }

    public static LogicalPropertiesImpl distinctLimitProperties(LogicalPropertiesImpl sourceProperties, Set<VariableReferenceExpression> keyVariables, Long limit) {
        Preconditions.checkArgument((!keyVariables.isEmpty() ? 1 : 0) != 0, (Object)"keyVariables is empty");
        LogicalPropertiesImpl aggregationProperties = LogicalPropertiesImpl.aggregationProperties(sourceProperties, keyVariables);
        return LogicalPropertiesImpl.propagateAndLimitProperties(aggregationProperties, limit);
    }

    public static LogicalPropertiesImpl joinProperties(LogicalPropertiesImpl leftProperties, LogicalPropertiesImpl rightProperties, List<EquiJoinClause> equijoinPredicates, JoinType joinType, Optional<RowExpression> filterPredicate, FunctionResolution functionResolution) {
        MaxCardProperty maxCardProperty = new MaxCardProperty();
        EquivalenceClassProperty equivalenceClassProperty = new EquivalenceClassProperty();
        KeyProperty keyProperty = new KeyProperty();
        boolean nToOne = false;
        boolean oneToN = false;
        Set<VariableReferenceExpression> rightJoinVariables = equijoinPredicates.stream().map(EquiJoinClause::getRight).collect(Collectors.toSet());
        Set<VariableReferenceExpression> leftJoinVariables = equijoinPredicates.stream().map(EquiJoinClause::getLeft).collect(Collectors.toSet());
        if ((rightProperties.maxCardProperty.isAtMostOne() || !rightJoinVariables.isEmpty() && rightProperties.isDistinct(rightJoinVariables)) && (joinType == JoinType.INNER || joinType == JoinType.LEFT || joinType == JoinType.FULL && leftProperties.maxCardProperty.isAtMost(1L))) {
            nToOne = true;
            keyProperty = KeyProperty.combineKeys(keyProperty, leftProperties.keyProperty);
            maxCardProperty = maxCardProperty.getMinMaxCardProperty(leftProperties.maxCardProperty);
        }
        if ((leftProperties.maxCardProperty.isAtMostOne() || !leftJoinVariables.isEmpty() && leftProperties.isDistinct(leftJoinVariables)) && (joinType == JoinType.INNER || joinType == JoinType.RIGHT || joinType == JoinType.FULL && rightProperties.maxCardProperty.isAtMost(1L))) {
            oneToN = true;
            keyProperty = KeyProperty.combineKeys(keyProperty, rightProperties.keyProperty);
            maxCardProperty = maxCardProperty.getMinMaxCardProperty(rightProperties.maxCardProperty);
        }
        if (!nToOne && !oneToN) {
            maxCardProperty = maxCardProperty.getMinMaxCardProperty(leftProperties.maxCardProperty);
            maxCardProperty = MaxCardProperty.multiplyMaxCard(maxCardProperty, rightProperties.maxCardProperty);
            if (joinType == JoinType.INNER) {
                keyProperty = KeyProperty.combineKeys(keyProperty, leftProperties.keyProperty);
                keyProperty = KeyProperty.concatKeyProperty(keyProperty, rightProperties.keyProperty);
            }
        }
        if (joinType == JoinType.INNER || joinType == JoinType.LEFT) {
            equivalenceClassProperty = equivalenceClassProperty.combineWith(leftProperties.equivalenceClassProperty);
        }
        if (joinType == JoinType.INNER || joinType == JoinType.RIGHT) {
            equivalenceClassProperty = equivalenceClassProperty.combineWith(rightProperties.equivalenceClassProperty);
        }
        if (joinType == JoinType.INNER) {
            for (EquiJoinClause equiJoinClause : equijoinPredicates) {
                equivalenceClassProperty = equivalenceClassProperty.combineWith((RowExpression)equiJoinClause.getLeft(), (RowExpression)equiJoinClause.getRight());
            }
            if (filterPredicate.isPresent()) {
                equivalenceClassProperty = equivalenceClassProperty.addPredicate(filterPredicate.get(), functionResolution);
            }
        }
        return LogicalPropertiesImpl.normalizeKeyPropertyAndSetMaxCard(keyProperty, maxCardProperty, equivalenceClassProperty);
    }

    public static class InverseVariableMappingsWithEquivalence {
        private final EquivalenceClassProperty equivalenceClassProperty;
        private final Map<VariableReferenceExpression, VariableReferenceExpression> inverseMappings;

        InverseVariableMappingsWithEquivalence(EquivalenceClassProperty equivalenceClassProperty, Map<VariableReferenceExpression, VariableReferenceExpression> inverseMappings) {
            Objects.requireNonNull(equivalenceClassProperty, "equivalenceClassProperty is null");
            Objects.requireNonNull(inverseMappings, "inverseMappings is null");
            this.equivalenceClassProperty = equivalenceClassProperty;
            this.inverseMappings = inverseMappings;
        }

        private boolean containsKey(VariableReferenceExpression variable) {
            if (!this.inverseMappings.containsKey(variable)) {
                RowExpression head = this.equivalenceClassProperty.getEquivalenceClassHead((RowExpression)variable);
                ArrayList<RowExpression> equivalentVariables = new ArrayList<RowExpression>();
                equivalentVariables.add(head);
                equivalentVariables.addAll(this.equivalenceClassProperty.getEquivalenceClasses(head));
                for (RowExpression e : equivalentVariables) {
                    if (!(e instanceof VariableReferenceExpression) || !this.inverseMappings.containsKey(e)) continue;
                    this.inverseMappings.put(variable, this.inverseMappings.get(e));
                    break;
                }
            }
            return this.inverseMappings.containsKey(variable);
        }

        public Optional<VariableReferenceExpression> get(VariableReferenceExpression variable) {
            if (this.containsKey(variable)) {
                return Optional.of(this.inverseMappings.get(variable));
            }
            return Optional.empty();
        }
    }
}

