/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AssignmentUtils;
import com.facebook.presto.sql.planner.plan.OffsetNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ImplementOffset
implements Rule<OffsetNode> {
    private static final Pattern<OffsetNode> PATTERN = Patterns.offset();
    private final StandardFunctionResolution functionResolution;

    public ImplementOffset(FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    @Override
    public Pattern<OffsetNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(OffsetNode parent, Captures captures, Rule.Context context) {
        if (!SystemSessionProperties.isOffsetClauseEnabled(context.getSession())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Offset support is not enabled");
        }
        VariableReferenceExpression rowNumberSymbol = context.getVariableAllocator().newVariable("row_number", (Type)BigintType.BIGINT);
        RowNumberNode rowNumberNode = new RowNumberNode(parent.getSourceLocation(), context.getIdAllocator().getNextId(), parent.getSource(), (List<VariableReferenceExpression>)ImmutableList.of(), rowNumberSymbol, Optional.empty(), false, Optional.empty());
        FilterNode filterNode = new FilterNode(parent.getSourceLocation(), context.getIdAllocator().getNextId(), (PlanNode)rowNumberNode, Expressions.comparisonExpression(this.functionResolution, OperatorType.GREATER_THAN, (RowExpression)rowNumberSymbol, (RowExpression)new ConstantExpression((Object)parent.getCount(), (Type)BigintType.BIGINT)));
        ProjectNode projectNode = new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)filterNode, AssignmentUtils.identityAssignments(parent.getOutputVariables()));
        return Rule.Result.ofPlanNode((PlanNode)projectNode);
    }
}

