/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LeftJoinWithArrayContainsToEquiJoinCondition
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(x -> x.getType().equals((Object)JoinType.LEFT) && x.getCriteria().isEmpty() && x.getFilter().isPresent());
    private final FunctionAndTypeManager functionAndTypeManager;
    private final RowExpressionDeterminismEvaluator determinismEvaluator;
    private final FunctionResolution functionResolution;

    public LeftJoinWithArrayContainsToEquiJoinCondition(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.determinismEvaluator = new RowExpressionDeterminismEvaluator(functionAndTypeManager);
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.getLeftJoinArrayContainsToInnerJoinStrategy(session).equals((Object)FeaturesConfig.LeftJoinArrayContainsToInnerJoinStrategy.ALWAYS_ENABLED);
    }

    @Override
    public Rule.Result apply(JoinNode node, Captures captures, Rule.Context context) {
        VariableReferenceExpression elementVariable;
        RowExpression filterPredicate = node.getFilter().get();
        List leftInput = node.getLeft().getOutputVariables();
        List rightInput = node.getRight().getOutputVariables();
        List andConjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)filterPredicate);
        Optional<RowExpression> arrayContains = andConjuncts.stream().filter(rowExpression -> this.isSupportedJoinCondition((RowExpression)rowExpression, leftInput, rightInput)).findFirst();
        if (!arrayContains.isPresent()) {
            return Rule.Result.empty();
        }
        List remainingConjuncts = (List)andConjuncts.stream().filter(rowExpression -> !rowExpression.equals(arrayContains.get())).collect(ImmutableList.toImmutableList());
        RowExpression array = (RowExpression)((CallExpression)arrayContains.get()).getArguments().get(0);
        RowExpression element = (RowExpression)((CallExpression)arrayContains.get()).getArguments().get(1);
        Preconditions.checkState((array.getType() instanceof ArrayType && ((ArrayType)array.getType()).getElementType().equals(element.getType()) ? 1 : 0) != 0);
        PlanNode newLeft = node.getLeft();
        ImmutableMap.Builder leftAssignment = ImmutableMap.builder();
        if (!(element instanceof VariableReferenceExpression)) {
            elementVariable = context.getVariableAllocator().newVariable(element);
            leftAssignment.put((Object)elementVariable, (Object)element);
            newLeft = PlannerUtils.addProjections(node.getLeft(), context.getIdAllocator(), (Map<VariableReferenceExpression, RowExpression>)leftAssignment.build());
        } else {
            elementVariable = (VariableReferenceExpression)element;
        }
        CallExpression arrayDistinct = Expressions.call(this.functionAndTypeManager, "array_distinct", (Type)new ArrayType(element.getType()), array);
        CallExpression arrayFilterNull = Expressions.call(this.functionAndTypeManager, "remove_nulls", arrayDistinct.getType(), (List<RowExpression>)ImmutableList.of((Object)arrayDistinct));
        VariableReferenceExpression arrayFilterNullVariable = context.getVariableAllocator().newVariable((RowExpression)arrayFilterNull);
        PlanNode newRight = PlannerUtils.addProjections(node.getRight(), context.getIdAllocator(), (Map<VariableReferenceExpression, RowExpression>)ImmutableMap.of((Object)arrayFilterNullVariable, (Object)arrayFilterNull));
        VariableReferenceExpression unnestVariable = context.getVariableAllocator().newVariable("unnest", element.getType());
        UnnestNode unnestNode = new UnnestNode(newRight.getSourceLocation(), context.getIdAllocator().getNextId(), newRight, newRight.getOutputVariables(), (Map<VariableReferenceExpression, List<VariableReferenceExpression>>)ImmutableMap.of((Object)arrayFilterNullVariable, (Object)ImmutableList.of((Object)unnestVariable)), Optional.empty());
        EquiJoinClause equiJoinClause = new EquiJoinClause(elementVariable, unnestVariable);
        return Rule.Result.ofPlanNode(new JoinNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getType(), newLeft, unnestNode, (List<EquiJoinClause>)ImmutableList.of((Object)equiJoinClause), node.getOutputVariables(), remainingConjuncts.isEmpty() ? Optional.empty() : Optional.of(LogicalRowExpressions.and((Collection)remainingConjuncts)), Optional.empty(), Optional.empty(), node.getDistributionType(), node.getDynamicFilters()));
    }

    private boolean isSupportedJoinCondition(RowExpression rowExpression, List<VariableReferenceExpression> leftInput, List<VariableReferenceExpression> rightInput) {
        if (rowExpression instanceof CallExpression && this.functionResolution.isArrayContainsFunction(((CallExpression)rowExpression).getFunctionHandle())) {
            RowExpression arrayExpression = (RowExpression)((CallExpression)rowExpression).getArguments().get(0);
            RowExpression elementExpression = (RowExpression)((CallExpression)rowExpression).getArguments().get(1);
            return this.determinismEvaluator.isDeterministic(arrayExpression) && rightInput.containsAll(VariablesExtractor.extractAll(arrayExpression)) && this.determinismEvaluator.isDeterministic(elementExpression) && leftInput.containsAll(VariablesExtractor.extractAll(elementExpression));
        }
        return false;
    }
}

