/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class RemoveRedundantAggregateDistinct
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(RemoveRedundantAggregateDistinct::hasAggregations);

    private static boolean hasAggregations(AggregationNode node) {
        return ((GroupReference)node.getSource()).getLogicalProperties().isPresent() && !node.getAggregations().isEmpty() && node.getGroupingSetCount() == 1;
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        ImmutableMap.Builder aggregationsBuilder = ImmutableMap.builder();
        for (AbstractMap.SimpleEntry simpleEntry : node.getAggregations().entrySet()) {
            aggregationsBuilder.put((Map.Entry)(this.canRemoveDistinct(node, (AggregationNode.Aggregation)simpleEntry.getValue()) ? new AbstractMap.SimpleEntry(simpleEntry.getKey(), AggregationNode.Aggregation.removeDistinct((AggregationNode.Aggregation)((AggregationNode.Aggregation)simpleEntry.getValue()))) : simpleEntry));
        }
        ImmutableMap newAggregations = aggregationsBuilder.build();
        if (newAggregations.equals(node.getAggregations())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode((PlanNode)new AggregationNode(node.getSourceLocation(), context.getIdAllocator().getNextId(), node.getSource(), (Map)newAggregations, node.getGroupingSets(), node.getPreGroupedVariables(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable(), node.getAggregationId()));
    }

    private boolean canRemoveDistinct(AggregationNode node, AggregationNode.Aggregation aggregation) {
        if (!aggregation.isDistinct()) {
            return false;
        }
        if (!node.getGroupingKeys().stream().allMatch(key -> key instanceof VariableReferenceExpression) || !aggregation.getArguments().stream().allMatch(arg -> arg instanceof VariableReferenceExpression)) {
            return false;
        }
        Set varAndGroupingKeySet = (Set)Stream.concat(node.getGroupingKeys().stream().map(VariableReferenceExpression.class::cast), aggregation.getArguments().stream().map(VariableReferenceExpression.class::cast)).collect(ImmutableSet.toImmutableSet());
        return ((GroupReference)node.getSource()).getLogicalProperties().get().isDistinct(varAndGroupingKeySet);
    }
}

