/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.SpatialJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class RowExpressionRewriteRuleSet {
    protected final PlanRowExpressionRewriter rewriter;

    public RowExpressionRewriteRuleSet(PlanRowExpressionRewriter rewriter) {
        this.rewriter = Objects.requireNonNull(rewriter, "rewriter is null");
    }

    public boolean isRewriterEnabled(Session session) {
        return true;
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.valueRowExpressionRewriteRule(), this.filterRowExpressionRewriteRule(), this.projectRowExpressionRewriteRule(), this.applyNodeRowExpressionRewriteRule(), this.windowRowExpressionRewriteRule(), this.joinRowExpressionRewriteRule(), (Object[])new Rule[]{this.spatialJoinRowExpressionRewriteRule(), this.aggregationRowExpressionRewriteRule(), this.tableFinishRowExpressionRewriteRule(), this.tableWriterRowExpressionRewriteRule()});
    }

    public Rule<ValuesNode> valueRowExpressionRewriteRule() {
        return new ValuesRowExpressionRewrite();
    }

    public Rule<FilterNode> filterRowExpressionRewriteRule() {
        return new FilterRowExpressionRewrite();
    }

    public Rule<ProjectNode> projectRowExpressionRewriteRule() {
        return new ProjectRowExpressionRewrite();
    }

    public Rule<ApplyNode> applyNodeRowExpressionRewriteRule() {
        return new ApplyRowExpressionRewrite();
    }

    public Rule<WindowNode> windowRowExpressionRewriteRule() {
        return new WindowRowExpressionRewrite();
    }

    public Rule<JoinNode> joinRowExpressionRewriteRule() {
        return new JoinRowExpressionRewrite();
    }

    public Rule<SpatialJoinNode> spatialJoinRowExpressionRewriteRule() {
        return new SpatialJoinRowExpressionRewrite();
    }

    public Rule<TableFinishNode> tableFinishRowExpressionRewriteRule() {
        return new TableFinishRowExpressionRewrite();
    }

    public Rule<TableWriterNode> tableWriterRowExpressionRewriteRule() {
        return new TableWriterRowExpressionRewrite();
    }

    public Rule<AggregationNode> aggregationRowExpressionRewriteRule() {
        return new AggregationRowExpressionRewrite();
    }

    private Optional<Assignments> translateAssignments(Assignments assignments, Rule.Context context) {
        Assignments.Builder builder = Assignments.builder();
        assignments.getMap().entrySet().stream().forEach(entry -> builder.put((VariableReferenceExpression)entry.getKey(), this.rewriter.rewrite((RowExpression)entry.getValue(), context)));
        Assignments rewritten = builder.build();
        if (rewritten.equals((Object)assignments)) {
            return Optional.empty();
        }
        return Optional.of(rewritten);
    }

    private Optional<StatisticAggregations> translateStatisticAggregation(StatisticAggregations statisticAggregations, Rule.Context context) {
        ImmutableMap.Builder rewrittenAggregation = ImmutableMap.builder();
        boolean changed = false;
        for (Map.Entry<VariableReferenceExpression, AggregationNode.Aggregation> entry : statisticAggregations.getAggregations().entrySet()) {
            AggregationNode.Aggregation rewritten = this.rewriteAggregation(entry.getValue(), context);
            rewrittenAggregation.put((Object)entry.getKey(), (Object)rewritten);
            if (rewritten.equals((Object)entry.getValue())) continue;
            changed = true;
        }
        if (changed) {
            return Optional.of(new StatisticAggregations((Map<VariableReferenceExpression, AggregationNode.Aggregation>)rewrittenAggregation.build(), statisticAggregations.getGroupingVariables()));
        }
        return Optional.empty();
    }

    private AggregationNode.Aggregation rewriteAggregation(AggregationNode.Aggregation aggregation, Rule.Context context) {
        RowExpression rewrittenCall = this.rewriter.rewrite((RowExpression)aggregation.getCall(), context);
        Preconditions.checkArgument((boolean)(rewrittenCall instanceof CallExpression), (Object)"Aggregation CallExpression must be rewritten to CallExpression");
        return new AggregationNode.Aggregation((CallExpression)rewrittenCall, aggregation.getFilter().map(filter -> this.rewriter.rewrite((RowExpression)filter, context)), aggregation.getOrderBy(), aggregation.isDistinct(), aggregation.getMask());
    }

    private final class TableWriterRowExpressionRewrite
    extends RowExpressionRewriteRule<TableWriterNode> {
        private TableWriterRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<TableWriterNode> getPattern() {
            return Patterns.tableWriterNode();
        }

        @Override
        public Rule.Result apply(TableWriterNode node, Captures captures, Rule.Context context) {
            Preconditions.checkState((node.getSource() != null ? 1 : 0) != 0);
            if (!node.getStatisticsAggregation().isPresent()) {
                return Rule.Result.empty();
            }
            Optional rewrittenStatisticsAggregation = RowExpressionRewriteRuleSet.this.translateStatisticAggregation(node.getStatisticsAggregation().get(), context);
            if (rewrittenStatisticsAggregation.isPresent()) {
                return Rule.Result.ofPlanNode(new TableWriterNode(node.getSourceLocation(), node.getId(), node.getStatsEquivalentPlanNode(), node.getSource(), node.getTarget(), node.getRowCountVariable(), node.getFragmentVariable(), node.getTableCommitContextVariable(), node.getColumns(), node.getColumnNames(), node.getNotNullColumnVariables(), node.getTablePartitioningScheme(), node.getPreferredShufflePartitioningScheme(), rewrittenStatisticsAggregation, node.getTaskCountIfScaledWriter(), node.getIsTemporaryTableWriter()));
            }
            return Rule.Result.empty();
        }
    }

    private final class TableFinishRowExpressionRewrite
    extends RowExpressionRewriteRule<TableFinishNode> {
        private TableFinishRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<TableFinishNode> getPattern() {
            return Patterns.tableFinish();
        }

        @Override
        public Rule.Result apply(TableFinishNode node, Captures captures, Rule.Context context) {
            Preconditions.checkState((node.getSource() != null ? 1 : 0) != 0);
            if (!node.getStatisticsAggregation().isPresent()) {
                return Rule.Result.empty();
            }
            Optional rewrittenStatisticsAggregation = RowExpressionRewriteRuleSet.this.translateStatisticAggregation(node.getStatisticsAggregation().get(), context);
            if (rewrittenStatisticsAggregation.isPresent()) {
                return Rule.Result.ofPlanNode(new TableFinishNode(node.getSourceLocation(), node.getId(), node.getSource(), node.getTarget(), node.getRowCountVariable(), rewrittenStatisticsAggregation, node.getStatisticsAggregationDescriptor()));
            }
            return Rule.Result.empty();
        }
    }

    private final class AggregationRowExpressionRewrite
    extends RowExpressionRewriteRule<AggregationNode> {
        private AggregationRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<AggregationNode> getPattern() {
            return Patterns.aggregation();
        }

        @Override
        public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
            Preconditions.checkState((node.getSource() != null ? 1 : 0) != 0);
            boolean changed = false;
            ImmutableMap.Builder rewrittenAggregation = ImmutableMap.builder();
            for (Map.Entry entry : node.getAggregations().entrySet()) {
                AggregationNode.Aggregation rewritten = RowExpressionRewriteRuleSet.this.rewriteAggregation((AggregationNode.Aggregation)entry.getValue(), context);
                rewrittenAggregation.put(entry.getKey(), (Object)rewritten);
                if (rewritten.equals(entry.getValue())) continue;
                changed = true;
            }
            if (changed) {
                AggregationNode aggregationNode = new AggregationNode(node.getSourceLocation(), node.getId(), node.getSource(), (Map)rewrittenAggregation.build(), node.getGroupingSets(), node.getPreGroupedVariables(), node.getStep(), node.getHashVariable(), node.getGroupIdVariable(), node.getAggregationId());
                return Rule.Result.ofPlanNode((PlanNode)aggregationNode);
            }
            return Rule.Result.empty();
        }
    }

    private final class ValuesRowExpressionRewrite
    extends RowExpressionRewriteRule<ValuesNode> {
        private ValuesRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<ValuesNode> getPattern() {
            return Patterns.values();
        }

        @Override
        public Rule.Result apply(ValuesNode valuesNode, Captures captures, Rule.Context context) {
            boolean anyRewritten = false;
            ImmutableList.Builder rows = ImmutableList.builder();
            for (List row : valuesNode.getRows()) {
                ImmutableList.Builder newRow = ImmutableList.builder();
                for (RowExpression rowExpression : row) {
                    RowExpression rewritten = RowExpressionRewriteRuleSet.this.rewriter.rewrite(rowExpression, context);
                    if (!rewritten.equals((Object)rowExpression)) {
                        anyRewritten = true;
                    }
                    newRow.add((Object)rewritten);
                }
                rows.add((Object)newRow.build());
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode((PlanNode)new ValuesNode(valuesNode.getSourceLocation(), valuesNode.getId(), valuesNode.getOutputVariables(), (List)rows.build(), valuesNode.getValuesNodeLabel()));
            }
            return Rule.Result.empty();
        }
    }

    private final class FilterRowExpressionRewrite
    extends RowExpressionRewriteRule<FilterNode> {
        private FilterRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return Patterns.filter();
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            Preconditions.checkState((filterNode.getSource() != null ? 1 : 0) != 0);
            RowExpression rewritten = RowExpressionRewriteRuleSet.this.rewriter.rewrite(filterNode.getPredicate(), context);
            if (filterNode.getPredicate().equals((Object)rewritten)) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode((PlanNode)new FilterNode(filterNode.getSourceLocation(), filterNode.getId(), filterNode.getSource(), rewritten));
        }
    }

    private final class ApplyRowExpressionRewrite
    extends RowExpressionRewriteRule<ApplyNode> {
        private ApplyRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<ApplyNode> getPattern() {
            return Patterns.applyNode();
        }

        @Override
        public Rule.Result apply(ApplyNode applyNode, Captures captures, Rule.Context context) {
            Assignments assignments = applyNode.getSubqueryAssignments();
            Optional rewrittenAssignments = RowExpressionRewriteRuleSet.this.translateAssignments(assignments, context);
            if (!rewrittenAssignments.isPresent()) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new ApplyNode(applyNode.getSourceLocation(), applyNode.getId(), applyNode.getInput(), applyNode.getSubquery(), (Assignments)rewrittenAssignments.get(), applyNode.getCorrelation(), applyNode.getOriginSubqueryError(), applyNode.getMayParticipateInAntiJoin()));
        }
    }

    private final class WindowRowExpressionRewrite
    extends RowExpressionRewriteRule<WindowNode> {
        private WindowRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<WindowNode> getPattern() {
            return Patterns.window();
        }

        @Override
        public Rule.Result apply(WindowNode windowNode, Captures captures, Rule.Context context) {
            Preconditions.checkState((windowNode.getSource() != null ? 1 : 0) != 0);
            boolean anyRewritten = false;
            ImmutableMap.Builder functions = ImmutableMap.builder();
            for (Map.Entry<VariableReferenceExpression, WindowNode.Function> entry : windowNode.getWindowFunctions().entrySet()) {
                ImmutableList.Builder newArguments = ImmutableList.builder();
                CallExpression callExpression = entry.getValue().getFunctionCall();
                for (RowExpression argument : callExpression.getArguments()) {
                    RowExpression rewritten = RowExpressionRewriteRuleSet.this.rewriter.rewrite(argument, context);
                    if (rewritten != argument) {
                        anyRewritten = true;
                    }
                    newArguments.add((Object)rewritten);
                }
                functions.put((Object)entry.getKey(), (Object)new WindowNode.Function(Expressions.call(callExpression.getDisplayName(), callExpression.getFunctionHandle(), callExpression.getType(), (List<RowExpression>)newArguments.build()), entry.getValue().getFrame(), entry.getValue().isIgnoreNulls()));
            }
            if (anyRewritten) {
                return Rule.Result.ofPlanNode(new WindowNode(windowNode.getSourceLocation(), windowNode.getId(), windowNode.getSource(), windowNode.getSpecification(), (Map<VariableReferenceExpression, WindowNode.Function>)functions.build(), windowNode.getHashVariable(), windowNode.getPrePartitionedInputs(), windowNode.getPreSortedOrderPrefix()));
            }
            return Rule.Result.empty();
        }
    }

    private final class JoinRowExpressionRewrite
    extends RowExpressionRewriteRule<JoinNode> {
        private JoinRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<JoinNode> getPattern() {
            return Patterns.join();
        }

        @Override
        public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
            RowExpression rewritten;
            if (!joinNode.getFilter().isPresent()) {
                return Rule.Result.empty();
            }
            RowExpression filter = joinNode.getFilter().get();
            if (filter.equals((Object)(rewritten = RowExpressionRewriteRuleSet.this.rewriter.rewrite(filter, context)))) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new JoinNode(joinNode.getSourceLocation(), joinNode.getId(), joinNode.getType(), joinNode.getLeft(), joinNode.getRight(), joinNode.getCriteria(), joinNode.getOutputVariables(), Optional.of(rewritten), joinNode.getLeftHashVariable(), joinNode.getRightHashVariable(), joinNode.getDistributionType(), joinNode.getDynamicFilters()));
        }
    }

    private final class SpatialJoinRowExpressionRewrite
    extends RowExpressionRewriteRule<SpatialJoinNode> {
        private SpatialJoinRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<SpatialJoinNode> getPattern() {
            return Patterns.spatialJoin();
        }

        @Override
        public Rule.Result apply(SpatialJoinNode spatialJoinNode, Captures captures, Rule.Context context) {
            RowExpression rewritten;
            RowExpression filter = spatialJoinNode.getFilter();
            if (filter.equals((Object)(rewritten = RowExpressionRewriteRuleSet.this.rewriter.rewrite(filter, context)))) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(new SpatialJoinNode(spatialJoinNode.getSourceLocation(), spatialJoinNode.getId(), spatialJoinNode.getType(), spatialJoinNode.getLeft(), spatialJoinNode.getRight(), spatialJoinNode.getOutputVariables(), rewritten, spatialJoinNode.getLeftPartitionVariable(), spatialJoinNode.getRightPartitionVariable(), spatialJoinNode.getKdbTree()));
        }
    }

    private final class ProjectRowExpressionRewrite
    extends RowExpressionRewriteRule<ProjectNode> {
        private ProjectRowExpressionRewrite() {
        }

        @Override
        public boolean isEnabled(Session session) {
            return RowExpressionRewriteRuleSet.this.isRewriterEnabled(session);
        }

        @Override
        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        @Override
        public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
            Assignments.Builder builder = Assignments.builder();
            boolean anyRewritten = false;
            for (Map.Entry entry : projectNode.getAssignments().getMap().entrySet()) {
                RowExpression rewritten = RowExpressionRewriteRuleSet.this.rewriter.rewrite((RowExpression)entry.getValue(), context);
                if (!rewritten.equals(entry.getValue())) {
                    anyRewritten = true;
                }
                builder.put((VariableReferenceExpression)entry.getKey(), rewritten);
            }
            Assignments assignments = builder.build();
            if (anyRewritten) {
                return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(projectNode.getSourceLocation(), projectNode.getId(), projectNode.getSource(), assignments, projectNode.getLocality()));
            }
            return Rule.Result.empty();
        }
    }

    public abstract class RowExpressionRewriteRule<T>
    implements Rule<T> {
        public String getOptimizerNameForLog() {
            String rewriterName = RowExpressionRewriteRuleSet.this.rewriter.getClass().getName();
            return String.format("%s:%s", rewriterName.substring(rewriterName.lastIndexOf(46) + 1), this.getClass().getSimpleName());
        }
    }

    public static interface PlanRowExpressionRewriter {
        public RowExpression rewrite(RowExpression var1, Rule.Context var2);
    }
}

