/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.CteConsumerNode;
import com.facebook.presto.spi.plan.CteProducerNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.RowExpressionVariableInliner;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyRowExpressions;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.SequenceNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.relational.Expressions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CteProjectionAndPredicatePushDown
implements PlanOptimizer {
    private final Metadata metadata;

    public CteProjectionAndPredicatePushDown(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(warningCollector, "warningCollector is null");
        if (!SystemSessionProperties.isCteMaterializationApplicable(session) || !SystemSessionProperties.getCteFilterAndProjectionPushdownEnabled(session)) {
            return PlanOptimizerResult.optimizerResult(plan, false);
        }
        CteContext cteContext = new CteContext();
        plan.accept((PlanVisitor)new CtePredicateAndProjectionExtractor(session, idAllocator, variableAllocator), (Object)cteContext);
        CteProducerRewriter cteProducerRewriter = new CteProducerRewriter(session, idAllocator, variableAllocator);
        PlanNode rewrittenPlan = SimplePlanRewriter.rewriteWith(cteProducerRewriter, plan, cteContext);
        return PlanOptimizerResult.optimizerResult(rewrittenPlan, cteProducerRewriter.isPlanRewritten());
    }

    private static Map<VariableReferenceExpression, VariableReferenceExpression> constructVarMap(List<VariableReferenceExpression> sourceColumns, List<VariableReferenceExpression> targetColumns) {
        HashMap<VariableReferenceExpression, VariableReferenceExpression> varMap = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
        Streams.zip(sourceColumns.stream(), targetColumns.stream(), AbstractMap.SimpleImmutableEntry::new).forEach(pair -> {
            VariableReferenceExpression cfr_ignored_0 = (VariableReferenceExpression)varMap.put((VariableReferenceExpression)pair.getKey(), (VariableReferenceExpression)pair.getValue());
        });
        return varMap;
    }

    private RowExpression remapExpression(RowExpression expression, Map<VariableReferenceExpression, VariableReferenceExpression> varMap) {
        return RowExpressionVariableInliner.inlineVariables(varMap, expression);
    }

    public static class CteContext {
        private Map<String, CteInfo> cteNameToTableInfo = new HashMap<String, CteInfo>();
        private Map<String, List<VariableReferenceExpression>> cteProducerOutputColumnsMap = new HashMap<String, List<VariableReferenceExpression>>();

        public void addCteProducerInfo(String cteName, List<VariableReferenceExpression> outputColumns) {
            Objects.requireNonNull(outputColumns, "CTE producer output columns cannot be null");
            Preconditions.checkState((!this.cteProducerOutputColumnsMap.containsKey(cteName) ? 1 : 0) != 0, (Object)"CTE producer columns already recorded.");
            this.cteProducerOutputColumnsMap.put(cteName, outputColumns);
        }

        public void addCteConsumerInfo(String cteName, List<VariableReferenceExpression> columns, List<RowExpression> predicates) {
            CteInfo cteInfo = this.cteNameToTableInfo.getOrDefault(cteName, new CteInfo(new HashSet(){}, new ArrayList<RowExpression>()));
            cteInfo.addColumns(columns);
            cteInfo.addPredicates(predicates);
            this.cteNameToTableInfo.put(cteName, cteInfo);
        }

        public List<VariableReferenceExpression> getCteProducerColumns(String cteName) {
            return this.cteProducerOutputColumnsMap.getOrDefault(cteName, null);
        }

        public List<VariableReferenceExpression> getCteRequiredColumns(String cteName) {
            if (this.cteNameToTableInfo.containsKey(cteName)) {
                return new ArrayList<VariableReferenceExpression>(this.cteNameToTableInfo.get(cteName).getColumns());
            }
            return null;
        }

        public List<RowExpression> getPredicates(String cteName) {
            if (this.cteNameToTableInfo.containsKey(cteName)) {
                return this.cteNameToTableInfo.get(cteName).getPredicates();
            }
            return null;
        }

        public static class CteInfo {
            private Set<VariableReferenceExpression> columns;
            private List<RowExpression> predicates;

            public CteInfo(Set<VariableReferenceExpression> columns, List<RowExpression> predicates) {
                this.columns = Objects.requireNonNull(columns, "columns must not be null");
                this.predicates = Objects.requireNonNull(predicates, "predicates must not be null");
            }

            public Set<VariableReferenceExpression> getColumns() {
                return this.columns;
            }

            public List<RowExpression> getPredicates() {
                return this.predicates;
            }

            public void addColumns(List<VariableReferenceExpression> columns) {
                this.columns.addAll(columns);
            }

            public void addPredicates(List<RowExpression> predicates) {
                this.predicates.addAll(predicates);
            }
        }
    }

    public class CteProducerRewriter
    extends SimplePlanRewriter<CteContext> {
        private final PlanNodeIdAllocator idAllocator;
        private final VariableAllocator variableAllocator;
        private final Session session;
        private boolean isPlanRewritten;

        public CteProducerRewriter(Session session, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator must not be null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator must not be null");
            this.session = Objects.requireNonNull(session, "session must not be null");
        }

        public PlanNode visitCteProducer(CteProducerNode node, SimplePlanRewriter.RewriteContext<CteContext> context) {
            String cteName = node.getCteId();
            List<VariableReferenceExpression> usedColumns = context.get().getCteRequiredColumns(cteName);
            List<RowExpression> predicates = context.get().getPredicates(cteName);
            PlanNode newChild = (PlanNode)node.getSource().accept((PlanVisitor)this, context);
            if (usedColumns == null || predicates == null) {
                PlanNode result = ChildReplacer.replaceChildren((PlanNode)node, (List<PlanNode>)ImmutableList.of((Object)newChild));
                this.isPlanRewritten = this.isPlanRewritten || !node.equals(result);
                return result;
            }
            HashSet<VariableReferenceExpression> usedColumnsSet = new HashSet<VariableReferenceExpression>(usedColumns);
            PlanNode newChildWithFilterAndProject = this.addFilter(newChild, predicates);
            List producerColumns = node.getOutputVariables();
            List<VariableReferenceExpression> newProducerColumns = producerColumns.stream().filter(var -> usedColumnsSet.contains(var)).collect(Collectors.toList());
            if (!newProducerColumns.equals(newChildWithFilterAndProject.getOutputVariables())) {
                newChildWithFilterAndProject = PlannerUtils.restrictOutput(newChildWithFilterAndProject, this.idAllocator, newProducerColumns);
            }
            if (newChildWithFilterAndProject != node.getSource()) {
                this.isPlanRewritten = true;
                return new CteProducerNode(node.getSourceLocation(), node.getId(), node.getStatsEquivalentPlanNode(), newChildWithFilterAndProject, cteName, node.getRowCountVariable(), newProducerColumns);
            }
            return node;
        }

        public PlanNode visitCteConsumer(CteConsumerNode node, SimplePlanRewriter.RewriteContext<CteContext> context) {
            List<VariableReferenceExpression> allProducerColumns = context.get().getCteProducerColumns(node.getCteId());
            List<VariableReferenceExpression> requiredProducerColumns = context.get().getCteRequiredColumns(node.getCteId());
            Preconditions.checkState((requiredProducerColumns != null ? 1 : 0) != 0, (Object)("Required columns for producer " + node.getCteId() + " not found"));
            HashSet<VariableReferenceExpression> requiredProducerColumnsSet = new HashSet<VariableReferenceExpression>(requiredProducerColumns);
            ArrayList newConsumerColumns = new ArrayList();
            Streams.zip(allProducerColumns.stream(), node.getOutputVariables().stream(), AbstractMap.SimpleImmutableEntry::new).forEach(pair -> {
                if (requiredProducerColumnsSet.contains(pair.getKey())) {
                    newConsumerColumns.add(pair.getValue());
                }
            });
            return new CteConsumerNode(node.getSourceLocation(), node.getId(), node.getStatsEquivalentPlanNode(), newConsumerColumns, node.getCteId(), node.getOriginalSource());
        }

        public boolean isPlanRewritten() {
            return this.isPlanRewritten;
        }

        private PlanNode addFilter(PlanNode node, List<RowExpression> predicates) {
            RowExpression resultPredicate;
            if (this.isConstTrue(predicates)) {
                return node;
            }
            if (predicates.size() == 1) {
                resultPredicate = predicates.get(0);
            } else {
                resultPredicate = predicates.get(0);
                for (int i = 1; i < predicates.size(); ++i) {
                    resultPredicate = new SpecialFormExpression(SpecialFormExpression.Form.OR, (Type)BooleanType.BOOLEAN, new RowExpression[]{resultPredicate, predicates.get(i)});
                }
            }
            resultPredicate = SimplifyRowExpressions.rewrite(resultPredicate, CteProjectionAndPredicatePushDown.this.metadata, this.session.toConnectorSession());
            return new FilterNode(node.getSourceLocation(), this.idAllocator.getNextId(), node, resultPredicate);
        }

        private boolean isConstTrue(List<RowExpression> predicates) {
            return predicates.size() == 0 || predicates.stream().anyMatch(predicate -> PlannerUtils.isConstant(predicate, (Type)BooleanType.BOOLEAN, true));
        }
    }

    public class CtePredicateAndProjectionExtractor
    extends SimplePlanVisitor<CteContext> {
        private final PlanNodeIdAllocator idAllocator;
        private final VariableAllocator variableAllocator;
        private final Session session;

        public CtePredicateAndProjectionExtractor(Session session, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator must not be null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator must not be null");
            this.session = Objects.requireNonNull(session, "session must not be null");
        }

        public Void visitCteProducer(CteProducerNode node, CteContext context) {
            String cteName = node.getCteId();
            List columns = node.getOutputVariables();
            context.addCteProducerInfo(cteName, columns);
            return (Void)super.visitCteProducer(node, (Object)context);
        }

        public Void visitFilter(FilterNode node, CteContext context) {
            PlanNode childNode = node.getSource();
            if (!(childNode instanceof CteConsumerNode)) {
                return (Void)super.visitFilter(node, (Object)context);
            }
            String cteName = ((CteConsumerNode)childNode).getCteId();
            List<VariableReferenceExpression> producerColumns = context.getCteProducerColumns(cteName);
            RowExpression predicate = node.getPredicate();
            Map<VariableReferenceExpression, VariableReferenceExpression> varMap = this.constructConsumerToProducerVarMap((CteConsumerNode)childNode, context);
            RowExpression newPredicate = CteProjectionAndPredicatePushDown.this.remapExpression(predicate, varMap);
            context.addCteConsumerInfo(cteName, producerColumns, (List<RowExpression>)ImmutableList.of((Object)newPredicate));
            return null;
        }

        public Void visitProject(ProjectNode node, CteContext context) {
            ConstantExpression predicate;
            if (!this.isCteConsumerFilterRestrict((PlanNode)node)) {
                return (Void)super.visitProject(node, (Object)context);
            }
            CteConsumerNode cteConsumerNode = this.extractCteConsumer((PlanNode)node);
            Map<VariableReferenceExpression, VariableReferenceExpression> varMap = this.constructConsumerToProducerVarMap(cteConsumerNode, context);
            List<VariableReferenceExpression> usedColumns = node.getAssignments().getExpressions().stream().map(expression -> (VariableReferenceExpression)CteProjectionAndPredicatePushDown.this.remapExpression(expression, varMap)).collect(Collectors.toList());
            FilterNode filterNode = this.extractFilterNode((PlanNode)node);
            if (filterNode != null) {
                predicate = CteProjectionAndPredicatePushDown.this.remapExpression(filterNode.getPredicate(), varMap);
                usedColumns.addAll(VariablesExtractor.extractAll((RowExpression)predicate));
            } else {
                predicate = Expressions.constant(true, (Type)BooleanType.BOOLEAN);
            }
            context.addCteConsumerInfo(cteConsumerNode.getCteId(), usedColumns, (List<RowExpression>)ImmutableList.of((Object)predicate));
            return null;
        }

        public Void visitCteConsumer(CteConsumerNode node, CteContext context) {
            String cteName = node.getCteId();
            List<VariableReferenceExpression> producerColumns = context.getCteProducerColumns(cteName);
            Preconditions.checkState((producerColumns != null ? 1 : 0) != 0, (Object)("No producer with name " + cteName + " found"));
            ConstantExpression predicate = Expressions.constant(true, (Type)BooleanType.BOOLEAN);
            context.addCteConsumerInfo(cteName, producerColumns, (List<RowExpression>)ImmutableList.of((Object)predicate));
            return null;
        }

        @Override
        public Void visitSequence(SequenceNode node, CteContext context) {
            List<PlanNode> cteProducers = node.getCteProducers();
            for (int i = cteProducers.size() - 1; i >= 0; --i) {
                PlanNode cteProducer = cteProducers.get(i);
                cteProducer.accept((PlanVisitor)this, (Object)context);
            }
            PlanNode primarySource = node.getPrimarySource();
            primarySource.accept((PlanVisitor)this, (Object)context);
            return null;
        }

        private boolean isCteConsumerFilterRestrict(PlanNode node) {
            if (!(node instanceof ProjectNode)) {
                return false;
            }
            ProjectNode projectNode = (ProjectNode)node;
            PlanNode childNode = projectNode.getSource();
            if (this.isCteConsumerFilter(childNode) || childNode instanceof CteConsumerNode) {
                return projectNode.getAssignments().getExpressions().stream().allMatch(expression -> expression instanceof VariableReferenceExpression);
            }
            return false;
        }

        private boolean isCteConsumerFilter(PlanNode node) {
            return node instanceof FilterNode && ((FilterNode)node).getSource() instanceof CteConsumerNode;
        }

        private CteConsumerNode extractCteConsumer(PlanNode node) {
            Preconditions.checkState((boolean)this.isCteConsumerFilterRestrict(node));
            PlanNode childNode = ((ProjectNode)node).getSource();
            if (childNode instanceof CteConsumerNode) {
                return (CteConsumerNode)childNode;
            }
            return (CteConsumerNode)((FilterNode)childNode).getSource();
        }

        private FilterNode extractFilterNode(PlanNode node) {
            Preconditions.checkState((boolean)this.isCteConsumerFilterRestrict(node));
            PlanNode childNode = ((ProjectNode)node).getSource();
            if (childNode instanceof FilterNode) {
                return (FilterNode)childNode;
            }
            return null;
        }

        private Map<VariableReferenceExpression, VariableReferenceExpression> constructConsumerToProducerVarMap(CteConsumerNode cteConsumerNode, CteContext context) {
            List consumerColumns = cteConsumerNode.getOutputVariables();
            List<VariableReferenceExpression> producerColumns = context.getCteProducerColumns(cteConsumerNode.getCteId());
            Map varMap = CteProjectionAndPredicatePushDown.constructVarMap(consumerColumns, producerColumns);
            return varMap;
        }
    }
}

