/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.metadata.IndexHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class IndexSourceNode
extends InternalPlanNode {
    private final IndexHandle indexHandle;
    private final TableHandle tableHandle;
    private final Set<VariableReferenceExpression> lookupVariables;
    private final List<VariableReferenceExpression> outputVariables;
    private final Map<VariableReferenceExpression, ColumnHandle> assignments;
    private final TupleDomain<ColumnHandle> currentConstraint;

    @JsonCreator
    public IndexSourceNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="indexHandle") IndexHandle indexHandle, @JsonProperty(value="tableHandle") TableHandle tableHandle, @JsonProperty(value="lookupVariables") Set<VariableReferenceExpression> lookupVariables, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="assignments") Map<VariableReferenceExpression, ColumnHandle> assignments, @JsonProperty(value="currentConstraint") TupleDomain<ColumnHandle> currentConstraint) {
        this(sourceLocation, id, Optional.empty(), indexHandle, tableHandle, lookupVariables, outputVariables, assignments, currentConstraint);
    }

    public IndexSourceNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, IndexHandle indexHandle, TableHandle tableHandle, Set<VariableReferenceExpression> lookupVariables, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, ColumnHandle> assignments, TupleDomain<ColumnHandle> currentConstraint) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.indexHandle = Objects.requireNonNull(indexHandle, "indexHandle is null");
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.lookupVariables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(lookupVariables, "lookupVariables is null"));
        this.outputVariables = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputVariables, "outputVariables is null"));
        this.assignments = ImmutableMap.copyOf(Objects.requireNonNull(assignments, "assignments is null"));
        this.currentConstraint = Objects.requireNonNull(currentConstraint, "effectiveTupleDomain is null");
        Preconditions.checkArgument((!lookupVariables.isEmpty() ? 1 : 0) != 0, (Object)"lookupVariables is empty");
        Preconditions.checkArgument((!outputVariables.isEmpty() ? 1 : 0) != 0, (Object)"outputVariables is empty");
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(lookupVariables), (Object)"Assignments do not include all lookup variables");
        Preconditions.checkArgument((boolean)outputVariables.containsAll(lookupVariables), (Object)"Lookup variables need to be part of the output variables");
    }

    @JsonProperty
    public IndexHandle getIndexHandle() {
        return this.indexHandle;
    }

    @JsonProperty
    public TableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public Set<VariableReferenceExpression> getLookupVariables() {
        return this.lookupVariables;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getCurrentConstraint() {
        return this.currentConstraint;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitIndexSource(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }

    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new IndexSourceNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.indexHandle, this.tableHandle, this.lookupVariables, this.outputVariables, this.assignments, this.currentConstraint);
    }
}

