/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import java.util.Objects;
import java.util.function.Function;

public final class RowExpressionOptimizer
implements ExpressionOptimizer {
    private final Metadata metadata;

    public RowExpressionOptimizer(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public RowExpression optimize(RowExpression rowExpression, ExpressionOptimizer.Level level, ConnectorSession session) {
        if (level.ordinal() <= ExpressionOptimizer.Level.OPTIMIZED.ordinal()) {
            return LiteralEncoder.toRowExpression(rowExpression.getSourceLocation(), new RowExpressionInterpreter(rowExpression, this.metadata.getFunctionAndTypeManager(), session, level).optimize(), rowExpression.getType());
        }
        throw new IllegalArgumentException("Not supported optimization level: " + level);
    }

    public Object optimize(RowExpression expression, ExpressionOptimizer.Level level, ConnectorSession session, Function<VariableReferenceExpression, Object> variableResolver) {
        RowExpressionInterpreter interpreter = new RowExpressionInterpreter(expression, this.metadata.getFunctionAndTypeManager(), session, level);
        return interpreter.optimize(variableResolver::apply);
    }
}

