/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.AbstractLongType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.DateTimeZoneIndex;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

public final class TimestampOperators {
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final int MILLISECONDS_PER_DAY = 86400000;

    private TimestampOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="timestamp") long left, @SqlType(value="timestamp") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="timestamp") long value, @SqlType(value="timestamp") long min, @SqlType(value="timestamp") long max) {
        return min <= value && value <= max;
    }

    @ScalarFunction(value="date")
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="date")
    public static long castToDate(SqlFunctionProperties properties, @SqlType(value="timestamp") long value) {
        if (properties.isLegacyTimestamp()) {
            ISOChronology chronology = DateTimeZoneIndex.getChronology(properties.getTimeZoneKey());
            long date = chronology.dayOfYear().roundFloor(value);
            long millis = date + (long)chronology.getZone().getOffset(date);
            return TimeUnit.MILLISECONDS.toDays(millis);
        }
        return Math.floorDiv(value, 86400000L);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time")
    public static long castToTime(SqlFunctionProperties properties, @SqlType(value="timestamp") long value) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()), value);
        }
        return DateTimeOperators.modulo24Hour(value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time with time zone")
    public static long castToTimeWithTimeZone(SqlFunctionProperties properties, @SqlType(value="timestamp") long value) {
        if (properties.isLegacyTimestamp()) {
            int timeMillis = DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(properties.getTimeZoneKey()), value);
            return DateTimeEncoding.packDateTimeWithZone((long)timeMillis, (TimeZoneKey)properties.getTimeZoneKey());
        }
        ISOChronology localChronology = DateTimeZoneIndex.getChronology(properties.getTimeZoneKey());
        return DateTimeEncoding.packDateTimeWithZone((long)localChronology.getZone().convertLocalToUTC(DateTimeOperators.modulo24Hour(value), false), (TimeZoneKey)properties.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp with time zone")
    public static long castToTimestampWithTimeZone(SqlFunctionProperties properties, @SqlType(value="timestamp") long value) {
        if (properties.isLegacyTimestamp()) {
            return DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)properties.getTimeZoneKey());
        }
        ISOChronology localChronology = DateTimeZoneIndex.getChronology(properties.getTimeZoneKey());
        return DateTimeEncoding.packDateTimeWithZone((long)localChronology.getZone().convertLocalToUTC(value, false), (TimeZoneKey)properties.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(SqlFunctionProperties properties, @SqlType(value="timestamp") long value) {
        if (properties.isLegacyTimestamp()) {
            return Slices.utf8Slice((String)DateTimeUtils.printTimestampWithoutTimeZone(properties.getTimeZoneKey(), value));
        }
        return Slices.utf8Slice((String)DateTimeUtils.printTimestampWithoutTimeZone(value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="timestamp")
    public static long castFromSlice(SqlFunctionProperties properties, @SqlType(value="varchar(x)") Slice value) {
        if (properties.isLegacyTimestamp()) {
            try {
                return DateTimeUtils.parseTimestampWithoutTimeZone(properties.getTimeZoneKey(), SliceUtf8.trim((Slice)value).toStringUtf8());
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
            }
        }
        try {
            return DateTimeUtils.parseTimestampWithoutTimeZone(SliceUtf8.trim((Slice)value).toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="timestamp") long value) {
        return AbstractLongType.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="timestamp") long value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="timestamp") long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class TimestampDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="timestamp") long left, @IsNull boolean leftNull, @SqlType(value="timestamp") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return TimestampOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="timestamp", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="timestamp", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return TimestampOperators.notEqual(TimestampType.TIMESTAMP.getLong(left, leftPosition), TimestampType.TIMESTAMP.getLong(right, rightPosition));
        }
    }
}

