/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.airlift.log.Logger;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;

public final class HeapDumper {
    private static final Logger log = Logger.get(HeapDumper.class);
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final AtomicBoolean IS_HEAPDUMP_TRIGGERED = new AtomicBoolean(false);
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;

    private HeapDumper() {
    }

    public static void dumpHeap(String fileName) {
        if (IS_HEAPDUMP_TRIGGERED.compareAndSet(false, true)) {
            log.info("Performing heapdump to file: " + fileName);
            try {
                if (hotspotMBean == null) {
                    hotspotMBean = HeapDumper.getHotspotMBean();
                }
                hotspotMBean.dumpHeap(fileName, false);
            }
            catch (Throwable throwable) {
                log.error(throwable, "Unable to perform heap dump");
            }
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
    }
}

