/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import io.airlift.slice.XxHash64;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class QueryInfoUtils {
    private QueryInfoUtils() {
    }

    public static String computeQueryHash(String query) {
        Objects.requireNonNull(query, "query is null");
        if (query.isEmpty()) {
            return "";
        }
        byte[] queryBytes = query.getBytes(StandardCharsets.UTF_8);
        long queryHash = new XxHash64().update(queryBytes).hash();
        return Long.toHexString(queryHash);
    }
}

