/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.ColumnarTestUtils;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.RowBlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.VarcharType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColumnarRow {
    private static final int POSITION_COUNT = 5;
    private static final int FIELD_COUNT = 5;

    @Test
    public void test() {
        Slice[][] expectedValues = new Slice[5][];
        for (int i = 0; i < 5; ++i) {
            expectedValues[i] = new Slice[5];
            for (int j = 0; j < 5; ++j) {
                if (j % 3 == 1) continue;
                expectedValues[i][j] = Slices.utf8Slice((String)String.format("%d.%d", i, j));
            }
        }
        BlockBuilder blockBuilder = TestColumnarRow.createBlockBuilderWithValues(expectedValues);
        TestColumnarRow.verifyBlock((Block)blockBuilder, expectedValues);
        TestColumnarRow.verifyBlock(blockBuilder.build(), expectedValues);
        Slice[][] expectedValuesWithNull = (Slice[][])ColumnarTestUtils.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = TestColumnarRow.createBlockBuilderWithValues(expectedValuesWithNull);
        TestColumnarRow.verifyBlock((Block)blockBuilderWithNull, expectedValuesWithNull);
        TestColumnarRow.verifyBlock(blockBuilderWithNull.build(), expectedValuesWithNull);
    }

    private static <T> void verifyBlock(Block block, T[] expectedValues) {
        ColumnarTestUtils.assertBlock(block, expectedValues);
        TestColumnarRow.assertColumnarRow(block, expectedValues);
        TestColumnarRow.assertDictionaryBlock(block, expectedValues);
        TestColumnarRow.assertRunLengthEncodedBlock(block, expectedValues);
        int offset = 1;
        int length = expectedValues.length - 2;
        Block blockRegion = block.getRegion(offset, length);
        T[] expectedValuesRegion = Arrays.copyOfRange(expectedValues, offset, offset + length);
        ColumnarTestUtils.assertBlock(blockRegion, expectedValuesRegion);
        TestColumnarRow.assertColumnarRow(blockRegion, expectedValuesRegion);
        TestColumnarRow.assertDictionaryBlock(blockRegion, expectedValuesRegion);
        TestColumnarRow.assertRunLengthEncodedBlock(blockRegion, expectedValuesRegion);
    }

    private static <T> void assertDictionaryBlock(Block block, T[] expectedValues) {
        DictionaryBlock dictionaryBlock = ColumnarTestUtils.createTestDictionaryBlock(block);
        T[] expectedDictionaryValues = ColumnarTestUtils.createTestDictionaryExpectedValues(expectedValues);
        ColumnarTestUtils.assertBlock((Block)dictionaryBlock, expectedDictionaryValues);
        TestColumnarRow.assertColumnarRow((Block)dictionaryBlock, expectedDictionaryValues);
        TestColumnarRow.assertRunLengthEncodedBlock((Block)dictionaryBlock, expectedDictionaryValues);
    }

    private static <T> void assertRunLengthEncodedBlock(Block block, T[] expectedValues) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            RunLengthEncodedBlock runLengthEncodedBlock = ColumnarTestUtils.createTestRleBlock(block, position);
            T[] expectedDictionaryValues = ColumnarTestUtils.createTestRleExpectedValues(expectedValues, position);
            ColumnarTestUtils.assertBlock((Block)runLengthEncodedBlock, expectedDictionaryValues);
            TestColumnarRow.assertColumnarRow((Block)runLengthEncodedBlock, expectedDictionaryValues);
        }
    }

    private static <T> void assertColumnarRow(Block block, T[] expectedValues) {
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)block);
        Assert.assertEquals((int)columnarRow.getPositionCount(), (int)expectedValues.length);
        for (int fieldId = 0; fieldId < 5; ++fieldId) {
            Block fieldBlock = columnarRow.getField(fieldId);
            int elementsPosition = 0;
            for (int position = 0; position < expectedValues.length; ++position) {
                T expectedRow = expectedValues[position];
                Assert.assertEquals((boolean)columnarRow.isNull(position), (expectedRow == null ? 1 : 0) != 0);
                if (expectedRow == null) continue;
                Object expectedElement = Array.get(expectedRow, fieldId);
                ColumnarTestUtils.assertBlockPosition(fieldBlock, elementsPosition, expectedElement);
                ++elementsPosition;
            }
        }
    }

    public static BlockBuilder createBlockBuilderWithValues(Slice[][] expectedValues) {
        BlockBuilder blockBuilder = TestColumnarRow.createBlockBuilder(null, 100, 100);
        for (Slice[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
            for (Slice v : expectedValue) {
                if (v == null) {
                    entryBuilder.appendNull();
                    continue;
                }
                VarcharType.VARCHAR.writeSlice(entryBuilder, v);
            }
            blockBuilder.closeEntry();
        }
        return blockBuilder;
    }

    private static BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new RowBlockBuilder(Collections.nCopies(5, VarcharType.VARCHAR), blockBuilderStatus, expectedEntries);
    }
}

