/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.AbstractTestBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.ShortArrayBlock;
import com.facebook.presto.common.block.ShortArrayBlockBuilder;
import io.airlift.slice.Slice;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestShortArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Slice[] expectedValues = TestShortArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestShortArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = TestShortArrayBlock.alternatingNullValues(TestShortArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestShortArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestShortArrayBlock.createTestValue(100);
        ShortArrayBlockBuilder emptyBlockBuilder = new ShortArrayBlockBuilder(null, 0);
        ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(null, expectedValues.length);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
        TestShortArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assert.assertTrue((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0);
        Assert.assertTrue((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0);
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestShortArrayBlock.createTestValue(100);
        TestShortArrayBlock.assertEstimatedDataSizeForStats(TestShortArrayBlock.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        short[] shortArray = new short[]{0, 0, 1, 2, 3, 4};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestShortArrayBlock.testCompactBlock((Block)new ShortArrayBlock(0, Optional.empty(), new short[0]));
        TestShortArrayBlock.testCompactBlock((Block)new ShortArrayBlock(shortArray.length, Optional.of(valueIsNull), shortArray));
        TestShortArrayBlock.testIncompactBlock((Block)new ShortArrayBlock(shortArray.length - 1, Optional.of(valueIsNull), shortArray));
    }

    private void assertFixedWithValues(Slice[] expectedValues) {
        BlockBuilder blockBuilder = TestShortArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        ShortArrayBlockBuilder blockBuilder = new ShortArrayBlockBuilder(null, expectedValues.length);
        TestShortArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Slice[] expectedValues, BlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeShort((int)expectedValue.getShort(0)).closeEntry();
        }
    }

    private static Slice[] createTestValue(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestShortArrayBlock.createExpectedValue(2);
        }
        return expectedValues;
    }

    @Override
    protected boolean isByteAccessSupported() {
        return false;
    }

    @Override
    protected boolean isIntAccessSupported() {
        return false;
    }

    @Override
    protected boolean isLongAccessSupported() {
        return false;
    }

    @Override
    protected boolean isSliceAccessSupported() {
        return false;
    }
}

