/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class StatsCalculatorAssertion {
    private final StatsCalculator statsCalculator;
    private final Session session;
    private final PlanNode planNode;
    private final TypeProvider types;
    private Map<PlanNode, PlanNodeStatsEstimate> sourcesStats;

    public StatsCalculatorAssertion(StatsCalculator statsCalculator, Session session, PlanNode planNode, TypeProvider types) {
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator can not be null");
        this.session = Objects.requireNonNull(session, "session can not be null");
        this.planNode = Objects.requireNonNull(planNode, "planNode is null");
        this.types = Objects.requireNonNull(types, "types is null");
        this.sourcesStats = new HashMap<PlanNode, PlanNodeStatsEstimate>();
        planNode.getSources().forEach(child -> this.sourcesStats.put((PlanNode)child, PlanNodeStatsEstimate.unknown()));
    }

    public StatsCalculatorAssertion withSourceStats(PlanNodeStatsEstimate sourceStats) {
        Preconditions.checkState((this.planNode.getSources().size() == 1 ? 1 : 0) != 0, (Object)"expected single source");
        return this.withSourceStats(0, sourceStats);
    }

    public StatsCalculatorAssertion withSourceStats(int sourceIndex, PlanNodeStatsEstimate sourceStats) {
        Preconditions.checkArgument((sourceIndex < this.planNode.getSources().size() ? 1 : 0) != 0, (String)"invalid sourceIndex %s; planNode has %s sources", (int)sourceIndex, (int)this.planNode.getSources().size());
        this.sourcesStats.put((PlanNode)this.planNode.getSources().get(sourceIndex), sourceStats);
        return this;
    }

    public StatsCalculatorAssertion withSourceStats(PlanNodeId planNodeId, PlanNodeStatsEstimate sourceStats) {
        PlanNode sourceNode = PlanNodeSearcher.searchFrom((PlanNode)this.planNode).where(node -> node.getId().equals((Object)planNodeId)).findOnlyElement();
        this.sourcesStats.put(sourceNode, sourceStats);
        return this;
    }

    public StatsCalculatorAssertion withSourceStats(Map<PlanNode, PlanNodeStatsEstimate> stats) {
        this.sourcesStats.putAll(stats);
        return this;
    }

    public StatsCalculatorAssertion check(Consumer<PlanNodeStatsAssertion> statisticsAssertionConsumer) {
        PlanNodeStatsEstimate statsEstimate = this.statsCalculator.calculateStats(this.planNode, this::getSourceStats, Lookup.noLookup(), this.session, this.types);
        statisticsAssertionConsumer.accept(PlanNodeStatsAssertion.assertThat(statsEstimate));
        return this;
    }

    public StatsCalculatorAssertion check(ComposableStatsCalculator.Rule<?> rule, Consumer<PlanNodeStatsAssertion> statisticsAssertionConsumer) {
        Optional<PlanNodeStatsEstimate> statsEstimate = StatsCalculatorAssertion.calculatedStats(rule, this.planNode, this::getSourceStats, Lookup.noLookup(), this.session, this.types);
        Preconditions.checkState((boolean)statsEstimate.isPresent(), (Object)"Expected stats estimates to be present");
        statisticsAssertionConsumer.accept(PlanNodeStatsAssertion.assertThat(statsEstimate.get()));
        return this;
    }

    private static <T extends PlanNode> Optional<PlanNodeStatsEstimate> calculatedStats(ComposableStatsCalculator.Rule<T> rule, PlanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        return rule.calculate(node, sourceStats, lookup, session, types);
    }

    private PlanNodeStatsEstimate getSourceStats(PlanNode sourceNode) {
        Preconditions.checkArgument((boolean)this.sourcesStats.containsKey(sourceNode), (String)"stats not found for source %s", (Object)sourceNode);
        return this.sourcesStats.get(sourceNode);
    }
}

