/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.DisjointRangeDomainHistogram;
import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.cost.TestHistogram;
import com.facebook.presto.cost.UniformDistributionHistogram;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.Estimate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDisjointRangeDomainHistogram
extends TestHistogram {
    @Test
    public void testBasicDisjointRanges() {
        UniformDistributionHistogram source = new UniformDistributionHistogram(0.0, 100.0);
        ConnectorHistogram constrained = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (StatisticRange)StatisticRange.fromRange((Range)Range.open((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(25.0))));
        constrained = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)constrained, (StatisticRange)StatisticRange.fromRange((Range)Range.open((Comparable)Double.valueOf(75.0), (Comparable)Double.valueOf(100.0))));
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)87.5);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)0.0);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)100.0);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)25.0);
    }

    @Test
    public void testSingleDisjointRange() {
        int i;
        UniformDistributionHistogram source = new UniformDistributionHistogram(0.0, 10.0);
        ConnectorHistogram constrained = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (StatisticRange)StatisticRange.fromRange((Range)Range.open((Comparable)Double.valueOf(-10.0), (Comparable)Double.valueOf(-5.0))));
        for (i = -11; i < 12; ++i) {
            Assert.assertEquals((double)constrained.cumulativeProbability((double)i, true).getValue(), (double)0.0, (double)1.0E-8);
            Assert.assertEquals((double)constrained.cumulativeProbability((double)i, false).getValue(), (double)0.0, (double)1.0E-8);
        }
        Assert.assertEquals((Object)constrained.inverseCumulativeProbability(0.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)constrained.inverseCumulativeProbability(1.0), (Object)Estimate.unknown());
        constrained = new DisjointRangeDomainHistogram((ConnectorHistogram)source, (Set)ImmutableSet.of((Object)Range.open((Comparable)Double.valueOf(-2.0), (Comparable)Double.valueOf(2.0))));
        Assert.assertEquals((double)constrained.cumulativeProbability(-3.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(-1.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.0, false).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.5, false).getValue(), (double)0.75, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(2.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(4.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)1.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)2.0, (double)1.0E-8);
        constrained = new DisjointRangeDomainHistogram((ConnectorHistogram)source, (Set)ImmutableSet.of((Object)Range.open((Comparable)Double.valueOf(3.0), (Comparable)Double.valueOf(4.0))));
        Assert.assertEquals((double)constrained.cumulativeProbability(-3.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(3.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(3.5, false).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(4.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(4.5, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)3.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)3.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)3.75, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)4.0, (double)1.0E-8);
        constrained = new DisjointRangeDomainHistogram((ConnectorHistogram)source, (Set)ImmutableSet.of((Object)Range.open((Comparable)Double.valueOf(8.0), (Comparable)Double.valueOf(12.0))));
        Assert.assertEquals((double)constrained.cumulativeProbability(-3.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(5.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(8.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(9.0, false).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(9.5, false).getValue(), (double)0.75, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(10.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(11.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(12.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(13.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)8.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)9.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)9.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)10.0, (double)1.0E-8);
        constrained = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (StatisticRange)StatisticRange.fromRange((Range)Range.open((Comparable)Double.valueOf(15.0), (Comparable)Double.valueOf(20.0))));
        for (i = 15; i < 20; ++i) {
            Assert.assertEquals((double)constrained.cumulativeProbability((double)i, true).getValue(), (double)0.0, (double)1.0E-8);
            Assert.assertEquals((double)constrained.cumulativeProbability((double)i, false).getValue(), (double)0.0, (double)1.0E-8);
        }
        Assert.assertEquals((Object)constrained.inverseCumulativeProbability(0.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)constrained.inverseCumulativeProbability(1.0), (Object)Estimate.unknown());
    }

    @Test
    public void testMultipleDisjunction() {
        StandardNormalHistogram source = new StandardNormalHistogram();
        NormalDistribution dist = source.getDistribution();
        DisjointRangeDomainHistogram constrained = TestDisjointRangeDomainHistogram.disjunction(source, (Range<Double>)Range.closed((Comparable)Double.valueOf(-2.0), (Comparable)Double.valueOf(-1.0)));
        constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)constrained, (Range<Double>)Range.closed((Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(2.0)));
        double rangeLeftProb = dist.cumulativeProbability(-1.0) - dist.cumulativeProbability(-2.0);
        double rangeRightProb = dist.cumulativeProbability(2.0) - dist.cumulativeProbability(1.0);
        double sumRangeProb = rangeLeftProb + rangeRightProb;
        Assert.assertEquals((double)constrained.cumulativeProbability(-2.0, true).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(-1.5, true).getValue(), (double)((dist.cumulativeProbability(-1.5) - dist.cumulativeProbability(-2.0)) / sumRangeProb), (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(-1.0, true).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.0, true).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.5, true).getValue(), (double)(rangeLeftProb / sumRangeProb + (dist.cumulativeProbability(1.5) - dist.cumulativeProbability(1.0)) / sumRangeProb));
        Assert.assertEquals((double)constrained.cumulativeProbability(2.0, true).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(3.0, true).getValue(), (double)1.0, (double)1.0E-8);
    }

    @Test
    public void testNormalDistribution() {
        StandardNormalHistogram source = new StandardNormalHistogram();
        NormalDistribution dist = source.getDistribution();
        DisjointRangeDomainHistogram constrained = new DisjointRangeDomainHistogram((ConnectorHistogram)source, (Set)ImmutableSet.of((Object)Range.open((Comparable)Double.valueOf(-1.0), (Comparable)Double.valueOf(1.0))));
        Assert.assertEquals((double)constrained.cumulativeProbability(-1.0, true).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.0, true).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.0, true).getValue(), (double)1.0, (double)1.0E-8);
        double probability = (dist.cumulativeProbability(-0.5) - dist.cumulativeProbability(-1.0)) / (dist.cumulativeProbability(1.0) - dist.cumulativeProbability(-1.0));
        Assert.assertEquals((double)constrained.cumulativeProbability(-0.5, true).getValue(), (double)probability, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.5, true).getValue(), (double)(probability + (1.0 - 2.0 * probability)), (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)-1.0, (double)1.0E-8);
        probability = dist.inverseCumulativeProbability(dist.cumulativeProbability(-1.0) + 0.25 * (dist.cumulativeProbability(1.0) - dist.cumulativeProbability(-1.0)));
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.25).getValue(), (double)-0.44177054668, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)(-1.0 * probability), (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)1.0, (double)1.0E-8);
    }

    @Test
    public void testAddDisjunction() {
        UniformDistributionHistogram source = new UniformDistributionHistogram(0.0, 100.0);
        DisjointRangeDomainHistogram constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)source, (Range<Double>)Range.open((Comparable)Double.valueOf(-1.0), (Comparable)Double.valueOf(2.0)));
        Assert.assertEquals((int)constrained.getRanges().size(), (int)1);
        Assert.assertEquals(TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.0)));
        constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)constrained, (Range<Double>)Range.open((Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(10.0)));
        Assert.assertEquals((int)TestDisjointRangeDomainHistogram.ranges(constrained).size(), (int)1);
        Assert.assertEquals(TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(10.0)));
        constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)constrained, (Range<Double>)Range.closedOpen((Comparable)Double.valueOf(50.0), (Comparable)Double.valueOf(100.0)));
        Assert.assertEquals((int)TestDisjointRangeDomainHistogram.ranges(constrained).size(), (int)2);
        Assert.assertEquals(TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.closedOpen((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(10.0)));
        Assert.assertEquals(TestDisjointRangeDomainHistogram.ranges(constrained).get(1), (Object)Range.closedOpen((Comparable)Double.valueOf(50.0), (Comparable)Double.valueOf(100.0)));
    }

    @Test
    public void testAddConjunction() {
        UniformDistributionHistogram source = new UniformDistributionHistogram(0.0, 100.0);
        DisjointRangeDomainHistogram constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)source, (Range<Double>)Range.open((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(90.0)));
        Assert.assertEquals((int)constrained.getRanges().size(), (int)1);
        Assert.assertEquals(TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.open((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(90.0)));
        constrained = TestDisjointRangeDomainHistogram.conjunction((ConnectorHistogram)constrained, (Range<Double>)Range.atMost((Comparable)Double.valueOf(50.0)));
        Assert.assertEquals((int)TestDisjointRangeDomainHistogram.ranges(constrained).size(), (int)1);
        Assert.assertEquals(TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.openClosed((Comparable)Double.valueOf(10.0), (Comparable)Double.valueOf(50.0)));
        constrained = TestDisjointRangeDomainHistogram.conjunction((ConnectorHistogram)constrained, (Range<Double>)Range.atLeast((Comparable)Double.valueOf(25.0)));
        Assert.assertEquals((int)TestDisjointRangeDomainHistogram.ranges(constrained).size(), (int)1);
        Assert.assertEquals(TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.closed((Comparable)Double.valueOf(25.0), (Comparable)Double.valueOf(50.0)));
    }

    private static DisjointRangeDomainHistogram disjunction(ConnectorHistogram source, Range<Double> range) {
        return (DisjointRangeDomainHistogram)DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (StatisticRange)StatisticRange.fromRange(range));
    }

    private static DisjointRangeDomainHistogram conjunction(ConnectorHistogram source, Range<Double> range) {
        return (DisjointRangeDomainHistogram)DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)source, (StatisticRange)StatisticRange.fromRange(range));
    }

    private static List<Range<Double>> ranges(DisjointRangeDomainHistogram hist) {
        return hist.getRanges().stream().map(StatisticRange::toRange).collect(Collectors.toList());
    }

    @Override
    ConnectorHistogram createHistogram() {
        RealDistribution distribution = this.getDistribution();
        return new DisjointRangeDomainHistogram((ConnectorHistogram)new UniformDistributionHistogram(distribution.getSupportLowerBound(), distribution.getSupportUpperBound())).addDisjunction(new StatisticRange(0.0, 100.0, 0.0));
    }

    @Override
    double getDistinctValues() {
        return 100.0;
    }

    @Override
    RealDistribution getDistribution() {
        return new UniformRealDistribution(0.0, 100.0);
    }

    @Override
    public void testInclusiveExclusive() {
    }

    private static class StandardNormalHistogram
    implements ConnectorHistogram {
        private final NormalDistribution distribution = new NormalDistribution();

        private StandardNormalHistogram() {
        }

        public NormalDistribution getDistribution() {
            return this.distribution;
        }

        public Estimate cumulativeProbability(double value, boolean inclusive) {
            return Estimate.of((double)this.distribution.cumulativeProbability(value));
        }

        public Estimate inverseCumulativeProbability(double percentile) {
            if (percentile <= 0.0) {
                return Estimate.of((double)-10.0);
            }
            if (percentile >= 1.0) {
                return Estimate.of((double)10.0);
            }
            return Estimate.of((double)this.distribution.inverseCumulativeProbability(percentile));
        }

        public long getEstimatedSize() {
            return 0L;
        }
    }
}

