/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.FragmentStatsProvider;
import com.facebook.presto.cost.JoinNodeStatsEstimate;
import com.facebook.presto.cost.PartialAggregationStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.TableWriterNodeStatsEstimate;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFragmentStatsProvider {
    @Test
    public void testFragmentStatsProvider() {
        FragmentStatsProvider fragmentStatsProvider = new FragmentStatsProvider();
        QueryId queryId1 = new QueryId("queryid1");
        QueryId queryId2 = new QueryId("queryid2");
        PlanFragmentId planFragmentId1 = new PlanFragmentId(1);
        PlanFragmentId planFragmentId2 = new PlanFragmentId(2);
        PlanNodeStatsEstimate planNodeStatsEstimate1 = new PlanNodeStatsEstimate(Double.NaN, 10.0, SourceInfo.ConfidenceLevel.FACT, (Map)ImmutableMap.of(), JoinNodeStatsEstimate.unknown(), TableWriterNodeStatsEstimate.unknown(), PartialAggregationStatsEstimate.unknown());
        PlanNodeStatsEstimate planNodeStatsEstimate2 = new PlanNodeStatsEstimate(Double.NaN, 100.0, SourceInfo.ConfidenceLevel.FACT, (Map)ImmutableMap.of(), JoinNodeStatsEstimate.unknown(), TableWriterNodeStatsEstimate.unknown(), PartialAggregationStatsEstimate.unknown());
        Assert.assertEquals((Object)fragmentStatsProvider.getStats(queryId1, planFragmentId1), (Object)PlanNodeStatsEstimate.unknown());
        fragmentStatsProvider.putStats(queryId1, planFragmentId1, planNodeStatsEstimate1);
        Assert.assertEquals((Object)fragmentStatsProvider.getStats(queryId1, planFragmentId1), (Object)planNodeStatsEstimate1);
        Assert.assertEquals((Object)fragmentStatsProvider.getStats(queryId2, planFragmentId1), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)fragmentStatsProvider.getStats(queryId1, planFragmentId2), (Object)PlanNodeStatsEstimate.unknown());
        fragmentStatsProvider.putStats(queryId1, planFragmentId2, planNodeStatsEstimate2);
        Assert.assertEquals((Object)fragmentStatsProvider.getStats(queryId1, planFragmentId2), (Object)planNodeStatsEstimate2);
        fragmentStatsProvider.putStats(queryId2, planFragmentId1, planNodeStatsEstimate1);
        Assert.assertEquals((Object)fragmentStatsProvider.getStats(queryId2, planFragmentId1), (Object)planNodeStatsEstimate1);
        fragmentStatsProvider.invalidateStats(queryId1, 2);
        Assert.assertEquals((Object)fragmentStatsProvider.getStats(queryId1, planFragmentId1), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)fragmentStatsProvider.getStats(queryId1, planFragmentId2), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)fragmentStatsProvider.getStats(queryId2, planFragmentId1), (Object)planNodeStatsEstimate1);
    }
}

