/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.DisjointRangeDomainHistogram;
import com.facebook.presto.cost.HistogramCalculator;
import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.cost.UniformDistributionHistogram;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.Estimate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHistogramCalculator {
    @Test
    public void testCalculateFilterFactor() {
        StatisticRange zeroToTen = TestHistogramCalculator.range(0.0, 10.0, 10.0);
        StatisticRange empty = StatisticRange.empty();
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)1.0), zeroToTen, TestHistogramCalculator.uniformHist(0.0, 10.0), 5.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)1.0), zeroToTen, TestHistogramCalculator.uniformHist(0.0, 10.0), 20.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.5), TestHistogramCalculator.range(5.0, 3000.0, 5.0), TestHistogramCalculator.uniformHist(zeroToTen), zeroToTen.getDistinctValuesCount());
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)(1.0 / zeroToTen.getDistinctValuesCount())), TestHistogramCalculator.range(3.0, 3.0, 1.0), TestHistogramCalculator.uniformHist(zeroToTen), zeroToTen.getDistinctValuesCount());
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)(1.0 / zeroToTen.getDistinctValuesCount())), TestHistogramCalculator.range(10.0, 100.0, 357.0), TestHistogramCalculator.uniformHist(zeroToTen), zeroToTen.getDistinctValuesCount());
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), TestHistogramCalculator.range(20.0, 30.0, 10.0), TestHistogramCalculator.uniformHist(zeroToTen), zeroToTen.getDistinctValuesCount());
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), zeroToTen, TestHistogramCalculator.uniformHist(empty), empty.getDistinctValuesCount());
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), empty, TestHistogramCalculator.uniformHist(zeroToTen), zeroToTen.getDistinctValuesCount());
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), TestHistogramCalculator.unboundedRange(10.0), TestHistogramCalculator.uniformHist(empty), empty.getDistinctValuesCount());
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), empty, TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange(10.0)), 10.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.5), TestHistogramCalculator.unboundedRange(10.0), TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange(20.0)), 20.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)1.0), TestHistogramCalculator.unboundedRange(20.0), TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange(10.0)), 10.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.5), TestHistogramCalculator.unboundedRange(0.5), TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange(Double.NaN)), Double.NaN);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.2), TestHistogramCalculator.unboundedRange(1.0), TestHistogramCalculator.domainConstrained(TestHistogramCalculator.unboundedRange(5.0), TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange(7.0))), 5.0);
    }

    private static StatisticRange range(double low, double high, double distinctValues) {
        return new StatisticRange(low, high, distinctValues);
    }

    private static StatisticRange unboundedRange(double distinctValues) {
        return new StatisticRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, distinctValues);
    }

    private static void assertFilterFactor(Estimate expected, StatisticRange range, ConnectorHistogram histogram, double totalDistinctValues) {
        Assert.assertEquals((Object)HistogramCalculator.calculateFilterFactor((StatisticRange)range, (ConnectorHistogram)histogram, (Estimate)Estimate.estimateFromDouble((double)totalDistinctValues), (boolean)true), (Object)expected);
    }

    private static ConnectorHistogram uniformHist(StatisticRange range) {
        return TestHistogramCalculator.uniformHist(range.getLow(), range.getHigh());
    }

    private static ConnectorHistogram uniformHist(double low, double high) {
        return new UniformDistributionHistogram(low, high);
    }

    private static ConnectorHistogram domainConstrained(StatisticRange range, ConnectorHistogram source) {
        return DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (StatisticRange)range);
    }
}

