/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.Session;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHistoryBasedOptimizationConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HistoryBasedOptimizationConfig)ConfigAssertions.recordDefaults(HistoryBasedOptimizationConfig.class)).setMaxLastRunsHistory(10).setHistoryMatchingThreshold(0.1));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hbo.max-last-runs-history", (Object)"50").put((Object)"hbo.history-matching-threshold", (Object)"0.2").build();
        HistoryBasedOptimizationConfig expected = new HistoryBasedOptimizationConfig().setMaxLastRunsHistory(50).setHistoryMatchingThreshold(0.2);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testPlanCanonicalizationStrategyOrder() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("history_based_optimization_plan_canonicalization_strategy", "IGNORE_SAFE_CONSTANTS,DEFAULT,CONNECTOR,IGNORE_SCAN_CONSTANTS").build();
        List strategyList = HistoryBasedPlanStatisticsManager.historyBasedPlanCanonicalizationStrategyList((Session)session);
        Assert.assertEquals((int)strategyList.size(), (int)4);
        Assert.assertEquals(strategyList.get(0), (Object)PlanCanonicalizationStrategy.DEFAULT);
        Assert.assertEquals(strategyList.get(1), (Object)PlanCanonicalizationStrategy.CONNECTOR);
        Assert.assertEquals(strategyList.get(2), (Object)PlanCanonicalizationStrategy.IGNORE_SAFE_CONSTANTS);
        Assert.assertEquals(strategyList.get(3), (Object)PlanCanonicalizationStrategy.IGNORE_SCAN_CONSTANTS);
        session = TestingSession.testSessionBuilder().setSystemProperty("history_based_optimization_plan_canonicalization_strategy", "IGNORE_SAFE_CONSTANTS,IGNORE_SCAN_CONSTANTS").build();
        strategyList = HistoryBasedPlanStatisticsManager.historyBasedPlanCanonicalizationStrategyList((Session)session);
        Assert.assertEquals((int)strategyList.size(), (int)2);
        Assert.assertEquals(strategyList.get(0), (Object)PlanCanonicalizationStrategy.IGNORE_SAFE_CONSTANTS);
        Assert.assertEquals(strategyList.get(1), (Object)PlanCanonicalizationStrategy.IGNORE_SCAN_CONSTANTS);
        session = TestingSession.testSessionBuilder().setSystemProperty("history_based_optimization_plan_canonicalization_strategy", "IGNORE_SCAN_CONSTANTS,IGNORE_SAFE_CONSTANTS").build();
        strategyList = HistoryBasedPlanStatisticsManager.historyBasedPlanCanonicalizationStrategyList((Session)session);
        Assert.assertEquals((int)strategyList.size(), (int)2);
        Assert.assertEquals(strategyList.get(0), (Object)PlanCanonicalizationStrategy.IGNORE_SAFE_CONSTANTS);
        Assert.assertEquals(strategyList.get(1), (Object)PlanCanonicalizationStrategy.IGNORE_SCAN_CONSTANTS);
    }
}

