/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.DisjointRangeDomainHistogram;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimateMath;
import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.cost.UniformDistributionHistogram;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.testing.assertions.Assert;
import java.util.Optional;
import java.util.function.BiFunction;
import org.testng.annotations.Test;

public class TestPlanNodeStatsEstimateMath {
    private static final VariableReferenceExpression VARIABLE = new VariableReferenceExpression(Optional.empty(), "variable", (Type)BigintType.BIGINT);
    private static final StatisticRange NON_EMPTY_RANGE = TestPlanNodeStatsEstimateMath.openRange(1.0);
    private final PlanNodeStatsEstimateMath calculator = new PlanNodeStatsEstimateMath(true);

    @Test
    public void testAddRowCount() {
        PlanNodeStatsEstimate unknownStats = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        Assert.assertEquals((Object)this.calculator.addStatsAndSumDistinctValues(unknownStats, unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)this.calculator.addStatsAndSumDistinctValues(first, unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)this.calculator.addStatsAndSumDistinctValues(unknownStats, second), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((double)this.calculator.addStatsAndSumDistinctValues(first, second).getOutputRowCount(), (double)30.0);
    }

    @Test
    public void testAddTotalSize() {
        PlanNodeStatsEstimate unknownStats = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, 10.0, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, 20.0, Double.NaN, Double.NaN, StatisticRange.empty());
        Assert.assertEquals((Object)this.calculator.addStatsAndSumDistinctValues(unknownStats, unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)this.calculator.addStatsAndSumDistinctValues(first, unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)this.calculator.addStatsAndSumDistinctValues(unknownStats, second), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((double)this.calculator.addStatsAndSumDistinctValues(first, second).getTotalSize(), (double)30.0);
    }

    @Test
    public void testAddNullsFraction() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.2, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountFirst = TestPlanNodeStatsEstimateMath.statistics(0.1, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountSecond = TestPlanNodeStatsEstimateMath.statistics(0.2, Double.NaN, 0.3, Double.NaN, NON_EMPTY_RANGE);
        this.assertAddNullsFraction(unknownRowCount, unknownRowCount, Double.NaN);
        this.assertAddNullsFraction(unknownNullsFraction, unknownNullsFraction, Double.NaN);
        this.assertAddNullsFraction(unknownRowCount, unknownNullsFraction, Double.NaN);
        this.assertAddNullsFraction(first, unknownNullsFraction, Double.NaN);
        this.assertAddNullsFraction(unknownRowCount, second, Double.NaN);
        this.assertAddNullsFraction(first, second, 0.16666666666666666);
        this.assertAddNullsFraction(fractionalRowCountFirst, fractionalRowCountSecond, 0.2333333333333333);
    }

    private void assertAddNullsFraction(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)this.calculator.addStatsAndSumDistinctValues(first, second).getVariableStatistics(VARIABLE).getNullsFraction(), (double)expected);
    }

    @Test
    public void testAddAverageRowSize() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, 0.1, 10.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, 10.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownAverageRowSize = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.1, 15.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.2, 20.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountFirst = TestPlanNodeStatsEstimateMath.statistics(0.1, Double.NaN, 0.1, 0.3, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountSecond = TestPlanNodeStatsEstimateMath.statistics(0.2, Double.NaN, 0.3, 0.4, NON_EMPTY_RANGE);
        this.assertAddAverageRowSize(unknownRowCount, unknownRowCount, Double.NaN);
        this.assertAddAverageRowSize(unknownNullsFraction, unknownNullsFraction, Double.NaN);
        this.assertAddAverageRowSize(unknownAverageRowSize, unknownAverageRowSize, Double.NaN);
        this.assertAddAverageRowSize(first, unknownRowCount, Double.NaN);
        this.assertAddAverageRowSize(unknownNullsFraction, second, Double.NaN);
        this.assertAddAverageRowSize(first, unknownAverageRowSize, Double.NaN);
        this.assertAddAverageRowSize(first, second, 18.2);
        this.assertAddAverageRowSize(fractionalRowCountFirst, fractionalRowCountSecond, 0.3608695652173913);
    }

    private void assertAddAverageRowSize(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)this.calculator.addStatsAndSumDistinctValues(first, second).getVariableStatistics(VARIABLE).getAverageRowSize(), (double)expected);
    }

    @Test
    public void testSumNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate unknownRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(2.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(3.0));
        this.assertSumNumberOfDistinctValues(unknownRowCount, unknownRowCount, Double.NaN);
        this.assertSumNumberOfDistinctValues(unknownRowCount, second, Double.NaN);
        this.assertSumNumberOfDistinctValues(first, emptyRange, 2.0);
        this.assertSumNumberOfDistinctValues(first, unknownRange, Double.NaN);
        this.assertSumNumberOfDistinctValues(first, second, 5.0);
    }

    private void assertSumNumberOfDistinctValues(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)this.calculator.addStatsAndSumDistinctValues(first, second).getVariableStatistics(VARIABLE).getDistinctValuesCount(), (double)expected);
    }

    @Test
    public void testMaxNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate unknownRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(2.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(3.0));
        this.assertMaxNumberOfDistinctValues(unknownRowCount, unknownRowCount, Double.NaN);
        this.assertMaxNumberOfDistinctValues(unknownRowCount, second, Double.NaN);
        this.assertMaxNumberOfDistinctValues(first, emptyRange, 2.0);
        this.assertMaxNumberOfDistinctValues(first, unknownRange, Double.NaN);
        this.assertMaxNumberOfDistinctValues(first, second, 3.0);
    }

    private void assertMaxNumberOfDistinctValues(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)this.calculator.addStatsAndMaxDistinctValues(first, second).getVariableStatistics(VARIABLE).getDistinctValuesCount(), (double)expected);
    }

    @Test
    public void testAddRange() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate unknownRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(12.0, 100.0, 2.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(101.0, 200.0, 3.0));
        this.assertAddRange(unknownRange, unknownRange, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.assertAddRange(unknownRowCount, second, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.assertAddRange(unknownRange, second, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.assertAddRange(emptyRange, second, 101.0, 200.0);
        this.assertAddRange(first, second, 12.0, 200.0);
    }

    private void assertAddRange(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expectedLow, double expectedHigh) {
        VariableStatsEstimate statistics = this.calculator.addStatsAndMaxDistinctValues(first, second).getVariableStatistics(VARIABLE);
        Assert.assertEquals((double)statistics.getLowValue(), (double)expectedLow);
        Assert.assertEquals((double)statistics.getHighValue(), (double)expectedHigh);
    }

    @Test
    public void testSubtractRowCount() {
        PlanNodeStatsEstimate unknownStats = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(40.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        Assert.assertEquals((Object)this.calculator.subtractSubsetStats(unknownStats, unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)this.calculator.subtractSubsetStats(first, unknownStats), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((Object)this.calculator.subtractSubsetStats(unknownStats, second), (Object)PlanNodeStatsEstimate.unknown());
        Assert.assertEquals((double)this.calculator.subtractSubsetStats(first, second).getOutputRowCount(), (double)30.0);
    }

    @Test
    public void testSubtractNullsFraction() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(50.0, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.2, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountFirst = TestPlanNodeStatsEstimateMath.statistics(0.7, Double.NaN, 0.1, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate fractionalRowCountSecond = TestPlanNodeStatsEstimateMath.statistics(0.2, Double.NaN, 0.3, Double.NaN, NON_EMPTY_RANGE);
        this.assertSubtractNullsFraction(unknownRowCount, unknownRowCount, Double.NaN);
        this.assertSubtractNullsFraction(unknownRowCount, unknownNullsFraction, Double.NaN);
        this.assertSubtractNullsFraction(first, unknownNullsFraction, Double.NaN);
        this.assertSubtractNullsFraction(unknownRowCount, second, Double.NaN);
        this.assertSubtractNullsFraction(first, second, 0.03333333333333333);
        this.assertSubtractNullsFraction(fractionalRowCountFirst, fractionalRowCountSecond, 0.019999999999999993);
    }

    private void assertSubtractNullsFraction(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)this.calculator.subtractSubsetStats(first, second).getVariableStatistics(VARIABLE).getNullsFraction(), (double)expected);
    }

    @Test
    public void testSubtractNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownDistinctValues = TestPlanNodeStatsEstimateMath.statistics(100.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate zero = TestPlanNodeStatsEstimateMath.statistics(0.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(0.0));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(30.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(10.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(5.0));
        PlanNodeStatsEstimate third = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.1, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(3.0));
        this.assertSubtractNumberOfDistinctValues(unknownRowCount, unknownRowCount, Double.NaN);
        this.assertSubtractNumberOfDistinctValues(unknownRowCount, second, Double.NaN);
        this.assertSubtractNumberOfDistinctValues(unknownDistinctValues, second, Double.NaN);
        this.assertSubtractNumberOfDistinctValues(first, zero, 10.0);
        this.assertSubtractNumberOfDistinctValues(zero, zero, 0.0);
        this.assertSubtractNumberOfDistinctValues(first, second, 5.0);
        this.assertSubtractNumberOfDistinctValues(second, third, 5.0);
    }

    private void assertSubtractNumberOfDistinctValues(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, double expected) {
        Assert.assertEquals((double)this.calculator.subtractSubsetStats(first, second).getVariableStatistics(VARIABLE).getDistinctValuesCount(), (double)expected);
    }

    @Test
    public void testSubtractRange() {
        this.assertSubtractRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.assertSubtractRange(0.0, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 1.0);
        this.assertSubtractRange(Double.NaN, Double.NaN, 0.0, 1.0, Double.NaN, Double.NaN);
        this.assertSubtractRange(0.0, 1.0, Double.NaN, Double.NaN, 0.0, 1.0);
        this.assertSubtractRange(0.0, 2.0, 0.0, 1.0, 0.0, 2.0);
        this.assertSubtractRange(0.0, 2.0, 1.0, 2.0, 0.0, 2.0);
        this.assertSubtractRange(0.0, 2.0, 0.5, 1.0, 0.0, 2.0);
    }

    private void assertSubtractRange(double supersetLow, double supersetHigh, double subsetLow, double subsetHigh, double expectedLow, double expectedHigh) {
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(30.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(supersetLow, supersetHigh, 10.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(subsetLow, subsetHigh, 5.0));
        VariableStatsEstimate statistics = this.calculator.subtractSubsetStats(first, second).getVariableStatistics(VARIABLE);
        Assert.assertEquals((double)statistics.getLowValue(), (double)expectedLow);
        Assert.assertEquals((double)statistics.getHighValue(), (double)expectedHigh);
    }

    @Test
    public void testCapRowCount() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        Assert.assertEquals((double)this.calculator.capStats(unknownRowCount, unknownRowCount).getOutputRowCount(), (double)Double.NaN);
        Assert.assertEquals((double)this.calculator.capStats(first, unknownRowCount).getOutputRowCount(), (double)Double.NaN);
        Assert.assertEquals((double)this.calculator.capStats(unknownRowCount, second).getOutputRowCount(), (double)Double.NaN);
        Assert.assertEquals((double)this.calculator.capStats(first, second).getOutputRowCount(), (double)10.0);
        Assert.assertEquals((double)this.calculator.capStats(second, first).getOutputRowCount(), (double)10.0);
    }

    @Test
    public void testCapAverageRowSize() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownAverageRowSize = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, 10.0, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, 5.0, NON_EMPTY_RANGE);
        this.assertCapAverageRowSize(unknownRowCount, unknownRowCount, Double.NaN);
        this.assertCapAverageRowSize(unknownAverageRowSize, unknownAverageRowSize, Double.NaN);
        this.assertCapAverageRowSize(first, unknownAverageRowSize, 10.0);
        this.assertCapAverageRowSize(unknownAverageRowSize, second, Double.NaN);
        this.assertCapAverageRowSize(first, second, 10.0);
    }

    private void assertCapAverageRowSize(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap, double expected) {
        Assert.assertEquals((double)this.calculator.capStats(stats, cap).getVariableStatistics(VARIABLE).getAverageRowSize(), (double)expected);
    }

    @Test
    public void testCapNumberOfDistinctValues() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNumberOfDistinctValues = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(10.0));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(5.0));
        this.assertCapNumberOfDistinctValues(unknownRowCount, unknownRowCount, Double.NaN);
        this.assertCapNumberOfDistinctValues(unknownNumberOfDistinctValues, unknownNumberOfDistinctValues, Double.NaN);
        this.assertCapNumberOfDistinctValues(first, unknownRowCount, Double.NaN);
        this.assertCapNumberOfDistinctValues(unknownNumberOfDistinctValues, second, Double.NaN);
        this.assertCapNumberOfDistinctValues(first, second, 5.0);
    }

    private void assertCapNumberOfDistinctValues(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap, double expected) {
        Assert.assertEquals((double)this.calculator.capStats(stats, cap).getVariableStatistics(VARIABLE).getDistinctValuesCount(), (double)expected);
    }

    @Test
    public void testCapRange() {
        PlanNodeStatsEstimate emptyRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, StatisticRange.empty());
        PlanNodeStatsEstimate openRange = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, TestPlanNodeStatsEstimateMath.openRange(Double.NaN));
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(12.0, 100.0, Double.NaN));
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, new StatisticRange(13.0, 99.0, Double.NaN));
        this.assertCapRange(emptyRange, emptyRange, Double.NaN, Double.NaN);
        this.assertCapRange(emptyRange, openRange, Double.NaN, Double.NaN);
        this.assertCapRange(openRange, emptyRange, Double.NaN, Double.NaN);
        this.assertCapRange(first, openRange, 12.0, 100.0);
        this.assertCapRange(openRange, second, 13.0, 99.0);
        this.assertCapRange(first, second, 13.0, 99.0);
    }

    private void assertCapRange(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap, double expectedLow, double expectedHigh) {
        VariableStatsEstimate symbolStats = this.calculator.capStats(stats, cap).getVariableStatistics(VARIABLE);
        Assert.assertEquals((double)symbolStats.getLowValue(), (double)expectedLow);
        Assert.assertEquals((double)symbolStats.getHighValue(), (double)expectedHigh);
    }

    @Test
    public void testCapNullsFraction() {
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.25, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, 0.6, Double.NaN, NON_EMPTY_RANGE);
        PlanNodeStatsEstimate third = TestPlanNodeStatsEstimateMath.statistics(0.0, Double.NaN, 0.6, Double.NaN, NON_EMPTY_RANGE);
        this.assertCapNullsFraction(unknownRowCount, unknownRowCount, Double.NaN);
        this.assertCapNullsFraction(unknownNullsFraction, unknownNullsFraction, Double.NaN);
        this.assertCapNullsFraction(first, unknownNullsFraction, Double.NaN);
        this.assertCapNullsFraction(unknownNullsFraction, second, Double.NaN);
        this.assertCapNullsFraction(first, second, 0.5);
        this.assertCapNullsFraction(first, third, 1.0);
    }

    private void assertCapNullsFraction(PlanNodeStatsEstimate stats, PlanNodeStatsEstimate cap, double expected) {
        Assert.assertEquals((double)this.calculator.capStats(stats, cap).getVariableStatistics(VARIABLE).getNullsFraction(), (double)expected);
    }

    @Test
    public void testAddHistograms() {
        StatisticRange zeroToTen = new StatisticRange(0.0, 10.0, 1.0);
        StatisticRange zeroToFive = new StatisticRange(0.0, 5.0, 1.0);
        StatisticRange fiveToTen = new StatisticRange(5.0, 10.0, 1.0);
        StatisticRange threeToSeven = new StatisticRange(3.0, 7.0, 1.0);
        PlanNodeStatsEstimate unknownRowCount = TestPlanNodeStatsEstimateMath.statistics(Double.NaN, Double.NaN, Double.NaN, Double.NaN, zeroToTen);
        PlanNodeStatsEstimate unknownNullsFraction = TestPlanNodeStatsEstimateMath.statistics(10.0, Double.NaN, Double.NaN, Double.NaN, zeroToTen);
        PlanNodeStatsEstimate first = TestPlanNodeStatsEstimateMath.statistics(50.0, Double.NaN, 0.25, Double.NaN, zeroToTen);
        PlanNodeStatsEstimate second = TestPlanNodeStatsEstimateMath.statistics(25.0, Double.NaN, 0.6, Double.NaN, zeroToFive);
        PlanNodeStatsEstimate third = TestPlanNodeStatsEstimateMath.statistics(25.0, Double.NaN, 0.6, Double.NaN, fiveToTen);
        PlanNodeStatsEstimate fourth = TestPlanNodeStatsEstimateMath.statistics(20.0, Double.NaN, 0.6, Double.NaN, threeToSeven);
        Assert.assertEquals((Object)this.calculator.addStatsAndCollapseDistinctValues(unknownRowCount, unknownRowCount).getVariableStatistics(VARIABLE).getHistogram(), Optional.empty());
        ConnectorHistogram addedSameRange = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)((ConnectorHistogram)unknownNullsFraction.getVariableStatistics(VARIABLE).getHistogram().get()), (StatisticRange)zeroToTen);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(unknownNullsFraction, unknownNullsFraction, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndSumDistinctValues(arg_0, arg_1), addedSameRange);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(unknownNullsFraction, unknownNullsFraction, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndCollapseDistinctValues(arg_0, arg_1), addedSameRange);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(unknownNullsFraction, unknownNullsFraction, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndMaxDistinctValues(arg_0, arg_1), addedSameRange);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(unknownNullsFraction, unknownNullsFraction, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndIntersect(arg_0, arg_1), addedSameRange);
        ConnectorHistogram fullRangeFirst = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)((ConnectorHistogram)first.getVariableStatistics(VARIABLE).getHistogram().get()), (StatisticRange)zeroToTen);
        ConnectorHistogram intersectedRangeSecond = DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)((ConnectorHistogram)first.getVariableStatistics(VARIABLE).getHistogram().get()), (StatisticRange)zeroToFive);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(first, second, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndSumDistinctValues(arg_0, arg_1), fullRangeFirst);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(first, second, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndCollapseDistinctValues(arg_0, arg_1), fullRangeFirst);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(first, second, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndMaxDistinctValues(arg_0, arg_1), fullRangeFirst);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(first, second, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndIntersect(arg_0, arg_1), intersectedRangeSecond);
        ConnectorHistogram fullRangeSecondThird = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)((ConnectorHistogram)second.getVariableStatistics(VARIABLE).getHistogram().get()), (StatisticRange)fiveToTen);
        ConnectorHistogram intersectedRangeSecondThird = DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)((ConnectorHistogram)second.getVariableStatistics(VARIABLE).getHistogram().get()), (StatisticRange)fiveToTen);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(second, third, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndSumDistinctValues(arg_0, arg_1), fullRangeSecondThird);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(second, third, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndCollapseDistinctValues(arg_0, arg_1), fullRangeSecondThird);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(second, third, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndMaxDistinctValues(arg_0, arg_1), fullRangeSecondThird);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(second, third, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndIntersect(arg_0, arg_1), intersectedRangeSecondThird);
        ConnectorHistogram fullRangeThirdFourth = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)((ConnectorHistogram)third.getVariableStatistics(VARIABLE).getHistogram().get()), (StatisticRange)threeToSeven);
        ConnectorHistogram intersectedRangeThirdFourth = DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)((ConnectorHistogram)third.getVariableStatistics(VARIABLE).getHistogram().get()), (StatisticRange)threeToSeven);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(third, fourth, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndSumDistinctValues(arg_0, arg_1), fullRangeThirdFourth);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(third, fourth, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndCollapseDistinctValues(arg_0, arg_1), fullRangeThirdFourth);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(third, fourth, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndMaxDistinctValues(arg_0, arg_1), fullRangeThirdFourth);
        TestPlanNodeStatsEstimateMath.assertAddStatsHistogram(third, fourth, (arg_0, arg_1) -> ((PlanNodeStatsEstimateMath)this.calculator).addStatsAndIntersect(arg_0, arg_1), intersectedRangeThirdFourth);
    }

    private static void assertAddStatsHistogram(PlanNodeStatsEstimate first, PlanNodeStatsEstimate second, BiFunction<PlanNodeStatsEstimate, PlanNodeStatsEstimate, PlanNodeStatsEstimate> function, ConnectorHistogram expected) {
        Assert.assertEquals(function.apply(first, second).getVariableStatistics(VARIABLE).getHistogram().get(), (Object)expected);
    }

    private static PlanNodeStatsEstimate statistics(double rowCount, double totalSize, double nullsFraction, double averageRowSize, StatisticRange range) {
        return PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount).setTotalSize(totalSize).addVariableStatistics(VARIABLE, VariableStatsEstimate.builder().setNullsFraction(nullsFraction).setAverageRowSize(averageRowSize).setStatisticsRange(range).setHistogram(Optional.of(DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)new UniformDistributionHistogram(range.getLow(), range.getHigh()), (StatisticRange)range))).build()).build();
    }

    private static StatisticRange openRange(double distinctValues) {
        return new StatisticRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, distinctValues);
    }
}

