/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSemiJoinStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testSemiJoinPropagatesSourceStats() {
        VariableStatsEstimate stats = VariableStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.3).build();
        this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression a = pb.variable("a", (Type)BigintType.BIGINT);
            VariableReferenceExpression b = pb.variable("b", (Type)BigintType.BIGINT);
            VariableReferenceExpression c = pb.variable("c", (Type)BigintType.BIGINT);
            VariableReferenceExpression semiJoinOutput = pb.variable("sjo", (Type)BooleanType.BOOLEAN);
            return pb.semiJoin((PlanNode)pb.values(a, b), (PlanNode)pb.values(c), a, c, semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty());
        }).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT), stats).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "b", (Type)BigintType.BIGINT), stats).build()).withSourceStats(1, PlanNodeStatsEstimate.builder().setOutputRowCount(20.0).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "c", (Type)BigintType.BIGINT), stats).build()).check(check -> check.outputRowsCount(10.0).variableStats(new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(stats)).variableStats(new VariableReferenceExpression(Optional.empty(), "b", (Type)BigintType.BIGINT), assertion -> assertion.isEqualTo(stats)).variableStatsUnknown("c").variableStatsUnknown("sjo"));
    }
}

