/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.cost.StatisticRange;
import com.facebook.presto.cost.UniformDistributionHistogram;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.google.common.collect.Range;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVariableStatsEstimate {
    @Test
    public void testSkipHistogramSerialization() {
        JsonCodec codec = JsonCodec.jsonCodec(VariableStatsEstimate.class);
        VariableStatsEstimate estimate = VariableStatsEstimate.builder().setAverageRowSize(100.0).setDistinctValuesCount(100.0).setStatisticsRange(StatisticRange.fromRange((Range)Range.open((Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(2.0)))).setHistogram(Optional.of(new UniformDistributionHistogram(55.0, 65.0))).setNullsFraction(0.1).build();
        VariableStatsEstimate serialized = (VariableStatsEstimate)codec.fromBytes(codec.toBytes((Object)estimate));
        Assert.assertEquals((double)serialized.getAverageRowSize(), (double)estimate.getAverageRowSize());
        Assert.assertEquals((double)serialized.getDistinctValuesCount(), (double)estimate.getDistinctValuesCount());
        Assert.assertEquals((double)serialized.getLowValue(), (double)estimate.getLowValue());
        Assert.assertEquals((double)serialized.getHighValue(), (double)estimate.getHighValue());
        Assert.assertTrue((boolean)estimate.getHistogram().isPresent());
        Assert.assertFalse((boolean)serialized.getHistogram().isPresent());
    }
}

