/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.json.JsonBinder;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TestQueryStats;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.server.SliceDeserializer;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.WarningCode;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.prestospark.PrestoSparkExecutionContext;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.sql.Serialization;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CanonicalPlan;
import com.facebook.presto.sql.planner.CanonicalPlanWithInfo;
import com.facebook.presto.sql.planner.PlanNodeCanonicalInfo;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.type.TypeDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import io.airlift.slice.Slice;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryInfo {
    @Test
    public void testQueryInfoRoundTrip() {
        JsonCodec<QueryInfo> codec = TestQueryInfo.createJsonCodec();
        QueryInfo expected = TestQueryInfo.createQueryInfo();
        QueryInfo actual = (QueryInfo)codec.fromJson(codec.toJson((Object)expected));
        Assert.assertEquals((Object)actual.getQueryId(), (Object)expected.getQueryId());
        Assert.assertEquals((Object)actual.getState(), (Object)expected.getState());
        Assert.assertEquals((Object)actual.getMemoryPool(), (Object)expected.getMemoryPool());
        Assert.assertEquals((boolean)actual.isScheduled(), (boolean)expected.isScheduled());
        Assert.assertEquals((Object)actual.getSelf(), (Object)expected.getSelf());
        Assert.assertEquals((Collection)actual.getFieldNames(), (Collection)expected.getFieldNames());
        Assert.assertEquals((String)actual.getQuery(), (String)expected.getQuery());
        Assert.assertEquals((String)actual.getQueryHash(), (String)expected.getQueryHash());
        Assert.assertEquals((Object)actual.getExpandedQuery(), (Object)expected.getExpandedQuery());
        Assert.assertEquals((Object)actual.getPreparedQuery(), (Object)expected.getPreparedQuery());
        TestQueryStats.assertExpectedQueryStats(actual.getQueryStats());
        Assert.assertEquals((Object)actual.getSetCatalog(), (Object)expected.getSetCatalog());
        Assert.assertEquals((Object)actual.getSetSchema(), (Object)expected.getSetSchema());
        Assert.assertEquals((Map)actual.getSetSessionProperties(), (Map)expected.getSetSessionProperties());
        Assert.assertEquals((Set)actual.getResetSessionProperties(), (Set)expected.getResetSessionProperties());
        Assert.assertEquals((Map)actual.getSetRoles(), (Map)expected.getSetRoles());
        Assert.assertEquals((Map)actual.getAddedPreparedStatements(), (Map)expected.getAddedPreparedStatements());
        Assert.assertEquals((Set)actual.getDeallocatedPreparedStatements(), (Set)expected.getDeallocatedPreparedStatements());
        Assert.assertEquals((Object)actual.getStartedTransactionId(), (Object)expected.getStartedTransactionId());
        Assert.assertEquals((boolean)actual.isClearTransactionId(), (boolean)expected.isClearTransactionId());
        Assert.assertEquals((String)actual.getUpdateType(), (String)expected.getUpdateType());
        Assert.assertEquals((Object)actual.getOutputStage(), (Object)expected.getOutputStage());
        Assert.assertEquals((Object)actual.getFailureInfo(), (Object)expected.getFailureInfo());
        Assert.assertEquals((Object)actual.getErrorCode(), (Object)expected.getErrorCode());
        Assert.assertEquals((Collection)actual.getWarnings(), (Collection)expected.getWarnings());
        Assert.assertEquals((Set)actual.getInputs(), (Set)expected.getInputs());
        Assert.assertEquals((Object)actual.getOutput(), (Object)expected.getOutput());
        Assert.assertEquals((boolean)actual.isFinalQueryInfo(), (boolean)expected.isFinalQueryInfo());
        Assert.assertEquals((Object)actual.getResourceGroupId(), (Object)expected.getResourceGroupId());
        Assert.assertEquals((Object)actual.getQueryType(), (Object)expected.getQueryType());
        Assert.assertEquals((Object)actual.getFailedTasks(), (Object)expected.getFailedTasks());
        Assert.assertEquals((Object)actual.getRuntimeOptimizedStages(), (Object)actual.getRuntimeOptimizedStages());
        Assert.assertEquals((Map)actual.getAddedSessionFunctions(), (Map)expected.getAddedSessionFunctions());
        Assert.assertEquals((Set)actual.getRemovedSessionFunctions(), (Set)expected.getRemovedSessionFunctions());
        Assert.assertEquals((Collection)actual.getPlanCanonicalInfo(), (Collection)ImmutableList.of());
        Assert.assertEquals((Object)actual.getPrestoSparkExecutionContext(), (Object)expected.getPrestoSparkExecutionContext());
    }

    private static JsonCodec<QueryInfo> createJsonCodec() {
        Module module = binder -> {
            SqlParser sqlParser = new SqlParser();
            FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
            binder.install((Module)new JsonModule());
            binder.install((Module)new HandleJsonModule());
            binder.bind(SqlParser.class).toInstance((Object)sqlParser);
            binder.bind(TypeManager.class).toInstance((Object)functionAndTypeManager);
            ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
            Multibinder.newSetBinder((Binder)binder, Type.class);
            JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Slice.class).to(SliceSerializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Slice.class).to(SliceDeserializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
            JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Expression.class).to(Serialization.ExpressionSerializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Expression.class).to(Serialization.ExpressionDeserializer.class);
            JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(FunctionCall.class).to(Serialization.FunctionCallDeserializer.class);
            JsonBinder.jsonBinder((Binder)binder).addKeySerializerBinding(VariableReferenceExpression.class).to(Serialization.VariableReferenceExpressionSerializer.class);
            JsonBinder.jsonBinder((Binder)binder).addKeyDeserializerBinding(VariableReferenceExpression.class).to(Serialization.VariableReferenceExpressionDeserializer.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryInfo.class);
        };
        Bootstrap app = new Bootstrap((Iterable)ImmutableList.of((Object)module));
        Injector injector = app.doNotInitializeLogging().quiet().initialize();
        return (JsonCodec)injector.getInstance((Key)new Key<JsonCodec<QueryInfo>>(){});
    }

    private static QueryInfo createQueryInfo() {
        return new QueryInfo(new QueryId("0"), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), QueryState.FINISHED, new MemoryPoolId("memory_pool"), true, URI.create("1"), (List)ImmutableList.of((Object)"number"), "SELECT 1", Optional.of("expanded_query"), Optional.of("prepared_query"), TestQueryStats.EXPECTED, Optional.of("set_catalog"), Optional.of("set_schema"), (Map)ImmutableMap.of((Object)"set_property", (Object)"set_value"), (Set)ImmutableSet.of((Object)"reset_property"), (Map)ImmutableMap.of((Object)"set_roles", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role"))), (Map)ImmutableMap.of((Object)"added_prepared_statement", (Object)"statement"), (Set)ImmutableSet.of((Object)"deallocated_prepared_statement", (Object)"statement"), Optional.of(TransactionId.create()), true, "update_type", Optional.empty(), null, null, (List)ImmutableList.of((Object)new PrestoWarning(new WarningCode(1, "name"), "message")), (Set)ImmutableSet.of((Object)new Input(new ConnectorId("connector"), "schema", "table", Optional.empty(), (List)ImmutableList.of((Object)new Column("name", "type")), Optional.empty(), "")), Optional.empty(), true, Optional.empty(), Optional.of(QueryType.SELECT), Optional.of(ImmutableList.of((Object)new TaskId("0", 1, 1, 1, 0))), Optional.of(ImmutableList.of((Object)new StageId("0", 1))), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), StatsAndCosts.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (List)ImmutableList.of((Object)new CanonicalPlanWithInfo(new CanonicalPlan((PlanNode)new ValuesNode(Optional.empty(), new PlanNodeId("0"), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty()), PlanCanonicalizationStrategy.DEFAULT), new PlanNodeCanonicalInfo("a", (List)ImmutableList.of()))), (Map)ImmutableMap.of(), Optional.of(PrestoSparkExecutionContext.create((int)1024, (int)300, (boolean)true, (boolean)false)));
    }
}

