/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SetSessionTask;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSetSessionTask {
    private static final String CATALOG_NAME = "foo";
    private static final String MUST_BE_POSITIVE = "property must be positive";
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final MetadataManager metadata;
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    public TestSetSessionTask() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager);
        this.metadata.getSessionPropertyManager().addSystemSessionProperty(PropertyMetadata.stringProperty((String)CATALOG_NAME, (String)"test property", null, (boolean)false));
        Catalog bogusTestingCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        ImmutableList sessionProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"bar", (String)"test property", null, (boolean)false), (Object)new PropertyMetadata("positive_property", "property that should be positive", (Type)IntegerType.INTEGER, Integer.class, null, false, value -> TestSetSessionTask.validatePositive(value), value -> value));
        this.metadata.getSessionPropertyManager().addConnectorSessionProperties(bogusTestingCatalog.getConnectorId(), (List)sessionProperties);
        catalogManager.registerCatalog(bogusTestingCatalog);
    }

    private static int validatePositive(Object value) {
        int intValue = ((Number)value).intValue();
        if (intValue < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, MUST_BE_POSITIVE);
        }
        return intValue;
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testSetSession() {
        this.testSetSession((Expression)new StringLiteral("baz"), "baz");
        this.testSetSession((Expression)new FunctionCall(QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral("ban"), (Object)new StringLiteral("ana"))), "banana");
    }

    @Test
    public void testSetSessionWithValidation() {
        this.testSetSessionWithValidation((Expression)new LongLiteral("0"), "0");
        this.testSetSessionWithValidation((Expression)new LongLiteral("2"), "2");
        try {
            this.testSetSessionWithValidation((Expression)new LongLiteral("-1"), "-1");
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((String)e.getMessage(), (String)MUST_BE_POSITIVE);
        }
    }

    @Test
    public void testSetSessionWithParameters() {
        ArrayList<Object> expressionList = new ArrayList<Object>();
        expressionList.add(new StringLiteral("ban"));
        expressionList.add(new Parameter(0));
        this.testSetSessionWithParameters("bar", (Expression)new FunctionCall(QualifiedName.of((String)"concat"), expressionList), "banana", (List<Expression>)ImmutableList.of((Object)new StringLiteral("ana")));
    }

    private void testSetSession(Expression expression, String expectedValue) {
        this.testSetSessionWithParameters("bar", expression, expectedValue, Collections.emptyList());
    }

    private void testSetSessionWithValidation(Expression expression, String expectedValue) {
        this.testSetSessionWithParameters("positive_property", expression, expectedValue, Collections.emptyList());
    }

    private void testSetSessionWithParameters(String property, Expression expression, String expectedValue, List<Expression> parameters) {
        QualifiedName qualifiedPropName = QualifiedName.of((String)CATALOG_NAME, (String[])new String[]{property});
        String sqlString = String.format("set %s = 'old_value'", qualifiedPropName);
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine(sqlString, SessionTestUtils.TEST_SESSION, false, this.transactionManager, this.executor, this.metadata);
        SetSessionTask sessionTask = new SetSessionTask();
        MoreFutures.getFutureValue((Future)sessionTask.execute(new SetSession(qualifiedPropName, expression), this.transactionManager, (Metadata)this.metadata, this.accessControl, stateMachine, parameters));
        Map sessionProperties = stateMachine.getSetSessionProperties();
        Assert.assertEquals((Map)sessionProperties, (Map)ImmutableMap.of((Object)qualifiedPropName.toString(), (Object)expectedValue));
    }
}

