/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.memory.HighMemoryTaskKillerStrategy;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestTaskManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((TaskManagerConfig)ConfigAssertions.recordDefaults(TaskManagerConfig.class)).setInitialSplitsPerNode(Runtime.getRuntime().availableProcessors() * 2).setSplitConcurrencyAdjustmentInterval(new Duration(100.0, TimeUnit.MILLISECONDS)).setStatusRefreshMaxWait(new Duration(1.0, TimeUnit.SECONDS)).setInfoUpdateInterval(new Duration(3.0, TimeUnit.SECONDS)).setInfoRefreshMaxWait(new Duration(0.0, TimeUnit.SECONDS)).setPerOperatorCpuTimerEnabled(true).setTaskCpuTimerEnabled(true).setPerOperatorAllocationTrackingEnabled(false).setTaskAllocationTrackingEnabled(false).setMaxWorkerThreads("2C").setMinDrivers(Runtime.getRuntime().availableProcessors() * 2 * 2).setMinDriversPerTask(3).setMaxDriversPerTask(Integer.MAX_VALUE).setMaxTasksPerStage(Integer.MAX_VALUE).setInfoMaxAge(new Duration(15.0, TimeUnit.MINUTES)).setClientTimeout(new Duration(2.0, TimeUnit.MINUTES)).setMaxIndexMemoryUsage(new DataSize(64.0, DataSize.Unit.MEGABYTE)).setShareIndexLoading(false).setMaxPartialAggregationMemoryUsage(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setMaxLocalExchangeBufferSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setSinkMaxBufferSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setMaxPagePartitioningBufferSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setWriterCount(1).setPartitionedWriterCount(null).setTaskConcurrency(16).setHttpResponseThreads(100).setHttpTimeoutConcurrency(3).setHttpTimeoutThreads(3).setTaskNotificationThreads(5).setTaskYieldThreads(3).setLevelTimeMultiplier(new BigDecimal("2")).setStatisticsCpuTimerEnabled(true).setLegacyLifespanCompletionCondition(false).setTaskPriorityTracking(TaskManagerConfig.TaskPriorityTracking.TASK_FAIR).setInterruptRunawaySplitsTimeout(new Duration(600.0, TimeUnit.SECONDS)).setMemoryBasedSlowDownThreshold(1.0).setHighMemoryTaskKillerEnabled(false).setHighMemoryTaskKillerStrategy(HighMemoryTaskKillerStrategy.FREE_MEMORY_ON_FULL_GC).setHighMemoryTaskKillerGCReclaimMemoryThreshold(Double.valueOf(0.01)).setHighMemoryTaskKillerFrequentFullGCDurationThreshold(new Duration(1.0, TimeUnit.SECONDS)).setHighMemoryTaskKillerHeapMemoryThreshold(Double.valueOf(0.9)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"task.initial-splits-per-node", (Object)"1").put((Object)"task.split-concurrency-adjustment-interval", (Object)"1s").put((Object)"task.status-refresh-max-wait", (Object)"2s").put((Object)"task.info-update-interval", (Object)"2s").put((Object)"experimental.task.info-update-refresh-max-wait", (Object)"3s").put((Object)"task.per-operator-cpu-timer-enabled", (Object)"false").put((Object)"task.cpu-timer-enabled", (Object)"false").put((Object)"task.per-operator-allocation-tracking-enabled", (Object)"true").put((Object)"task.allocation-tracking-enabled", (Object)"true").put((Object)"task.max-index-memory", (Object)"512MB").put((Object)"task.share-index-loading", (Object)"true").put((Object)"task.max-partial-aggregation-memory", (Object)"32MB").put((Object)"task.max-local-exchange-buffer-size", (Object)"33MB").put((Object)"task.max-worker-threads", (Object)"3").put((Object)"task.min-drivers", (Object)"2").put((Object)"task.min-drivers-per-task", (Object)"5").put((Object)"task.max-drivers-per-task", (Object)"13").put((Object)"stage.max-tasks-per-stage", (Object)"999").put((Object)"task.info.max-age", (Object)"22m").put((Object)"task.client.timeout", (Object)"10s").put((Object)"sink.max-buffer-size", (Object)"42MB").put((Object)"driver.max-page-partitioning-buffer-size", (Object)"40MB").put((Object)"task.writer-count", (Object)"4").put((Object)"task.partitioned-writer-count", (Object)"8").put((Object)"task.concurrency", (Object)"8").put((Object)"task.http-response-threads", (Object)"4").put((Object)"task.http-timeout-concurrency", (Object)"2").put((Object)"task.http-timeout-threads", (Object)"10").put((Object)"task.task-notification-threads", (Object)"13").put((Object)"task.task-yield-threads", (Object)"8").put((Object)"task.level-time-multiplier", (Object)"2.1").put((Object)"task.statistics-cpu-timer-enabled", (Object)"false").put((Object)"task.legacy-lifespan-completion-condition", (Object)"true").put((Object)"task.task-priority-tracking", (Object)"QUERY_FAIR").put((Object)"task.interrupt-runaway-splits-timeout", (Object)"599s").put((Object)"experimental.task.memory-based-slowdown-threshold", (Object)"0.9").put((Object)"experimental.task.high-memory-task-killer-enabled", (Object)"true").put((Object)"experimental.task.high-memory-task-killer-strategy", (Object)"FREE_MEMORY_ON_FREQUENT_FULL_GC").put((Object)"experimental.task.high-memory-task-killer-reclaim-memory-threshold", (Object)"0.8").put((Object)"experimental.task.high-memory-task-killer-frequent-full-gc-duration-threshold", (Object)"2s").put((Object)"experimental.task.high-memory-task-killer-heap-memory-threshold", (Object)"0.8").build();
        TaskManagerConfig expected = new TaskManagerConfig().setInitialSplitsPerNode(1).setSplitConcurrencyAdjustmentInterval(new Duration(1.0, TimeUnit.SECONDS)).setStatusRefreshMaxWait(new Duration(2.0, TimeUnit.SECONDS)).setInfoUpdateInterval(new Duration(2.0, TimeUnit.SECONDS)).setInfoRefreshMaxWait(new Duration(3.0, TimeUnit.SECONDS)).setPerOperatorCpuTimerEnabled(false).setTaskCpuTimerEnabled(false).setPerOperatorAllocationTrackingEnabled(true).setTaskAllocationTrackingEnabled(true).setMaxIndexMemoryUsage(new DataSize(512.0, DataSize.Unit.MEGABYTE)).setShareIndexLoading(true).setMaxPartialAggregationMemoryUsage(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setMaxLocalExchangeBufferSize(new DataSize(33.0, DataSize.Unit.MEGABYTE)).setMaxWorkerThreads("3").setMinDrivers(2).setMinDriversPerTask(5).setMaxDriversPerTask(13).setMaxTasksPerStage(999).setInfoMaxAge(new Duration(22.0, TimeUnit.MINUTES)).setClientTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSinkMaxBufferSize(new DataSize(42.0, DataSize.Unit.MEGABYTE)).setMaxPagePartitioningBufferSize(new DataSize(40.0, DataSize.Unit.MEGABYTE)).setWriterCount(4).setPartitionedWriterCount(Integer.valueOf(8)).setTaskConcurrency(8).setHttpResponseThreads(4).setHttpTimeoutConcurrency(2).setHttpTimeoutThreads(10).setTaskNotificationThreads(13).setTaskYieldThreads(8).setLevelTimeMultiplier(new BigDecimal("2.1")).setStatisticsCpuTimerEnabled(false).setLegacyLifespanCompletionCondition(true).setTaskPriorityTracking(TaskManagerConfig.TaskPriorityTracking.QUERY_FAIR).setInterruptRunawaySplitsTimeout(new Duration(599.0, TimeUnit.SECONDS)).setMemoryBasedSlowDownThreshold(0.9).setHighMemoryTaskKillerEnabled(true).setHighMemoryTaskKillerStrategy(HighMemoryTaskKillerStrategy.FREE_MEMORY_ON_FREQUENT_FULL_GC).setHighMemoryTaskKillerGCReclaimMemoryThreshold(Double.valueOf(0.8)).setHighMemoryTaskKillerFrequentFullGCDurationThreshold(new Duration(2.0, TimeUnit.SECONDS)).setHighMemoryTaskKillerHeapMemoryThreshold(Double.valueOf(0.8));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

