/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.drift.codec.internal.reflection.ReflectionThriftCodecFactory;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TFacebookCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoTransportException;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.util.Failures;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestThriftTaskStatus {
    private static final ThriftCodecManager COMPILER_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), new ThriftCodec[0]);
    private static final ThriftCodecManager COMPILER_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), new ThriftCodec[0]);
    private static final ThriftCodec<TaskStatus> COMPILER_READ_CODEC = COMPILER_READ_CODEC_MANAGER.getCodec(TaskStatus.class);
    private static final ThriftCodec<TaskStatus> COMPILER_WRITE_CODEC = COMPILER_WRITE_CODEC_MANAGER.getCodec(TaskStatus.class);
    private static final ThriftCodecManager REFLECTION_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), new ThriftCodec[0]);
    private static final ThriftCodecManager REFLECTION_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), new ThriftCodec[0]);
    private static final ThriftCodec<TaskStatus> REFLECTION_READ_CODEC = REFLECTION_READ_CODEC_MANAGER.getCodec(TaskStatus.class);
    private static final ThriftCodec<TaskStatus> REFLECTION_WRITE_CODEC = REFLECTION_WRITE_CODEC_MANAGER.getCodec(TaskStatus.class);
    private static final TMemoryBuffer transport = new TMemoryBuffer(102400);
    public static final long TASK_INSTANCE_ID_LEAST_SIGNIFICANT_BITS = 123L;
    public static final long TASK_INSTANCE_ID_MOST_SIGNIFICANT_BITS = 456L;
    public static final long VERSION = 789L;
    public static final TaskState RUNNING = TaskState.RUNNING;
    public static final URI SELF_URI = URI.create("fake://task/1");
    public static final Set<Lifespan> LIFESPANS = ImmutableSet.of((Object)Lifespan.taskWide(), (Object)Lifespan.driverGroup((int)100));
    public static final int QUEUED_PARTITIONED_DRIVERS = 100;
    public static final long QUEUED_PARTITIONED_WEIGHT = SplitWeight.rawValueForStandardSplitCount((int)100);
    public static final int RUNNING_PARTITIONED_DRIVERS = 200;
    public static final long RUNNING_PARTITIONED_WEIGHT = SplitWeight.rawValueForStandardSplitCount((int)200);
    public static final double OUTPUT_BUFFER_UTILIZATION = 99.9;
    public static final boolean OUTPUT_BUFFER_OVERUTILIZED = true;
    public static final int PHYSICAL_WRITTEN_DATA_SIZE_IN_BYTES = 0x100000;
    public static final int MEMORY_RESERVATION_IN_BYTES = 0x40000000;
    public static final int SYSTEM_MEMORY_RESERVATION_IN_BYTES = Integer.MIN_VALUE;
    public static final int PEAK_NODE_TOTAL_MEMORY_RESERVATION_IN_BYTES = 0x2A00000;
    public static final int FULL_GC_COUNT = 10;
    public static final int FULL_GC_TIME_IN_MILLIS = 1001;
    public static final int TOTAL_CPU_TIME_IN_NANOS = 1002;
    public static final int TASK_AGE = 1003;
    public static final HostAddress REMOTE_HOST = HostAddress.fromParts((String)"www.fake.invalid", (int)8080);
    private TaskStatus taskStatus;

    @BeforeMethod
    public void setUp() {
        this.taskStatus = this.getTaskStatus();
    }

    @DataProvider
    public Object[][] codecCombinations() {
        return new Object[][]{{COMPILER_READ_CODEC, COMPILER_WRITE_CODEC}, {COMPILER_READ_CODEC, REFLECTION_WRITE_CODEC}, {REFLECTION_READ_CODEC, COMPILER_WRITE_CODEC}, {REFLECTION_READ_CODEC, REFLECTION_WRITE_CODEC}};
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeBinaryProtocol(ThriftCodec<TaskStatus> readCodec, ThriftCodec<TaskStatus> writeCodec) throws Exception {
        TaskStatus taskStatus = this.getRoundTripSerialize(readCodec, writeCodec, TBinaryProtocol::new);
        this.assertSerde(taskStatus);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTCompactProtocol(ThriftCodec<TaskStatus> readCodec, ThriftCodec<TaskStatus> writeCodec) throws Exception {
        TaskStatus taskStatus = this.getRoundTripSerialize(readCodec, writeCodec, TCompactProtocol::new);
        this.assertSerde(taskStatus);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTFacebookCompactProtocol(ThriftCodec<TaskStatus> readCodec, ThriftCodec<TaskStatus> writeCodec) throws Exception {
        TaskStatus taskStatus = this.getRoundTripSerialize(readCodec, writeCodec, TFacebookCompactProtocol::new);
        this.assertSerde(taskStatus);
    }

    private void assertSerde(TaskStatus taskStatus) {
        Assert.assertEquals((long)taskStatus.getTaskInstanceIdLeastSignificantBits(), (long)123L);
        Assert.assertEquals((long)taskStatus.getTaskInstanceIdMostSignificantBits(), (long)456L);
        Assert.assertEquals((long)taskStatus.getVersion(), (long)789L);
        Assert.assertEquals((Object)taskStatus.getState(), (Object)TaskState.RUNNING);
        Assert.assertEquals((Object)taskStatus.getSelf(), (Object)SELF_URI);
        Assert.assertEquals((Set)taskStatus.getCompletedDriverGroups(), LIFESPANS);
        Assert.assertEquals((int)taskStatus.getQueuedPartitionedDrivers(), (int)100);
        Assert.assertEquals((long)taskStatus.getQueuedPartitionedSplitsWeight(), (long)QUEUED_PARTITIONED_WEIGHT);
        Assert.assertEquals((int)taskStatus.getRunningPartitionedDrivers(), (int)200);
        Assert.assertEquals((long)taskStatus.getRunningPartitionedSplitsWeight(), (long)RUNNING_PARTITIONED_WEIGHT);
        Assert.assertEquals((double)taskStatus.getOutputBufferUtilization(), (double)99.9);
        Assert.assertEquals((boolean)taskStatus.isOutputBufferOverutilized(), (boolean)true);
        Assert.assertEquals((long)taskStatus.getPhysicalWrittenDataSizeInBytes(), (long)0x100000L);
        Assert.assertEquals((long)taskStatus.getSystemMemoryReservationInBytes(), (long)Integer.MIN_VALUE);
        Assert.assertEquals((long)taskStatus.getPeakNodeTotalMemoryReservationInBytes(), (long)0x2A00000L);
        Assert.assertEquals((long)taskStatus.getFullGcCount(), (long)10L);
        Assert.assertEquals((long)taskStatus.getFullGcTimeInMillis(), (long)1001L);
        Assert.assertEquals((long)taskStatus.getTotalCpuTimeInNanos(), (long)1002L);
        Assert.assertEquals((long)taskStatus.getTaskAgeInMillis(), (long)1003L);
        List failures = taskStatus.getFailures();
        Assert.assertEquals((int)failures.size(), (int)3);
        ExecutionFailureInfo firstFailure = (ExecutionFailureInfo)failures.get(0);
        Assert.assertEquals((String)firstFailure.getType(), (String)IOException.class.getName());
        Assert.assertEquals((String)firstFailure.getMessage(), (String)"Remote call timed out");
        Assert.assertEquals((Object)firstFailure.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        List suppressedFailures = firstFailure.getSuppressed();
        Assert.assertEquals((int)suppressedFailures.size(), (int)1);
        ExecutionFailureInfo suppressedFailure = (ExecutionFailureInfo)suppressedFailures.get(0);
        Assert.assertEquals((String)suppressedFailure.getType(), (String)IOException.class.getName());
        Assert.assertEquals((String)suppressedFailure.getMessage(), (String)"Thrift call timed out");
        Assert.assertEquals((Object)suppressedFailure.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        ExecutionFailureInfo secondFailure = (ExecutionFailureInfo)failures.get(1);
        Assert.assertEquals((String)secondFailure.getType(), (String)PrestoTransportException.class.getName());
        Assert.assertEquals((String)secondFailure.getMessage(), (String)"Too many requests failed");
        Assert.assertEquals((Object)secondFailure.getRemoteHost(), (Object)REMOTE_HOST);
        Assert.assertEquals((Object)secondFailure.getErrorCode(), (Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED.toErrorCode());
        ExecutionFailureInfo cause = secondFailure.getCause();
        Assert.assertEquals((String)cause.getType(), (String)PrestoException.class.getName());
        Assert.assertEquals((String)cause.getMessage(), (String)"Remote Task Error");
        Assert.assertEquals((Object)cause.getErrorCode(), (Object)StandardErrorCode.REMOTE_TASK_ERROR.toErrorCode());
        ExecutionFailureInfo thirdFailure = (ExecutionFailureInfo)failures.get(2);
        Assert.assertEquals((String)thirdFailure.getType(), (String)ParsingException.class.getName());
        Assert.assertEquals((Object)thirdFailure.getErrorCode(), (Object)StandardErrorCode.SYNTAX_ERROR.toErrorCode());
        Assert.assertEquals((int)thirdFailure.getErrorLocation().getLineNumber(), (int)100);
        Assert.assertEquals((int)thirdFailure.getErrorLocation().getColumnNumber(), (int)2);
    }

    private TaskStatus getRoundTripSerialize(ThriftCodec<TaskStatus> readCodec, ThriftCodec<TaskStatus> writeCodec, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        writeCodec.write((Object)this.taskStatus, (TProtocolWriter)protocol);
        return (TaskStatus)readCodec.read((TProtocolReader)protocol);
    }

    private TaskStatus getTaskStatus() {
        List<ExecutionFailureInfo> executionFailureInfos = this.getExecutionFailureInfos();
        return new TaskStatus(123L, 456L, 789L, RUNNING, SELF_URI, LIFESPANS, executionFailureInfos, 100, 200, 99.9, true, 0x100000L, 0x40000000L, Integer.MIN_VALUE, 0x2A00000L, 10L, 1001L, 1002L, 1003L, QUEUED_PARTITIONED_WEIGHT, RUNNING_PARTITIONED_WEIGHT);
    }

    private List<ExecutionFailureInfo> getExecutionFailureInfos() {
        IOException ioException = new IOException("Remote call timed out");
        ioException.addSuppressed(new IOException("Thrift call timed out"));
        PrestoTransportException prestoTransportException = new PrestoTransportException((ErrorCodeSupplier)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, REMOTE_HOST, "Too many requests failed", (Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR, "Remote Task Error"));
        ParsingException parsingException = new ParsingException("Parsing Exception", new NodeLocation(100, 1));
        return Failures.toFailures((Collection)ImmutableList.of((Object)ioException, (Object)prestoTransportException, (Object)parsingException));
    }
}

