/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.buffer.TestingPagesSerdeFactory;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.LongStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPagesSerde {
    @Test
    public void testRoundTrip() {
        PagesSerde serde = new TestingPagesSerdeFactory().createPagesSerde();
        BlockBuilder expectedBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "alice");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "bob");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "charlie");
        VarcharType.VARCHAR.writeString(expectedBlockBuilder, "dave");
        Block expectedBlock = expectedBlockBuilder.build();
        Page expectedPage = new Page(new Block[]{expectedBlock, expectedBlock, expectedBlock});
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        PagesSerdeUtil.writePages((PagesSerde)serde, (SliceOutput)sliceOutput, (Page[])new Page[]{expectedPage, expectedPage, expectedPage});
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR);
        Iterator pageIterator = PagesSerdeUtil.readPages((PagesSerde)serde, (SliceInput)sliceOutput.slice().getInput());
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)pageIterator.next(), expectedPage);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)pageIterator.next(), expectedPage);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)pageIterator.next(), expectedPage);
        Assert.assertFalse((boolean)pageIterator.hasNext());
    }

    @Test
    public void testBigintSerializedSize() {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 5);
        Page page = new Page(new Block[]{builder.build()});
        int pageSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page);
        Assert.assertEquals((int)pageSize, (int)56);
        BigintType.BIGINT.writeLong(builder, 123L);
        pageSize = 35;
        page = new Page(new Block[]{builder.build()});
        int firstValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page) - pageSize;
        Assert.assertEquals((int)firstValueSize, (int)17);
        BigintType.BIGINT.writeLong(builder, 456L);
        page = new Page(new Block[]{builder.build()});
        int secondValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), page) - (pageSize + firstValueSize);
        Assert.assertEquals((int)secondValueSize, (int)8);
    }

    @Test
    public void testVarcharSerializedSize() {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        Page page = new Page(new Block[]{builder.build()});
        int pageSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page);
        Assert.assertEquals((int)pageSize, (int)52);
        VarcharType.VARCHAR.writeString(builder, "alice");
        page = new Page(new Block[]{builder.build()});
        int firstValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page) - pageSize;
        Assert.assertEquals((int)firstValueSize, (int)9);
        VarcharType.VARCHAR.writeString(builder, "bob");
        page = new Page(new Block[]{builder.build()});
        int secondValueSize = TestPagesSerde.serializedSize((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), page) - (pageSize + firstValueSize);
        Assert.assertEquals((int)secondValueSize, (int)7);
    }

    @Test
    public void testRoundTripSizeForCompactPageStaysWithinTwentyPercent() {
        PagesSerde serde = new TestingPagesSerdeFactory().createPagesSerde();
        BlockBuilder variableWidthBlockBuilder1 = VarcharType.VARCHAR.createBlockBuilder(null, 128);
        BlockBuilder variableWidthBlockBuilder2 = VarcharType.VARCHAR.createBlockBuilder(null, 256);
        BlockBuilder bigintBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 128);
        Block emptyVariableWidthBlock = VarcharType.VARCHAR.createBlockBuilder(null, 128).build();
        LongStream.range(0L, 100L).forEach(value -> {
            VarcharType.VARCHAR.writeString(variableWidthBlockBuilder1, UUID.randomUUID().toString());
            VarcharType.VARCHAR.writeString(variableWidthBlockBuilder2, UUID.randomUUID().toString());
            VarcharType.VARCHAR.writeString(variableWidthBlockBuilder2, UUID.randomUUID().toString());
            BigintType.BIGINT.writeLong(bigintBlockBuilder, value);
        });
        Page compactPage = new Page(new Block[]{emptyVariableWidthBlock, variableWidthBlockBuilder1.build(), variableWidthBlockBuilder2.build(), bigintBlockBuilder.build()}).compact();
        Page deserializedPage = serde.deserialize(serde.serialize(compactPage));
        double expectedMaxSize = (double)compactPage.getRetainedSizeInBytes() * 1.2;
        double actualSize = deserializedPage.getRetainedSizeInBytes();
        Assert.assertTrue((actualSize < expectedMaxSize ? 1 : 0) != 0, (String)"Expected round trip size difference less than 20% of original page");
    }

    private static int serializedSize(List<? extends Type> types, Page expectedPage) {
        PagesSerde serde = new TestingPagesSerdeFactory().createPagesSerde();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        PagesSerdeUtil.writePages((PagesSerde)serde, (SliceOutput)sliceOutput, (Page[])new Page[]{expectedPage});
        Slice slice = sliceOutput.slice();
        Iterator pageIterator = PagesSerdeUtil.readPages((PagesSerde)serde, (SliceInput)slice.getInput());
        if (pageIterator.hasNext()) {
            PageAssertions.assertPageEquals(types, (Page)pageIterator.next(), expectedPage);
        } else {
            Assert.assertEquals((int)expectedPage.getPositionCount(), (int)0);
        }
        Assert.assertFalse((boolean)pageIterator.hasNext());
        return slice.length();
    }
}

