/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCPoint;
import com.facebook.presto.geospatial.GeoFunctions;
import com.facebook.presto.geospatial.GeometryBenchmarkUtils;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSTContains {
    @Benchmark
    public Object stContainsInnerPointSimpleGeometry(BenchmarkData data) {
        return GeoFunctions.stContains((Slice)data.simpleGeometry, (Slice)data.innerPoint);
    }

    @Benchmark
    public Object stContainsOuterPointInEnvelopeSimpleGeometry(BenchmarkData data) {
        return GeoFunctions.stContains((Slice)data.simpleGeometry, (Slice)data.outerPointInEnvelope);
    }

    @Benchmark
    public Object stContainsOuterPointNotInEnvelopeSimpleGeometry(BenchmarkData data) {
        return GeoFunctions.stContains((Slice)data.simpleGeometry, (Slice)data.outerPointNotInEnvelope);
    }

    @Benchmark
    public Object deserializeSimpleGeometry(BenchmarkData data) {
        return EsriGeometrySerde.deserialize((Slice)data.simpleGeometry);
    }

    @Benchmark
    public Object deserializeEnvelopeSimpleGeometry(BenchmarkData data) {
        return EsriGeometrySerde.deserializeEnvelope((Slice)data.simpleGeometry);
    }

    @Benchmark
    public Object stContainsInnerPoint(BenchmarkData data) {
        return GeoFunctions.stContains((Slice)data.geometry, (Slice)data.innerPoint);
    }

    @Benchmark
    public Object stContainsInnerPointDeserialized(BenchmarkData data) {
        return data.ogcGeometry.contains((OGCGeometry)data.innerOgcPoint);
    }

    @Benchmark
    public Object stContainsOuterPointInEnvelope(BenchmarkData data) {
        return GeoFunctions.stContains((Slice)data.geometry, (Slice)data.outerPointInEnvelope);
    }

    @Benchmark
    public Object stContainsOuterPointInEnvelopeDeserialized(BenchmarkData data) {
        return data.ogcGeometry.contains((OGCGeometry)data.outerOgcPointInEnvelope);
    }

    @Benchmark
    public Object stContainsOuterPointNotInEnvelope(BenchmarkData data) {
        return GeoFunctions.stContains((Slice)data.geometry, (Slice)data.outerPointNotInEnvelope);
    }

    @Benchmark
    public Object stContainsOuterPointNotInEnvelopeDeserialized(BenchmarkData data) {
        return data.ogcGeometry.contains((OGCGeometry)data.outerOgcPointNotInEnvelope);
    }

    @Benchmark
    public Object benchmarkDeserialize(BenchmarkData data) {
        return EsriGeometrySerde.deserialize((Slice)data.geometry);
    }

    @Benchmark
    public Object benchmarkDeserializeEnvelope(BenchmarkData data) {
        return EsriGeometrySerde.deserializeEnvelope((Slice)data.geometry);
    }

    public static void main(String[] args) throws IOException, RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkSTContains benchmark = new BenchmarkSTContains();
        if (!((Boolean)benchmark.stContainsInnerPoint(data)).booleanValue()) {
            throw new IllegalStateException("ST_Contains for inner point expected to return true, got false.");
        }
        if (((Boolean)benchmark.stContainsOuterPointInEnvelope(data)).booleanValue()) {
            throw new IllegalStateException("ST_Contains for outer point expected to return false, got true.");
        }
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkSTContains.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Slice geometry;
        private Slice simpleGeometry;
        private Slice innerPoint;
        private Slice outerPointInEnvelope;
        private Slice outerPointNotInEnvelope;
        private OGCGeometry ogcGeometry;
        private OGCPoint innerOgcPoint;
        private OGCPoint outerOgcPointInEnvelope;
        private OGCPoint outerOgcPointNotInEnvelope;

        @Setup
        public void setup() throws IOException {
            this.geometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)GeometryBenchmarkUtils.loadPolygon("large_polygon.txt")));
            this.simpleGeometry = GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)"POLYGON ((16.5 54, 16.5 54.1, 16.8 54.1, 16.8 54))"));
            this.innerPoint = GeoFunctions.stPoint((double)16.6, (double)54.0167);
            this.outerPointInEnvelope = GeoFunctions.stPoint((double)16.6667, (double)54.05);
            this.outerPointNotInEnvelope = GeoFunctions.stPoint((double)16.6333, (double)54.2);
            this.ogcGeometry = EsriGeometrySerde.deserialize((Slice)this.geometry);
            this.innerOgcPoint = (OGCPoint)EsriGeometrySerde.deserialize((Slice)this.innerPoint);
            this.outerOgcPointInEnvelope = (OGCPoint)EsriGeometrySerde.deserialize((Slice)this.outerPointInEnvelope);
            this.outerOgcPointNotInEnvelope = (OGCPoint)EsriGeometrySerde.deserialize((Slice)this.outerPointNotInEnvelope);
        }
    }
}

