/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.geospatial.BingTile;
import com.facebook.presto.geospatial.type.BingTileType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.ApplyFunction;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.util.ResourceFileUtils;
import com.google.common.collect.ImmutableList;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestBingTileFunctions
extends AbstractTestFunctions {
    private JavaAggregationFunctionImplementation approxDistinct;

    @BeforeClass
    protected void registerFunctions() {
        this.functionAssertions.getMetadata().registerBuiltInFunctions((List)ImmutableList.of((Object)ApplyFunction.APPLY_FUNCTION));
        FunctionAndTypeManager functionAndTypeManager = this.functionAssertions.getMetadata().getFunctionAndTypeManager();
        this.approxDistinct = functionAndTypeManager.getJavaAggregateFunctionImplementation(functionAndTypeManager.lookupFunction("approx_distinct", TypeSignatureProvider.fromTypes((Type[])new Type[]{BingTileType.BING_TILE})));
    }

    @Test
    public void testBingTileCast() {
        this.assertBingTileCast(0, 0, 0);
        this.assertBingTileCast(0, 0, 1);
        this.assertBingTileCast(0, 0, 10);
        this.assertBingTileCast(125, 900, 10);
        this.assertBingTileCast(0, 0, 23);
        this.assertBingTileCast(0x7FFFFF, 0x7FFFFF, 23);
        this.assertBingTileCastInvalid(0x10020000100L);
        this.assertBingTileCastInvalid(0x400000000000000L);
    }

    private void assertBingTileCast(int x, int y, int zoom) {
        BingTile tile = BingTile.fromCoordinates((int)x, (int)y, (int)zoom);
        this.assertFunction(String.format("cast(cast(%s as bigint) as bingtile)", tile.encode()), (Type)BingTileType.BING_TILE, tile);
        this.assertFunction(String.format("cast(bing_tile('%s') as bigint)", tile.toQuadKey()), (Type)BigintType.BIGINT, tile.encode());
    }

    private void assertBingTileCastInvalid(long encoding) {
        this.assertInvalidCast(String.format("cast(cast(%s as bigint) as bingtile)", encoding), String.format("Invalid bigint tile encoding: %s", encoding));
    }

    @Test
    public void testArrayOfBingTiles() throws Exception {
        this.assertFunction("array [bing_tile(1, 2, 10), bing_tile(3, 4, 11)]", (Type)new ArrayType((Type)BingTileType.BING_TILE), ImmutableList.of((Object)BingTile.fromCoordinates((int)1, (int)2, (int)10), (Object)BingTile.fromCoordinates((int)3, (int)4, (int)11)));
    }

    @Test
    public void testBingTile() {
        this.assertFunction("bing_tile_quadkey(bing_tile(''))", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("bing_tile_quadkey(bing_tile('213'))", (Type)VarcharType.VARCHAR, "213");
        this.assertFunction("bing_tile_quadkey(bing_tile('123030123010121'))", (Type)VarcharType.VARCHAR, "123030123010121");
        this.assertFunction("bing_tile_quadkey(bing_tile(0, 0, 0))", (Type)VarcharType.VARCHAR, "");
        this.assertFunction("bing_tile_quadkey(bing_tile(3, 5, 3))", (Type)VarcharType.VARCHAR, "213");
        this.assertFunction("bing_tile_quadkey(bing_tile(21845, 13506, 15))", (Type)VarcharType.VARCHAR, "123030123010121");
        this.assertInvalidFunction("bing_tile('test')", "Invalid QuadKey digit sequence: test");
        this.assertInvalidFunction("bing_tile('12345')", "Invalid QuadKey digit sequence: 12345");
        this.assertInvalidFunction("bing_tile('101010101010101010101010101010100101010101001010')", "QuadKey must be 23 characters or less");
        this.assertInvalidFunction("bing_tile(10, 2, 3)", "XY coordinates for a Bing tile at zoom level 3 must be within [0, 8) range");
        this.assertInvalidFunction("bing_tile(2, 10, 3)", "XY coordinates for a Bing tile at zoom level 3 must be within [0, 8) range");
        this.assertInvalidFunction("bing_tile(2, 7, 37)", "Zoom level must be <= 23");
    }

    @Test
    public void testBingTileChildren() {
        this.assertBingTileChildren("0", OptionalInt.empty(), (List<String>)ImmutableList.of((Object)"00", (Object)"01", (Object)"02", (Object)"03"));
        this.assertBingTileChildren("0", OptionalInt.of(3), (List<String>)ImmutableList.of((Object)"000", (Object)"001", (Object)"002", (Object)"003", (Object)"010", (Object)"011", (Object)"012", (Object)"013", (Object)"020", (Object)"021", (Object)"022", (Object)"023", (Object[])new String[]{"030", "031", "032", "033"}));
        this.assertInvalidFunction("bing_tile_children(bing_tile('0'), 0)", "newZoom must be greater than or equal to current zoom 1: 0");
        this.assertInvalidFunction(String.format("bing_tile_children(bing_tile('0'), %s)", 24), String.format("newZoom must be less than or equal to %s: %s", 23, 24));
    }

    private void assertBingTileChildren(String quadkey, OptionalInt newZoom, List<String> childQuadkeys) {
        String children = newZoom.isPresent() ? String.format("bing_tile_children(bing_tile('%s'), %s)", quadkey, newZoom.getAsInt()) : String.format("bing_tile_children(bing_tile('%s'))", quadkey);
        this.assertFunction(String.format("array_sort(transform(%s, x -> bing_tile_quadkey(x)))", children), (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.sortedCopyOf(childQuadkeys));
    }

    @Test
    public void testBingTileParent() {
        this.assertBingTileParent("03", OptionalInt.empty(), "0");
        this.assertBingTileParent("0123", OptionalInt.of(2), "01");
        this.assertInvalidFunction("bing_tile_parent(bing_tile('0'), 2)", "newZoom must be less than or equal to current zoom 1: 2");
        this.assertInvalidFunction(String.format("bing_tile_parent(bing_tile('0'), %s)", -1), "newZoom must be greater than or equal to 0: -1");
    }

    private void assertBingTileParent(String quadkey, OptionalInt newZoom, String parentQuadkey) {
        String parent = newZoom.isPresent() ? String.format("bing_tile_parent(bing_tile('%s'), %s)", quadkey, newZoom.getAsInt()) : String.format("bing_tile_parent(bing_tile('%s'))", quadkey);
        this.assertFunction(String.format("bing_tile_quadkey(%s)", parent), (Type)VarcharType.VARCHAR, parentQuadkey);
    }

    @Test
    public void testPointToBingTile() {
        this.assertFunction("bing_tile_at(30.12, 60, 15)", (Type)BingTileType.BING_TILE, BingTile.fromCoordinates((int)21845, (int)13506, (int)15));
        this.assertFunction("bing_tile_at(0, -0.002, 1)", (Type)BingTileType.BING_TILE, BingTile.fromCoordinates((int)0, (int)1, (int)1));
        this.assertFunction("bing_tile_at(1e0/512, 0, 1)", (Type)BingTileType.BING_TILE, BingTile.fromCoordinates((int)1, (int)0, (int)1));
        this.assertFunction("bing_tile_at(1e0/512, 0, 9)", (Type)BingTileType.BING_TILE, BingTile.fromCoordinates((int)256, (int)255, (int)9));
        this.assertInvalidFunction("bing_tile_at(30.12, 600, 15)", "Longitude must be between -180.0 and 180.0");
        this.assertInvalidFunction("bing_tile_at(300.12, 60, 15)", "Latitude must be between -85.05112878 and 85.05112878");
        this.assertInvalidFunction("bing_tile_at(30.12, 60, -1)", "Zoom level must be >= 0");
        this.assertInvalidFunction("bing_tile_at(30.12, 60, 40)", "Zoom level must be <= 23");
    }

    @Test
    public void testBingTileCoordinates() {
        this.assertFunction("bing_tile_coordinates(bing_tile('213')).x", (Type)IntegerType.INTEGER, 3);
        this.assertFunction("bing_tile_coordinates(bing_tile('213')).y", (Type)IntegerType.INTEGER, 5);
        this.assertFunction("bing_tile_coordinates(bing_tile('123030123010121')).x", (Type)IntegerType.INTEGER, 21845);
        this.assertFunction("bing_tile_coordinates(bing_tile('123030123010121')).y", (Type)IntegerType.INTEGER, 13506);
        this.assertCachedInstanceHasBoundedRetainedSize("bing_tile_coordinates(bing_tile('213'))");
    }

    private void assertBingTilesAroundWithRadius(double latitude, double longitude, int zoomLevel, double radius, String ... expectedQuadKeys) {
        this.assertFunction(String.format("transform(bing_tiles_around(%s, %s, %s, %s), x -> bing_tile_quadkey(x))", latitude, longitude, zoomLevel, radius), (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.copyOf((Object[])expectedQuadKeys));
    }

    @Test
    public void testBingTilesAroundWithRadius() {
        this.assertBingTilesAroundWithRadius(30.12, 60.0, 1, 1000.0, "1");
        this.assertBingTilesAroundWithRadius(30.12, 60.0, 15, 0.5, "123030123010120", "123030123010121", "123030123010123");
        this.assertBingTilesAroundWithRadius(30.12, 60.0, 19, 0.05, "1230301230101212120", "1230301230101212121", "1230301230101212130", "1230301230101212103", "1230301230101212123", "1230301230101212112", "1230301230101212102");
    }

    @Test
    public void testBingTilesAroundCornerWithRadius() {
        this.assertBingTilesAroundWithRadius(-85.05112878, -180.0, 1, 500.0, "3", "2");
        this.assertBingTilesAroundWithRadius(-85.05112878, -180.0, 5, 200.0, "33332", "33333", "22222", "22223", "22220", "22221", "33330", "33331");
        this.assertBingTilesAroundWithRadius(-85.05112878, -180.0, 15, 0.2, "333333333333332", "333333333333333", "222222222222222", "222222222222223", "222222222222220", "222222222222221", "333333333333330", "333333333333331");
        this.assertBingTilesAroundWithRadius(-85.05112878, -180.0, 4, 500.0, "3323", "3332", "3333", "2222", "2223", "2232", "2220", "2221", "3330", "3331");
        this.assertBingTilesAroundWithRadius(-85.05112878, 180.0, 4, 500.0, "3323", "3332", "3333", "2222", "2223", "2232", "3331", "2221", "2220", "3330");
        this.assertBingTilesAroundWithRadius(85.05112878, -180.0, 4, 500.0, "1101", "1110", "1111", "0000", "0001", "0010", "0002", "0003", "1112", "1113");
        this.assertBingTilesAroundWithRadius(85.05112878, 180.0, 4, 500.0, "1101", "1110", "1111", "0000", "0001", "0010", "1113", "0003", "0002", "1112");
    }

    @Test
    public void testBingTilesAroundEdgeWithRadius() {
        this.assertBingTilesAroundWithRadius(-85.05112878, 0.0, 3, 300.0, "233", "322");
        this.assertBingTilesAroundWithRadius(-85.05112878, 0.0, 12, 1.0, "233333333332", "233333333333", "322222222222", "322222222223", "322222222220", "233333333331");
        this.assertBingTilesAroundWithRadius(-85.05112878, 0.0, 4, 100.0, "2333", "3222");
        this.assertBingTilesAroundWithRadius(85.05112878, 0.0, 4, 100.0, "0111", "1000");
        this.assertBingTilesAroundWithRadius(0.0, 180.0, 4, 100.0, "3111", "2000", "1333", "0222");
        this.assertBingTilesAroundWithRadius(0.0, -180.0, 4, 100.0, "3111", "2000", "0222", "1333");
    }

    @Test
    public void testBingTilesWithRadiusBadInput() {
        this.assertInvalidFunction("bing_tiles_around(30.12, 60.0, 1, -1)", "Radius must be >= 0");
        this.assertInvalidFunction("bing_tiles_around(30.12, 60.0, 1, 2000)", "Radius must be <= 1,000 km");
        this.assertInvalidFunction("bing_tiles_around(30.12, 60.0, 20, 100)", "The number of tiles covering input rectangle exceeds the limit of 1M. Number of tiles: 36699364. Radius: 100.0 km. Zoom level: 20.");
    }

    @Test
    public void testBingTilesAround() {
        this.assertFunction("transform(bing_tiles_around(30.12, 60, 1), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"0", (Object)"2", (Object)"1", (Object)"3"));
        this.assertFunction("transform(bing_tiles_around(30.12, 60, 15), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"123030123010102", (Object)"123030123010120", (Object)"123030123010122", (Object)"123030123010103", (Object)"123030123010121", (Object)"123030123010123", (Object)"123030123010112", (Object)"123030123010130", (Object)"123030123010132"));
        this.assertFunction("transform(bing_tiles_around(30.12, 60, 23), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"12303012301012121210122", (Object)"12303012301012121210300", (Object)"12303012301012121210302", (Object)"12303012301012121210123", (Object)"12303012301012121210301", (Object)"12303012301012121210303", (Object)"12303012301012121210132", (Object)"12303012301012121210310", (Object)"12303012301012121210312"));
    }

    @Test
    public void testBingTilesAroundCorner() {
        this.assertFunction("transform(bing_tiles_around(-85.05112878, -180, 1), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"0", (Object)"2", (Object)"1", (Object)"3"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, -180, 3), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"220", (Object)"222", (Object)"221", (Object)"223"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, -180, 15), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"222222222222220", (Object)"222222222222222", (Object)"222222222222221", (Object)"222222222222223"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, -180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"20", (Object)"22", (Object)"21", (Object)"23"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"30", (Object)"32", (Object)"31", (Object)"33"));
        this.assertFunction("transform(bing_tiles_around(85.05112878, -180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"00", (Object)"02", (Object)"01", (Object)"03"));
        this.assertFunction("transform(bing_tiles_around(85.05112878, 180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"10", (Object)"12", (Object)"11", (Object)"13"));
    }

    @Test
    public void testBingTilesAroundEdge() {
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 0, 1), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"0", (Object)"2", (Object)"1", (Object)"3"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 0, 3), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"231", (Object)"233", (Object)"320", (Object)"322", (Object)"321", (Object)"323"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 0, 15), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"233333333333331", (Object)"233333333333333", (Object)"322222222222220", (Object)"322222222222222", (Object)"322222222222221", (Object)"322222222222223"));
        this.assertFunction("transform(bing_tiles_around(-85.05112878, 0, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"21", (Object)"23", (Object)"30", (Object)"32", (Object)"31", (Object)"33"));
        this.assertFunction("transform(bing_tiles_around(85.05112878, 0, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"01", (Object)"03", (Object)"10", (Object)"12", (Object)"11", (Object)"13"));
        this.assertFunction("transform(bing_tiles_around(0, 180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"12", (Object)"30", (Object)"32", (Object)"13", (Object)"31", (Object)"33"));
        this.assertFunction("transform(bing_tiles_around(0, -180, 2), x -> bing_tile_quadkey(x))", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"02", (Object)"20", (Object)"22", (Object)"03", (Object)"21", (Object)"23"));
    }

    @Test
    public void testBingTileZoomLevel() {
        this.assertFunction("bing_tile_zoom_level(bing_tile('213'))", (Type)TinyintType.TINYINT, (byte)3);
        this.assertFunction("bing_tile_zoom_level(bing_tile('123030123010121'))", (Type)TinyintType.TINYINT, (byte)15);
    }

    @Test
    public void testBingTilePolygon() {
        this.assertFunction("ST_AsText(bing_tile_polygon(bing_tile('123030123010121')))", (Type)VarcharType.VARCHAR, "POLYGON ((59.996337890625 30.11662158281937, 59.996337890625 30.12612436422458, 60.00732421875 30.12612436422458, 60.00732421875 30.11662158281937, 59.996337890625 30.11662158281937))");
        this.assertFunction("ST_AsText(ST_Centroid(bing_tile_polygon(bing_tile('123030123010121'))))", (Type)VarcharType.VARCHAR, "POINT (60.0018310546875 30.12137297352197)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(1, 1, 1)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(3, 3, 2)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(7, 7, 3)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(15, 15, 4)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(31, 31, 5)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (180 -85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 1)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(1, 1, 2)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(3, 3, 3)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(7, 7, 4)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(15, 15, 5)), g -> ST_Point(ST_XMax(g), ST_YMin(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(1, 1, 1)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(2, 2, 2)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(4, 4, 3)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(8, 8, 4)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(16, 16, 5)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (0 0)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 1)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 2)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 3)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 4)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
        this.assertFunction("ST_AsText(apply(bing_tile_polygon(bing_tile(0, 0, 5)), g -> ST_Point(ST_XMin(g), ST_YMax(g))))", (Type)VarcharType.VARCHAR, "POINT (-180 85.05112877980659)");
    }

    @Test
    public void testGeometryToDissolvedBingTiles() {
        this.assertGeometryToDissolvedBingTiles("POINT EMPTY", 0, Collections.emptyList());
        this.assertGeometryToDissolvedBingTiles("POINT EMPTY", 10, Collections.emptyList());
        this.assertGeometryToDissolvedBingTiles("POINT EMPTY", 23, Collections.emptyList());
        this.assertGeometryToDissolvedBingTiles("POLYGON EMPTY", 10, Collections.emptyList());
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION EMPTY", 10, Collections.emptyList());
        this.assertGeometryToDissolvedBingTiles("POINT (0 0)", 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s 0)", -180.0), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s 0)", 180.0), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (0 %s)", -85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (0 %s)", 85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s %s)", -180.0, -85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s %s)", -180.0, 85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s %s)", 180.0, 85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s %s)", 180.0, -85.05112878), 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles("POINT (0 0)", 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s 0)", -180.0), 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s 0)", 180.0), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (0 %s)", -85.05112878), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (0 %s)", 85.05112878), 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s %s)", -180.0, -85.05112878), 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s %s)", -180.0, 85.05112878), 1, (List<String>)ImmutableList.of((Object)"0"));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s %s)", 180.0, 85.05112878), 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertGeometryToDissolvedBingTiles(String.format("POINT (%s %s)", 180.0, -85.05112878), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToDissolvedBingTiles("LINESTRING (-1 0, -2 0)", 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertGeometryToDissolvedBingTiles("LINESTRING (1 0, 2 0)", 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToDissolvedBingTiles("LINESTRING (0 -1, 0 -2)", 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToDissolvedBingTiles("LINESTRING (0 1, 0 2)", 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertGeometryToDissolvedBingTiles(String.format("LINESTRING (%s 1, %s 2)", -180.0, -180.0), 1, (List<String>)ImmutableList.of((Object)"0"));
        this.assertGeometryToDissolvedBingTiles(String.format("LINESTRING (%s -1, %s -2)", -180.0, -180.0), 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertGeometryToDissolvedBingTiles(String.format("LINESTRING (%s 1, %s 2)", 180.0, 180.0), 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertGeometryToDissolvedBingTiles(String.format("LINESTRING (%s -1, %s -2)", 180.0, 180.0), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToDissolvedBingTiles("POINT (60 30.12)", 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToDissolvedBingTiles("POINT (60 30.12)", 10, (List<String>)ImmutableList.of((Object)"1230301230"));
        this.assertGeometryToDissolvedBingTiles("POINT (60 30.12)", 15, (List<String>)ImmutableList.of((Object)"123030123010121"));
        this.assertGeometryToDissolvedBingTiles("POINT (60 30.12)", 16, (List<String>)ImmutableList.of((Object)"1230301230101212"));
        this.assertGeometryToDissolvedBingTiles("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))", 6, (List<String>)ImmutableList.of((Object)"12222", (Object)"300000", (Object)"300001"));
        this.assertGeometryToDissolvedBingTiles("POLYGON ((0 0, 0 10, 10 10, 0 0))", 6, (List<String>)ImmutableList.of((Object)"122220", (Object)"122222", (Object)"122221", (Object)"300000"));
        this.assertGeometryToDissolvedBingTiles("POLYGON ((10 10, -10 10, -20 -15, 10 10))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122"));
        this.assertGeometryToDissolvedBingTiles("POLYGON ((10 10, -10 10, -20 -15, 10 10))", 6, (List<String>)ImmutableList.of((Object)"211102", (Object)"211120", (Object)"033321", (Object)"033323", (Object)"211101", (Object)"211103", (Object)"211121", (Object)"03333", (Object)"211110", (Object)"211112", (Object)"211111", (Object)"122220", (Object[])new String[]{"122222", "122221"}));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12))", 10, (List<String>)ImmutableList.of((Object)"1230301230"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12))", 15, (List<String>)ImmutableList.of((Object)"123030123010121"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12), POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122", (Object)"123"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12), LINESTRING (61 31, 61.01 31.01), POLYGON EMPTY)", 15, (List<String>)ImmutableList.of((Object)"123030123010121", (Object)"123030112310200", (Object)"123030112310202", (Object)"123030112310201"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12))", 10, (List<String>)ImmutableList.of((Object)"1230301230"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12))", 15, (List<String>)ImmutableList.of((Object)"123030123010121"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12), POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122", (Object)"123"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12), LINESTRING (61 31, 61.01 31.01), POLYGON EMPTY)", 15, (List<String>)ImmutableList.of((Object)"123030123010121", (Object)"123030112310200", (Object)"123030112310202", (Object)"123030112310201"));
        this.assertGeometryToDissolvedBingTiles("GEOMETRYCOLLECTION (POINT (0.1 0.1), POINT(0.1 -0.1), POINT(-0.1 -0.1), POINT(-0.1 0.1))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"122", (Object)"211", (Object)"300"));
    }

    private void assertGeometryToDissolvedBingTiles(String wkt, int maxZoomLevel, List<String> expectedQuadKeys) {
        expectedQuadKeys = ImmutableList.sortedCopyOf(expectedQuadKeys);
        this.assertFunction(String.format("array_sort(transform(geometry_to_dissolved_bing_tiles(ST_GeometryFromText('%s'), %s), x -> bing_tile_quadkey(x)))", wkt, maxZoomLevel), (Type)new ArrayType((Type)VarcharType.VARCHAR), expectedQuadKeys);
    }

    @Test
    public void testLargeGeometryToBingTiles() throws Exception {
        Path filePath = Paths.get(ResourceFileUtils.getResourceFile("large_polygon.txt").getAbsolutePath(), new String[0]);
        List<String> lines = Files.readAllLines(filePath);
        for (String line : lines) {
            String[] parts = line.split("\\|");
            String wkt = parts[0];
            int zoomLevel = Integer.parseInt(parts[1]);
            long tileCount = Long.parseLong(parts[2]);
            this.assertFunction("cardinality(geometry_to_bing_tiles(ST_GeometryFromText('" + wkt + "'), " + zoomLevel + "))", (Type)BigintType.BIGINT, tileCount);
        }
    }

    @Test
    public void testGeometryToBingTiles() throws Exception {
        this.assertGeometryToBingTiles("POINT (0 0)", 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToBingTiles(String.format("POINT (%s 0)", -180.0), 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertGeometryToBingTiles(String.format("POINT (%s 0)", 180.0), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToBingTiles(String.format("POINT (0 %s)", -85.05112878), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToBingTiles(String.format("POINT (0 %s)", 85.05112878), 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertGeometryToBingTiles(String.format("POINT (%s %s)", -180.0, -85.05112878), 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertGeometryToBingTiles(String.format("POINT (%s %s)", -180.0, 85.05112878), 1, (List<String>)ImmutableList.of((Object)"0"));
        this.assertGeometryToBingTiles(String.format("POINT (%s %s)", 180.0, 85.05112878), 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertGeometryToBingTiles(String.format("POINT (%s %s)", 180.0, -85.05112878), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToBingTiles("LINESTRING (-1 0, -2 0)", 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertGeometryToBingTiles("LINESTRING (1 0, 2 0)", 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToBingTiles("LINESTRING (0 -1, 0 -2)", 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertGeometryToBingTiles("LINESTRING (0 1, 0 2)", 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertGeometryToBingTiles(String.format("LINESTRING (%s 1, %s 2)", -180.0, -180.0), 1, (List<String>)ImmutableList.of((Object)"0"));
        this.assertGeometryToBingTiles(String.format("LINESTRING (%s -1, %s -2)", -180.0, -180.0), 1, (List<String>)ImmutableList.of((Object)"2"));
        this.assertGeometryToBingTiles(String.format("LINESTRING (%s 1, %s 2)", 180.0, 180.0), 1, (List<String>)ImmutableList.of((Object)"1"));
        this.assertGeometryToBingTiles(String.format("LINESTRING (%s -1, %s -2)", 180.0, 180.0), 1, (List<String>)ImmutableList.of((Object)"3"));
        this.assertPointInCovering("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))", 6, 0.0, 0.0);
        this.assertPointInCovering("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))", 6, 0.0, 10.0);
        this.assertPointInCovering("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))", 6, 10.0, 10.0);
        this.assertPointInCovering("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))", 6, 10.0, 0.0);
        this.assertGeometryToBingTiles("POINT (60 30.12)", 0, (List<String>)ImmutableList.of((Object)""));
        this.assertGeometryToBingTiles("POINT (60 30.12)", 10, (List<String>)ImmutableList.of((Object)"1230301230"));
        this.assertGeometryToBingTiles("POINT (60 30.12)", 15, (List<String>)ImmutableList.of((Object)"123030123010121"));
        this.assertGeometryToBingTiles("POINT (60 30.12)", 16, (List<String>)ImmutableList.of((Object)"1230301230101212"));
        this.assertGeometryToBingTiles("POLYGON ((0 0, 0 10, 10 10, 10 0, 0 0))", 6, (List<String>)ImmutableList.of((Object)"122220", (Object)"122222", (Object)"122221", (Object)"122223", (Object)"300000", (Object)"300001"));
        this.assertGeometryToBingTiles("POLYGON ((0 0, 0 10, 10 10, 0 0))", 6, (List<String>)ImmutableList.of((Object)"122220", (Object)"122222", (Object)"122221", (Object)"300000"));
        this.assertGeometryToBingTiles("POLYGON ((10 10, -10 10, -20 -15, 10 10))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122"));
        this.assertGeometryToBingTiles("POLYGON ((10 10, -10 10, -20 -15, 10 10))", 6, (List<String>)ImmutableList.of((Object)"211102", (Object)"211120", (Object)"033321", (Object)"033323", (Object)"211101", (Object)"211103", (Object)"211121", (Object)"033330", (Object)"033332", (Object)"211110", (Object)"211112", (Object)"033331", (Object[])new String[]{"033333", "211111", "122220", "122222", "122221"}));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12))", 10, (List<String>)ImmutableList.of((Object)"1230301230"));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12))", 15, (List<String>)ImmutableList.of((Object)"123030123010121"));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122"));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12), POLYGON ((10 10, -10 10, -20 -15, 10 10)))", 3, (List<String>)ImmutableList.of((Object)"033", (Object)"211", (Object)"122", (Object)"123"));
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION (POINT (60 30.12), LINESTRING (61 31, 61.01 31.01), POLYGON EMPTY)", 15, (List<String>)ImmutableList.of((Object)"123030123010121", (Object)"123030112310200", (Object)"123030112310202", (Object)"123030112310201"));
        this.assertToBingTiles("bing_tile_polygon(bing_tile('1230301230'))", 10, (List<String>)ImmutableList.of((Object)"1230301230", (Object)"1230301231", (Object)"1230301232", (Object)"1230301233"));
        this.assertToBingTiles("bing_tile_polygon(bing_tile('1230301230'))", 11, (List<String>)ImmutableList.of((Object)"12303012300", (Object)"12303012302", (Object)"12303012301", (Object)"12303012303", (Object)"12303012310", (Object)"12303012312", (Object)"12303012320", (Object)"12303012321", (Object)"12303012330"));
        this.assertToBingTiles("ST_Envelope(ST_GeometryFromText('LINESTRING (59.765625 29.84064389983442, 60.2 30.14512718337612)'))", 10, (List<String>)ImmutableList.of((Object)"1230301230", (Object)"1230301231", (Object)"1230301232", (Object)"1230301233"));
        this.assertGeometryToBingTiles("POINT EMPTY", 10, Collections.emptyList());
        this.assertGeometryToBingTiles("POLYGON EMPTY", 10, Collections.emptyList());
        this.assertGeometryToBingTiles("GEOMETRYCOLLECTION EMPTY", 10, Collections.emptyList());
        this.assertGeometryToBingTiles("LINESTRING (-180 -79.19245, -180 -79.17133464081945)", 8, (List<String>)ImmutableList.of((Object)"22200000"));
        this.assertGeometryToBingTiles(String.format("POINT (%s 0)", -180.0), 5, (List<String>)ImmutableList.of((Object)"20000"));
        this.assertGeometryToBingTiles(String.format("POINT (0 %s)", 85.05112878), 5, (List<String>)ImmutableList.of((Object)"10000"));
        this.assertGeometryToBingTiles(String.format("POINT (%s %s)", -180.0, 85.05112878), 5, (List<String>)ImmutableList.of((Object)"00000"));
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Point(600, 30.12), 10)", "Longitude span for the geometry must be in [-180.00, 180.00] range");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_GeometryFromText('POLYGON ((1000 10, -10 10, -20 -15, 1000 10))'), 10)", "Longitude span for the geometry must be in [-180.00, 180.00] range");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Point(60, 300.12), 10)", "Latitude span for the geometry must be in [-85.05, 85.05] range");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_GeometryFromText('POLYGON ((10 1000, -10 10, -20 -15, 10 1000))'), 10)", "Latitude span for the geometry must be in [-85.05, 85.05] range");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Point(60, 30.12), -1)", "Zoom level must be >= 0");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Point(60, 30.12), 40)", "Zoom level must be <= 23");
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_Envelope(ST_GeometryFromText('LINESTRING (0 0, 80 80)')), 16)", "The zoom level is too high or the geometry is too large to compute a set of covering Bing tiles. Please use a lower zoom level, or tile only a section of the geometry.");
        this.assertFunction("cardinality(geometry_to_bing_tiles(ST_Envelope(ST_GeometryFromText('LINESTRING (0 0, 80 80)')), 5))", (Type)BigintType.BIGINT, 112L);
        String filePath = ResourceFileUtils.getResourceFile("too_large_polygon.txt").getAbsolutePath();
        String largeWkt = Files.lines(Paths.get(filePath, new String[0])).findFirst().get();
        this.assertFunction("cardinality(geometry_to_bing_tiles(ST_GeometryFromText('" + largeWkt + "'), 16))", (Type)BigintType.BIGINT, 9043L);
        this.assertFunction("cardinality(geometry_to_bing_tiles(ST_Envelope(ST_GeometryFromText('" + largeWkt + "')), 16))", (Type)BigintType.BIGINT, 19939L);
        this.assertInvalidFunction("geometry_to_bing_tiles(ST_GeometryFromText('POLYGON ((0 0, 0 20, 20 20, 0 0))'), 20)", "The zoom level is too high or the geometry is too large to compute a set of covering Bing tiles. Please use a lower zoom level, or tile only a section of the geometry.");
        this.assertFunction("cardinality(geometry_to_bing_tiles(ST_GeometryFromText('POLYGON ((0 0, 0 20, 20 20, 0 0))'), 14))", (Type)BigintType.BIGINT, 428788L);
    }

    private void assertToBingTiles(String sql, int zoomLevel, List<String> expectedQuadKeys) {
        this.assertFunction(String.format("array_sort(transform(geometry_to_bing_tiles(%s, %s), x -> bing_tile_quadkey(x)))", sql, zoomLevel), (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.sortedCopyOf(expectedQuadKeys));
    }

    private void assertGeometryToBingTiles(String wkt, int zoomLevel, List<String> expectedQuadKeys) {
        this.assertToBingTiles(String.format("ST_GeometryFromText('%s')", wkt), zoomLevel, expectedQuadKeys);
    }

    private void assertPointInCovering(String wkt, int zoomLevel, double x, double y) {
        String needle = String.format("geometry_to_bing_tiles(ST_Point(%s, %s), %s)[1]", x, y, zoomLevel);
        this.assertFunction(String.format("contains(geometry_to_bing_tiles(ST_GeometryFromText('%s'), %s), %s)", wkt, zoomLevel, needle), (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testEqual() {
        this.assertFunction("bing_tile(3, 5, 3) = bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile('213') = bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile('213') = bing_tile('213')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile(3, 5, 3) = bing_tile(3, 5, 4)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') = bing_tile('2131')", (Type)BooleanType.BOOLEAN, false);
    }

    @Test
    public void testNotEqual() {
        this.assertFunction("bing_tile(3, 5, 3) <> bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') <> bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') <> bing_tile('213')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile(3, 5, 3) <> bing_tile(3, 5, 4)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile('213') <> bing_tile('2131')", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testDistinctFrom() {
        this.assertFunction("null IS DISTINCT FROM null", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile(3, 5, 3) IS DISTINCT FROM null", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("null IS DISTINCT FROM bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile(3, 5, 3) IS DISTINCT FROM bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') IS DISTINCT FROM bing_tile(3, 5, 3)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile('213') IS DISTINCT FROM bing_tile('213')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("bing_tile(3, 5, 3) IS DISTINCT FROM bing_tile(3, 5, 4)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("bing_tile('213') IS DISTINCT FROM bing_tile('2131')", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testApproxDistinct() {
        this.assertApproxDistinct(1, "12");
        this.assertApproxDistinct(2, "12", "21");
        this.assertApproxDistinct(1, "12", "12");
        this.assertApproxDistinct(4, "012", "12", "120", "102");
        this.assertApproxDistinct(3, "012", "120", "012", "120", "111");
    }

    private void assertApproxDistinct(int expectedValue, String ... quadkeys) {
        List<Long> encodings = Arrays.stream(quadkeys).map(BingTile::fromQuadKey).map(BingTile::encode).collect(Collectors.toList());
        AggregationTestUtils.assertAggregation(this.approxDistinct, (Object)expectedValue, new Page(new Block[]{BlockAssertions.createTypedLongsBlock((Type)BingTileType.BING_TILE, encodings)}));
        Collections.reverse(encodings);
        AggregationTestUtils.assertAggregation(this.approxDistinct, (Object)expectedValue, new Page(new Block[]{BlockAssertions.createTypedLongsBlock((Type)BingTileType.BING_TILE, encodings)}));
        Collections.shuffle(encodings);
        AggregationTestUtils.assertAggregation(this.approxDistinct, (Object)expectedValue, new Page(new Block[]{BlockAssertions.createTypedLongsBlock((Type)BingTileType.BING_TILE, encodings)}));
    }
}

