/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.memory.LowMemoryKiller;
import com.facebook.presto.memory.LowMemoryKillerTestingUtils;
import com.facebook.presto.memory.TotalReservationLowMemoryKiller;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

@Test
public class TestTotalReservationLowMemoryKiller {
    private final LowMemoryKiller lowMemoryKiller = new TotalReservationLowMemoryKiller();

    @Test
    public void testGeneralPoolHasNoReservation() {
        int reservePool = 10;
        int generalPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_r", (Object)ImmutableMap.of((Object)"n1", (Object)6L, (Object)"n2", (Object)6L, (Object)"n3", (Object)6L, (Object)"n4", (Object)6L, (Object)"n5", (Object)6L)).build();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseQueryToKill(LowMemoryKillerTestingUtils.toQueryMemoryInfoList("q_r", (Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(reservePool, generalPool, "q_r", (Map<String, Map<String, Long>>)queries)), Optional.empty());
    }

    @Test
    public void testSkewedQuery() {
        int reservePool = 10;
        int generalPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)8L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)9L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_r", (Object)ImmutableMap.of((Object)"n1", (Object)6L, (Object)"n2", (Object)6L, (Object)"n3", (Object)6L, (Object)"n4", (Object)6L, (Object)"n5", (Object)6L)).build();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseQueryToKill(LowMemoryKillerTestingUtils.toQueryMemoryInfoList("q_r", (Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(reservePool, generalPool, "q_r", (Map<String, Map<String, Long>>)queries)), Optional.of(new QueryId("q_2")));
    }
}

