/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.nodeManager;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.nodeManager.PluginNodeManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.Node;
import java.net.URI;
import java.util.Arrays;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPluginNodeManager {
    private InMemoryNodeManager inMemoryNodeManager;
    private PluginNodeManager pluginNodeManager;

    @BeforeClass
    public void setUp() {
        this.inMemoryNodeManager = new InMemoryNodeManager();
        this.pluginNodeManager = new PluginNodeManager((InternalNodeManager)this.inMemoryNodeManager, "test-env");
    }

    @Test
    public void testGetAllNodes() {
        ConnectorId connectorId = new ConnectorId("test-connector");
        InternalNode activeNode1 = new InternalNode("activeNode1", URI.create("http://example1.com"), new NodeVersion("1"), false);
        InternalNode activeNode2 = new InternalNode("activeNode2", URI.create("http://example2.com"), new NodeVersion("1"), false);
        InternalNode coordinatorNode = new InternalNode("coordinatorNode", URI.create("http://example3.com"), new NodeVersion("1"), true);
        this.inMemoryNodeManager.addNode(connectorId, new InternalNode[]{activeNode1});
        this.inMemoryNodeManager.addNode(connectorId, new InternalNode[]{activeNode2});
        this.inMemoryNodeManager.addNode(connectorId, new InternalNode[]{coordinatorNode});
        Set allNodes = this.pluginNodeManager.getAllNodes();
        Assert.assertEquals((int)4, (int)allNodes.size());
        Assert.assertTrue((boolean)allNodes.containsAll(Arrays.asList(activeNode1, activeNode2, coordinatorNode)));
    }

    @Test
    public void testGetWorkerNodes() {
        ConnectorId connectorId = new ConnectorId("test-connector");
        InternalNode activeNode1 = new InternalNode("activeNode1", URI.create("http://example1.com"), new NodeVersion("1"), false);
        InternalNode activeNode2 = new InternalNode("activeNode2", URI.create("http://example2.com"), new NodeVersion("1"), false);
        this.inMemoryNodeManager.addNode(connectorId, new InternalNode[]{activeNode1});
        this.inMemoryNodeManager.addNode(connectorId, new InternalNode[]{activeNode2});
        Set workerNodes = this.pluginNodeManager.getWorkerNodes();
        Assert.assertEquals((int)3, (int)workerNodes.size());
        Assert.assertTrue((boolean)workerNodes.containsAll(Arrays.asList(activeNode1, activeNode2)));
    }

    @Test
    public void testGetEnvironment() {
        Assert.assertEquals((String)"test-env", (String)this.pluginNodeManager.getEnvironment());
    }

    @Test
    public void testGetCurrentNode() {
        Node currentNode = this.pluginNodeManager.getCurrentNode();
        Assert.assertNotNull((Object)currentNode);
        Assert.assertEquals((String)"local", (String)currentNode.getNodeIdentifier());
    }
}

