/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.block.ArrayAllocator;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockFlattener;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.operator.SimpleArrayAllocator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkBlockFlattener {
    @Benchmark
    public long benchmarkWithFlatten(FlattenContext context) {
        long sum = 0L;
        for (int i = 0; i < context.numberOfIterations; ++i) {
            try (BlockLease lease = context.flattener.flatten(context.block);){
                Block block = (Block)lease.get();
                for (int j = 0; j < context.blockSize; ++j) {
                    sum += (long)block.getInt(j);
                }
                continue;
            }
        }
        return sum;
    }

    @Benchmark
    public long benchmarkWithoutFlatten(BaseContext context) {
        int sum = 0;
        Block block = context.block;
        for (int i = 0; i < context.numberOfIterations; ++i) {
            for (int j = 0; j < context.blockSize; ++j) {
                sum += block.getInt(j);
            }
        }
        return sum;
    }

    @Test
    public void testBenchmarkWithFlatten() {
        FlattenContext context = new FlattenContext();
        context.setUp();
        this.benchmarkWithFlatten(context);
    }

    @Test
    public void testBenchmarkWithoutFlatten() {
        BaseContext context = new BaseContext();
        context.setUp();
        this.benchmarkWithoutFlatten(context);
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkBlockFlattener.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class FlattenContext
    extends BaseContext {
        private BlockFlattener flattener;
        @Param(value={"false", "true"})
        private boolean reuseArrays;

        @Override
        @Setup
        public void setUp() {
            super.setUp();
            this.flattener = this.reuseArrays ? new BlockFlattener((ArrayAllocator)new SimpleArrayAllocator()) : new BlockFlattener((ArrayAllocator)new ThrowawayArrayAllocator());
        }
    }

    @State(value=Scope.Thread)
    public static class BaseContext {
        protected Block block;
        @Param(value={"1000", "10000", "100000", "1000000"})
        protected int blockSize;
        @Param(value={"1", "2", "3", "4", "5"})
        protected int nestedLevel;
        @Param(value={"1", "10", "100", "1000"})
        protected int numberOfIterations;

        @Setup
        public void setUp() {
            int i;
            ThreadLocalRandom r = ThreadLocalRandom.current();
            int[] data = new int[this.blockSize];
            for (i = 0; i < this.blockSize; ++i) {
                data[i] = ((Random)r).nextInt(this.blockSize);
            }
            this.block = new IntArrayBlock(this.blockSize, Optional.empty(), data);
            for (i = 1; i < this.nestedLevel; ++i) {
                int[] ids = IntStream.range(0, this.blockSize).toArray();
                Collections.shuffle(Arrays.asList(new int[][]{ids}));
                this.block = new DictionaryBlock(this.block, ids);
            }
        }
    }

    private static class ThrowawayArrayAllocator
    implements ArrayAllocator {
        private ThrowawayArrayAllocator() {
        }

        public int[] borrowIntArray(int positionCount) {
            return new int[positionCount];
        }

        public void returnArray(int[] array) {
        }

        public byte[] borrowByteArray(int positionCount) {
            return new byte[positionCount];
        }

        public void returnArray(byte[] array) {
        }

        public int getBorrowedArrayCount() {
            return 0;
        }

        public long getEstimatedSizeInBytes() {
            return 0L;
        }
    }
}

