/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.MoreByteArrays;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import sun.misc.Unsafe;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkMoreByteArrays {
    @Benchmark
    public void fillToByteArray(BenchmarkData data) {
        MoreByteArrays.fill((byte[])data.bytes, (int)0, (int)data.bytes.length, (byte)5);
    }

    @Benchmark
    public void fillToBasicSliceOutput(BenchmarkData data) {
        data.basicSliceOutput.reset();
        for (int i = 0; i < data.bytes.length; ++i) {
            data.basicSliceOutput.writeByte(5);
        }
    }

    @Benchmark
    public void fillToDynamicSliceOutput(BenchmarkData data) {
        data.dynamicSliceOutput.reset();
        for (int i = 0; i < data.bytes.length; ++i) {
            data.dynamicSliceOutput.writeByte(5);
        }
    }

    @Benchmark
    public void setBytesToByteArray(BenchmarkData data) {
        MoreByteArrays.setBytes((byte[])data.bytes, (int)0, (byte[])data.byteValues, (int)0, (int)data.bytes.length);
    }

    @Benchmark
    public void setBytesToBasicSliceOutput(BenchmarkData data) {
        data.basicSliceOutput.reset();
        data.basicSliceOutput.writeBytes(data.slice, 0, data.slice.length());
    }

    @Benchmark
    public void setBytesToDynamicSliceOutput(BenchmarkData data) {
        data.dynamicSliceOutput.reset();
        data.dynamicSliceOutput.writeBytes(data.slice, 0, data.slice.length());
    }

    @Benchmark
    public void setIntsToByteArray(BenchmarkData data) {
        MoreByteArrays.setInts((byte[])data.bytes, (int)0, (int[])data.intValues, (int)0, (int)10000);
    }

    @Benchmark
    public void setIntsToBasicSliceOutput(BenchmarkData data) {
        data.basicSliceOutput.reset();
        for (int i = 0; i < 10000; ++i) {
            data.basicSliceOutput.writeInt(data.intValues[i]);
        }
    }

    @Benchmark
    public void setIntsToDynamicSliceOutput(BenchmarkData data) {
        data.dynamicSliceOutput.reset();
        for (int i = 0; i < 10000; ++i) {
            data.dynamicSliceOutput.writeInt(data.intValues[i]);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkMoreByteArrays.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int POSITIONS_PER_PAGE = 10000;
        private final Random random = new Random(0L);
        private final int[] intValues = IntStream.range(0, 10000).map(i -> this.random.nextInt()).toArray();
        private final byte[] byteValues = new byte[10000 * Unsafe.ARRAY_LONG_INDEX_SCALE];
        private final Slice slice = Slices.wrappedBuffer((byte[])this.byteValues);
        private final byte[] bytes = new byte[10000 * Unsafe.ARRAY_LONG_INDEX_SCALE];
        private final SliceOutput basicSliceOutput = Slices.wrappedBuffer((byte[])new byte[10000 * Unsafe.ARRAY_LONG_INDEX_SCALE]).getOutput();
        private final SliceOutput dynamicSliceOutput = new DynamicSliceOutput(10000 * Unsafe.ARRAY_LONG_INDEX_SCALE);

        @Setup
        public void setup() {
            this.random.nextBytes(this.byteValues);
        }
    }
}

