/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.spiller.StandaloneSpillerFactory;
import com.facebook.presto.spiller.TempStorageStandaloneSpillerFactory;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.storage.TempStorageManager;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTempStorageManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestAggregationOperator {
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
    private static final JavaAggregationFunctionImplementation LONG_AVERAGE = TestAggregationOperator.getAggregation("avg", new Type[]{BigintType.BIGINT});
    private static final JavaAggregationFunctionImplementation DOUBLE_SUM = TestAggregationOperator.getAggregation("sum", new Type[]{DoubleType.DOUBLE});
    private static final JavaAggregationFunctionImplementation LONG_SUM = TestAggregationOperator.getAggregation("sum", new Type[]{BigintType.BIGINT});
    private static final JavaAggregationFunctionImplementation REAL_SUM = TestAggregationOperator.getAggregation("sum", new Type[]{RealType.REAL});
    private static final JavaAggregationFunctionImplementation COUNT = TestAggregationOperator.getAggregation("count", new Type[]{BigintType.BIGINT});
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testAggregation() {
        JavaAggregationFunctionImplementation countVarcharColumn = TestAggregationOperator.getAggregation("count", new Type[]{VarcharType.VARCHAR});
        JavaAggregationFunctionImplementation maxVarcharColumn = TestAggregationOperator.getAggregation("max", new Type[]{VarcharType.VARCHAR});
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE, VarcharType.VARCHAR}).addSequencePage(100, 0, 0, 300, 500, 400, 500, 500).build();
        AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(0, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)COUNT, (List)ImmutableList.of((Object)0), Optional.empty()), (Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)LONG_SUM, (List)ImmutableList.of((Object)1), Optional.empty()), (Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)LONG_AVERAGE, (List)ImmutableList.of((Object)1), Optional.empty()), (Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)maxVarcharColumn, (List)ImmutableList.of((Object)2), Optional.empty()), (Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)countVarcharColumn, (List)ImmutableList.of((Object)0), Optional.empty()), (Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)LONG_SUM, (List)ImmutableList.of((Object)3), Optional.empty()), (Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)REAL_SUM, (List)ImmutableList.of((Object)4), Optional.empty()), (Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)DOUBLE_SUM, (List)ImmutableList.of((Object)5), Optional.empty()), (Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)maxVarcharColumn, (List)ImmutableList.of((Object)6), Optional.empty())), false);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, RealType.REAL, DoubleType.DOUBLE, VarcharType.VARCHAR}).row(new Object[]{100L, 4950L, 49.5, "399", 100L, 54950L, Float.valueOf(44950.0f), 54950.0, "599"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, input, expected);
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }

    @Test
    public void testDistinctMaskWithNull() {
        AccumulatorFactory distinctFactory = GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)COUNT, (List)ImmutableList.of((Object)0), Optional.of(1), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN), (List)ImmutableList.of(), (List)ImmutableList.of(), null, (boolean)true, (JoinCompiler)new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager()), (List)ImmutableList.of(), (boolean)false, (Session)SessionTestUtils.TEST_SESSION, (StandaloneSpillerFactory)new TempStorageStandaloneSpillerFactory((TempStorageManager)new TestingTempStorageManager(), (BlockEncodingSerde)new BlockEncodingManager(), new NodeSpillConfig(), new FeaturesConfig(), new SpillerStats()));
        AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(0, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)distinctFactory), false);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        ByteArrayBlock trueMaskAllNull = new ByteArrayBlock(4, Optional.of(new boolean[]{true, true, true, true}), new byte[]{1, 1, 1, 1});
        RunLengthEncodedBlock trueNullRleMask = new RunLengthEncodedBlock(trueMaskAllNull.getSingleValueBlock(0), 4);
        ImmutableList input = ImmutableList.of((Object)new Page(4, new Block[]{BlockAssertions.createLongsBlock(1, 2, 3, 4), trueMaskAllNull}), (Object)new Page(4, new Block[]{BlockAssertions.createLongsBlock(5, 6, 7, 8), trueNullRleMask}));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{0L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, driverContext, (List<Page>)input, expected);
    }

    @Test
    public void testMemoryTracking() throws Exception {
        this.testMemoryTracking(false);
        this.testMemoryTracking(true);
    }

    private void testMemoryTracking(boolean useSystemMemory) throws Exception {
        Page input = (Page)Iterables.getOnlyElement(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(100, 0).build());
        AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(0, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)LONG_SUM, (List)ImmutableList.of((Object)0), Optional.empty())), useSystemMemory);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        try (Operator operator = operatorFactory.createOperator(driverContext);){
            Assert.assertTrue((boolean)operator.needsInput());
            operator.addInput(input);
            if (useSystemMemory) {
                Assertions.assertThat((long)driverContext.getSystemMemoryUsage()).isGreaterThan(0L);
                Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
            } else {
                Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
                Assertions.assertThat((long)driverContext.getMemoryUsage()).isGreaterThan(0L);
            }
            OperatorAssertion.toPages(operator, Collections.emptyIterator());
        }
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }

    private static JavaAggregationFunctionImplementation getAggregation(String name, Type ... arguments) {
        return FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction(name, TypeSignatureProvider.fromTypes((Type[])arguments)));
    }
}

